package jp.igapyon.jcfa;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

import jp.igapyon.jcfa.util.JcfaEclipseUtil;

public class JcfaConstants {
	public static final String VERSION_PREFIX = "I";

	public static final String VERSION_FORMAT = "yyyyMMddHHmm";

	/**
	 * Version constants updater.
	 * 
	 * @param args
	 * @throws IOException
	 */
	public static final void main(final String[] args) throws IOException {
		System.err.println("JavaClassFileAnalyzer version constants updater.");
		System.err
				.println("  this program overwrite JcfaVersionConstants.java source file.");

		final StringBuffer source = new StringBuffer();
		source.append("package jp.igapyon.jcfa;\n");
		source.append("/* This source file is generated by JavaClassFileAnalyzer. */\n");
		source.append("/* Do not modify this source file. */\n");
		source.append("public class JcfaVersionConstants {");
		source.append("public static final String VERSION = \""
				+ VERSION_PREFIX
				+ new SimpleDateFormat(VERSION_FORMAT).format(new Date())
				+ "\";");
		source.append("public static final String getVersion() {");
		source.append("return VERSION;");
		source.append("}");
		source.append("}");

		final BufferedWriter writer = new BufferedWriter(
				new OutputStreamWriter(
						new FileOutputStream(
								"./src.generated/jp/igapyon/jcfa/JcfaVersionConstants.java"),
						"UTF-8"));
		writer.write(JcfaEclipseUtil.formatSource(source.toString()));
		writer.close();
	}
}
