package jp.igapyon.jcfa;

import java.io.File;
import java.io.IOException;

import jp.igapyon.jcfa.util.JcfaWriteUtil;
import jp.igapyon.jcfa.vo.JcfaUnit;

public class JavaClassFileAnalyzer {
	/**
	 * JavaClassFileAnalyzer: entry point.
	 * 
	 * @param args
	 * @throws IOException
	 */
	public static final void main(final String[] args) throws IOException {
		System.err.println("JavaClassFileAnalyzer ("
				+ JcfaVersionConstants.getVersion() + ")");

		new JavaClassFileAnalyzer().parseDir(new File("./bin/test"));
		new JavaClassFileAnalyzer().parseDir(new File(
				"./bin/jp/igapyon/jcfa/vo"));

		System.err.println("JavaClassFileAnalyzer ("
				+ JcfaVersionConstants.getVersion() + "): done.");
	}

	private void parseDir(final File dir) throws IOException {
		final File[] files = dir.listFiles();
		if (files == null) {
			return;
		}
		for (File file : files) {
			if (file.isDirectory()) {
				parseDir(file);
			}
			if (file.isFile()) {
				if (file.getName().endsWith(".class")) {
					new JavaClassFileAnalyzer().process(file, new File(
							"./testJavaClass/output"));
				}
			}
		}
	}

	private final void process(final File inputFile, final File outputDir)
			throws IOException {
		final JcfaUnit jcfaUnit = new JcfaParser().parseUnit(inputFile,
				outputDir);

		JcfaWriteUtil.writeToFile(jcfaUnit);
	}
}