﻿/* テスト */
/*
 * File: effects.h
 * Purpose: List of effect types
 *
 * Copyright (c) 2007 Andrew Sidwell
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
#ifndef INCLUDED_EFFECTS_H
#define INCLUDED_EFFECTS_H

/* Types of effect */
/* Types of effect */
typedef enum
{
	#define EFFECT(w, x, r, y, z)              EF_##w,
	#include "list-effects.h"
	#undef EFFECT

	EF_MAX
} effect_type;

/*** Functions ***/

bool effect_do(int effect, bool *ident, bool aware, int dir, int beam);
bool effect_aim(int effect);
const _TCHAR *effect_desc(int effect);
int effect_power(int effect);
bool effect_obvious(int effect);
bool effect_wonder(int dir, int die, int beam);

#endif /* INCLUDED_EFFECTS_H */
