﻿/* テスト */
/* 
 * Debug Status: Not checked. 
 * - Fixed __T on this page.
 *
 * Translation Status: 
 * - First draft finished on this page.
 * - External text tables are also used and those are not translated.
 * - Probably will need reworking later to account for different hit verbs.
 */
/*
 * File: attack.c
 * Purpose: Attacking (both throwing and melee) code
 *
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
extern "C" 
{
#include "angband.h"
}
#include "object/object.h"
#include "object/tvalsval.h"
#include "game-cmd.h"

extern bool get_item(int *cp, const _TCHAR *pmt, const _TCHAR *str, int mode);
extern void redraw_stuff(void);
extern void msg_print(const _TCHAR *msg);
extern size_t object_desc(_TCHAR *buf, size_t max, const object_type *o_ptr, bool prefix, int mode);

/* 
 * Convenience function.
 * Inserts a command with params in the queue to be carried out. 
 */
errr cmd_insert(cmd_code c, ...);

/**
 * Determines how likely an object is to break on throwing or shooting.
 *
 * \returns percentage change of breaking
 */
int breakage_chance(const object_type *o_ptr)
{
	/* Artifacts never break */
	if (artifact_p(o_ptr))
		return 0;

	switch (o_ptr->tval)
	{
		case TV_FLASK:
		case TV_POTION:
		case TV_BOTTLE:
		case TV_FOOD:
		case TV_JUNK:
			return 100;

		case TV_LITE:
		case TV_SCROLL:
		case TV_SKELETON:
			return 50;

		case TV_ARROW:
			return 35;

		case TV_WAND:
		case TV_SHOT:
		case TV_BOLT:
		case TV_SPIKE:
			return 25;

		default:
			return 10;
	}
}

/*
 * Determine if the player "hits" a monster.
 *
 * Note -- Always miss 5%, always hit 5%, otherwise random.
 */
bool test_hit(int chance, int ac, int vis)
{
	int k;

	/* Percentile dice */
	k = randint0(100);

	/* Hack -- Instant miss or hit */
	if (k < 10) 
		return (k < 5);

	/* Penalize invisible targets */
	if (!vis) 
		chance = chance / 2;

	/* Power competes against armor */
	if ((chance > 0) && (randint0(chance) >= (ac * 3 / 4))) 
		return (TRUE);

	/* Assume miss */
	return (FALSE);
}

/*
 * Critical hits (from objects thrown by player)
 * Factor in item weight, total plusses, and player level.
 */
static int critical_shot(int weight, int plus, int dam)
{
	int i, k;

	/* Extract "shot" power */
	i = (weight + ((p_ptr->state.to_h + plus) * 4) + (p_ptr->lev * 2));

	/* Critical hit */
	if (randint1(5000) <= i)
	{
		_TCHAR langbuf[200];
		k = weight + randint1(500);

		if (k < 500)
		{
			msg_print(LS(__T("It was a good hit!"),
						spaceme(langbuf, __T("手ごたえがあった。")))); /* Translation TBC */
			dam = 2 * dam + 5;
		}
		else if (k < 1000)
		{
			msg_print(LS(__T("It was a great hit!"),
						spaceme(langbuf, __T("かなり手ごたえがあった。")))); /* Translation TBC */
			dam = 2 * dam + 10;
		}
		else
		{
			msg_print(LS(__T("It was a superb hit!"),
						spaceme(langbuf, __T("会心の一撃だった。")))); /* Translation TBC */
			dam = 3 * dam + 15;
		}
	}
	return (dam);
}

/*
 * Critical hits (by player)
 *
 * Factor in weapon weight, total plusses, player level.
 */
static int critical_norm(int weight, int plus, int dam)
{
	int i, k;

	/* Extract "blow" power */
	i = (weight + ((p_ptr->state.to_h + plus) * 5) + (p_ptr->lev * 3));

	/* Chance */
	if (randint1(5000) <= i)
	{
		_TCHAR langbuf[200];
		k = weight + randint1(650);

		if (k < 400)
		{
			sound(MSG_HIT_GOOD);
			msg_print(LS(__T("It was a good hit!"),
						spaceme(langbuf, __T("手ごたえがあった。")))); /* Translation TBC */
			dam = 2 * dam + 5;
		}
		else if (k < 700)
		{
			sound(MSG_HIT_GREAT);
			msg_print(LS(__T("It was a great hit!"),
						spaceme(langbuf, __T("かなり手ごたえがあった。")))); /* Translation TBC */
			dam = 2 * dam + 10;
		}
		else if (k < 900)
		{
			sound(MSG_HIT_SUPERB);
			msg_print(LS(__T("It was a superb hit!"),
						spaceme(langbuf, __T("会心の一撃だった。")))); /* Translation TBC */
			dam = 3 * dam + 15;
		}
		else if (k < 1300)
		{
			sound(MSG_HIT_HI_GREAT);
			msg_print(LS(__T("It was a *GREAT* hit!"),
						spaceme(langbuf, __T("最高の会心の一撃だった。")))); /* Translation TBC */
			dam = 3 * dam + 20;
		}
		else
		{
			sound(MSG_HIT_HI_SUPERB);
			msg_print(LS(__T("It was a *SUPERB* hit!"),
						spaceme(langbuf, __T("比類無き最高の会心の一撃だった。")))); /* Translation TBC */
			dam = ((7 * dam) / 2) + 25;
		}
	}
	else
	{
		sound(MSG_HIT);
	}
	return (dam);
}

/**
 * Extract the multiplier from a given object hitting a given monster.
 *
 * If there is a slay or brand in effect, change the verb for hitting
 * to something interesting ('burn', 'smite', etc.).  Also, note which
 * flags had an effect in o_ptr->known_flags[].
 *
 * \param o_ptr is the object being used to attack
 * \param m_ptr is the monster being attacked
 * \param hit_verb is where a new verb is returned
 * \param is_ranged should be true for ranged attacks
 *
 * \returns attack multiplier
 */
static int get_brand_mult(object_type *o_ptr, const monster_type *m_ptr,
		const _TCHAR **hit_verb, bool is_ranged, bool secondary)
{
	int mult = 1;
	const slay_t *s_ptr;

	monster_race *r_ptr = &r_info[m_ptr->r_idx];
	monster_lore *l_ptr = &l_list[m_ptr->r_idx];

	u32b f[OBJ_FLAG_N];
	object_flags(o_ptr, f);

	for (s_ptr = slay_table; s_ptr->slay_flag; s_ptr++)
	{
		if (!(f[0] & s_ptr->slay_flag)) continue;

		/* If the monster doesn't match or the slay flag does */
		if ((s_ptr->brand && !(r_ptr->flags[2] & s_ptr->resist_flag)) || 
			(r_ptr->flags[2] & s_ptr->monster_flag))
		{
			/* Learn the flag */
			if (m_ptr->ml)
				l_ptr->flags[2] |= s_ptr->monster_flag;

			if (mult < s_ptr->mult)
				mult = s_ptr->mult;

			/* Set the hit verb appropriately */
			if (is_ranged)
				*hit_verb = s_ptr->range_verb;
			else
				*hit_verb = s_ptr->melee_verb;

			/* Do something a bit cleverer here */
			o_ptr->known_flags[0] |= s_ptr->slay_flag;

			/* Print a cool message for branded rings et al */
			if (s_ptr->active_verb[arg_language] && secondary)
			{
				_TCHAR o_name[40];
				_TCHAR langbuf[200];
				object_desc(o_name, _countof(o_name), o_ptr,
						FALSE, ODESC_BASE);
				msg_format(spaceme(langbuf, s_ptr->active_verb[arg_language]), o_name);
			}
		}
		/* If the monster resisted, add to the monster lore */
		if (r_ptr->flags[2] & s_ptr->resist_flag)
		{
			if (m_ptr->ml)
				l_ptr->flags[2] |= s_ptr->resist_flag;
		}
	}
	return mult;
}

/*
 * Attack the monster at the given location
 *
 * If no "weapon" is available, then "punch" the monster one time.
 */
void py_attack(int y, int x)
{
	int num = 0, bonus, chance;
	_TCHAR langbuf[200];

	monster_type *m_ptr;
	monster_race *r_ptr;
	monster_lore *l_ptr;

	object_type *o_ptr;

	_TCHAR m_name[80];

	bool fear = FALSE;

	bool do_quake = FALSE;

	/* Get the monster */
	m_ptr = &mon_list[cave_m_idx[y][x]];
	r_ptr = &r_info[m_ptr->r_idx];
	l_ptr = &l_list[m_ptr->r_idx];

	/* Disturb the player */
	disturb(0, 0);

	/* Extract monster name (or "it") */
	monster_desc(m_name, _countof(m_name), m_ptr, 0);

	/* Auto-Recall if possible and visible */
	if (m_ptr->ml) 
		monster_race_track(m_ptr->r_idx);

	/* Track a new monster */
	if (m_ptr->ml) 
		health_track(cave_m_idx[y][x]);

	/* Disturb the monster */
	wake_monster(m_ptr);

	/* Get the weapon */
	o_ptr = &inventory[INVEN_WIELD];

	/* Calculate the "attack quality" */
	bonus = p_ptr->state.to_h + o_ptr->to_h;
	chance = (p_ptr->state.skills[SKILL_TO_HIT_MELEE] + (bonus * BTH_PLUS_ADJ));

	/* Attack once for each legal blow */
	while (num++ < p_ptr->state.num_blow)
	{
		/* Test for hit */
		if (test_hit(chance, r_ptr->ac, m_ptr->ml))
		{
			/* Default to punching for one damage */
			const _TCHAR *hit_verb = LS(__T("You punch %s."),
				        __T("%sを殴った。")); /* Translation TBC */
			int k = 1;

			/* Handle normal weapon */
			if (o_ptr->k_idx)
			{
				int weapon_brand_mult, ring_brand_mult[2];
				int use_mult = 1;

				hit_verb = LS(__T("You hit %s."),
					          __T("%sに当たった。")); /* Translation TBC */

				/* Hack-- put rings first, because they can
				 * only be brands right now */
				ring_brand_mult[0] = get_brand_mult(
						&inventory[INVEN_LEFT],
						m_ptr, &hit_verb, FALSE, TRUE);
				ring_brand_mult[1] = get_brand_mult(
						&inventory[INVEN_RIGHT],
						m_ptr, &hit_verb, FALSE, TRUE);
				weapon_brand_mult = get_brand_mult(
						o_ptr,
						m_ptr, &hit_verb, FALSE, FALSE);
				/*
				 * Message. Need to do this after tot_dam_aux, which sets hit_verb, but 
				 * before critical_norm, which may print further messages. 
				 */
				message_format(MSG_GENERIC, m_ptr->r_idx, hit_verb, m_name);
						
				if (ring_brand_mult[0] > use_mult)
					use_mult = ring_brand_mult[0];
				if (ring_brand_mult[1] > use_mult)
					use_mult = ring_brand_mult[1];
				if (weapon_brand_mult > use_mult)
					use_mult = weapon_brand_mult;

				k = damroll(o_ptr->dd, o_ptr->ds);
				k *= use_mult;

				if (p_ptr->state.impact && (k > 50))
					do_quake = TRUE;

				k += o_ptr->to_d;
				k = critical_norm(o_ptr->weight, o_ptr->to_h, k);

				/* Learn by use */
				object_notice_on_attack();
				if (do_quake)
					object_notice_flag(2, TR2_IMPACT);
			}
			else
			{
				message_format(MSG_GENERIC, m_ptr->r_idx, hit_verb, m_name);
			}
			/* Apply the player damage bonuses */
			k += p_ptr->state.to_d;

			/* No negative damage */
			if (k < 0) k = 0;

			/* Complex message */
			if (p_ptr->wizard)
				msg_format(LS(          __T("You do %d (out of %d) damage."), /* Translation TBC */
						spaceme(langbuf,__T("%dから%dダメージを与えた。"))),  /* TODO "%2$dから%1$dダメージを与えた。" */
						k, m_ptr->hp);

			/* Damage, check for fear and death */
			if (mon_take_hit(cave_m_idx[y][x], k, &fear, NULL)) break;

			/* Confusion attack */
			if (p_ptr->confusing)
			{
				_TCHAR langbuf[200];
				/* Cancel glowing hands */
				p_ptr->confusing = FALSE;

				/* Message */
				msg_print(        LS(__T("Your hands stop glowing."),
					spaceme(langbuf, __T("手の輝きがなくなった。")))); /* Translation TBC */

				/* Confuse the monster */
				if (r_ptr->flags[2] & (RF2_NO_CONF))
				{
					if (m_ptr->ml)
					{
						l_ptr->flags[2] |= (RF2_NO_CONF);
					}
					msg_format(          LS(__T("%^s is unaffected."), /* Translation TBC */
							spaceme(langbuf,__T("%^sには効果がなかった。"))), m_name);
				}
				else if (randint0(100) < r_ptr->level)
				{
					msg_format(          LS(__T("%^s is unaffected."), /* Translation TBC */
							spaceme(langbuf,__T("%^sには効果がなかった。"))), m_name);
				}
				else
				{
					msg_format(          LS(__T("%^s appears confused."), /* Translation TBC */
							spaceme(langbuf,__T("%^sが混乱しているようだ。"))), m_name);
					m_ptr->confused += 10 + (byte) randint0(p_ptr->lev) / 5;
				}
			}
		}
		else /* Player misses */
		{
			/* Message */
			message_format(MSG_MISS, m_ptr->r_idx, 
				             LS(__T("You miss %s."),
				spaceme(langbuf,__T("%sに当たらなかった。"))), m_name); /* Translation TBC */
		}
	}
	/* Hack -- delay fear messages */
	if (fear && m_ptr->ml)
	{
		/* Message */
		message_format(MSG_FLEE, m_ptr->r_idx, 
			             LS(__T("%^s flees in terror!"),
			spaceme(langbuf,__T("%^sが怖くなって逃げ出した。"))), m_name); /* Translation TBC */
	}
	/* Mega-Hack -- apply earthquake brand */
	if (do_quake) earthquake(p_ptr->py, p_ptr->px, 10);
}

/*
 * Fire an object from the pack or floor.
 *
 * You may only fire items that "match" your missile launcher.
 *
 * See "calc_bonuses()" for more calculations and such.
 *
 * Note that "firing" a missile is MUCH better than "throwing" it.
 *
 * Note: "unseen" monsters are very hard to hit.
 *
 * Objects are more likely to break if they "attempt" to hit a monster.
 *
 * Rangers (with Bows) and Anyone (with "Extra Shots") get extra shots.
 * The "extra shot" code works by decreasing the amount of energy
 * required to make each shot, spreading the shots out over time.
 *
 * Note that when firing missiles, the launcher multiplier is applied
 * after all the bonuses are added in, making multipliers very useful.
 *
 * Note that Bows of "Extra Might" get extra range and an extra bonus
 * for the damage multiplier.
 */
void do_cmd_fire(cmd_code code, cmd_arg args[])
{
	int dir, item;
	int i, j, y, x;
	s16b ty, tx;
	int tdam, tdis, thits;
	int bonus, chance;
	_TCHAR langbuf[200];

	object_type *o_ptr;
	object_type *j_ptr;

	object_type *i_ptr;
	object_type object_type_body;

	bool hit_body = FALSE;

	byte missile_attr;
	char missile_char;

	_TCHAR o_name[80];

	int path_n;
	u16b path_g[256];

	int msec = op_ptr->delay_factor * op_ptr->delay_factor;

	/* Get item to fire and direction to fire in. */ 
 	item = args[0].item; 
 	dir = args[1].direction; 
 	
 	/* Get the object for the ammo */ 
 	o_ptr = object_from_item_idx(item);

	/* Get the "bow" (if any) */
	j_ptr = &inventory[INVEN_BOW];

	/* Base range XXX XXX */
	tdis = 6 + 2 * p_ptr->state.ammo_mult;

	/* Start at the player */
	x = p_ptr->px;
	y = p_ptr->py;

	/* Predict the "target" location */
	ty = y + 99 * ddy[dir];
	tx = x + 99 * ddx[dir];

	/* Check for target validity */
	if ((dir == 5) && target_okay())
	{
		target_get(&tx, &ty);
		if (distance(y, x, ty, tx) > tdis)
		{
			msg_print(LS(__T("Target out of range"), /* Translation TBC */
				spaceme(langbuf, __T("目標が範囲外だ。"))));
			return;
		}
	}
	/* Sound */
	sound(MSG_SHOOT);

	/* Describe the object */
	object_desc(o_name, _countof(o_name), o_ptr, FALSE,
			ODESC_FULL | ODESC_SINGULAR);

	/* Find the color and symbol for the object for throwing */
	missile_attr = object_attr(o_ptr);
	missile_char = object_char(o_ptr);

	/* Use the proper number of shots */
	thits = p_ptr->state.num_fire;

	/* Actually "fire" the object */
	bonus = (p_ptr->state.to_h + o_ptr->to_h + j_ptr->to_h);
	chance = p_ptr->state.skills[SKILL_TO_HIT_BOW] +
			(bonus * BTH_PLUS_ADJ);

	/* Take a (partial) turn */
	p_ptr->energy_use = (100 / thits);

	/* Calculate the path */
	path_n = project_path(path_g, tdis, y, x, ty, tx, 0);

	/* Hack -- Handle stuff */
	handle_stuff();

	/* Project along the path */
	for (i = 0; i < path_n; ++i)
	{
		int ny = GRID_Y(path_g[i]);
		int nx = GRID_X(path_g[i]);

		/* Hack -- Stop before hitting walls */
		if (!cave_floor_bold(ny, nx)) break;

		/* Advance */
		x = nx;
		y = ny;

		/* Only do visuals if the player can "see" the missile */
		if (player_can_see_bold(y, x))
		{
			/* Visual effects */
			print_rel(missile_char, missile_attr, y, x);
			move_cursor_relative(y, x);

			Term_fresh();
			if (p_ptr->redraw) redraw_stuff();

			Term_xtra(TERM_XTRA_DELAY, msec);
			lite_spot(y, x);

			Term_fresh();
			if (p_ptr->redraw) redraw_stuff();
		}
		else /* Delay anyway for consistency */
		{
			/* Pause anyway, for consistancy */
			Term_xtra(TERM_XTRA_DELAY, msec);
		}
		/* Handle monster */
		if (cave_m_idx[y][x] > 0)
		{
			monster_type *m_ptr = &mon_list[cave_m_idx[y][x]];
			monster_race *r_ptr = &r_info[m_ptr->r_idx];

			int chance2 = chance - distance(p_ptr->py, p_ptr->px, y, x);
			int visible = m_ptr->ml;

			const _TCHAR *hit_verb = LS(__T("hits"),
					spaceme(langbuf,    __T("当たった。"))); /* Translation TBC */

			int ammo_mult = get_brand_mult(o_ptr, m_ptr,
					&hit_verb, TRUE, FALSE);
			int shoot_mult = get_brand_mult(j_ptr, m_ptr,
					&hit_verb, TRUE, FALSE);

			/* Note the collision */
			hit_body = TRUE;

			/* Did we hit it (penalize distance travelled) */
			if (test_hit(chance2, r_ptr->ac, m_ptr->ml))
			{
				bool fear = FALSE;

				/* Assume a default death */ 
				const _TCHAR *note_dies = LS(__T(" dies."), /* Translation TBC */
					         spaceme(langbuf,__T("が死んだ"))); 

				/* Some monsters get "destroyed" */
				if ((r_ptr->flags[2] & RF2_DEMON) ||
						(r_ptr->flags[2] & RF2_UNDEAD) ||
						(r_ptr->flags[1] & RF1_STUPID) ||
						_tcschr(__T("Evg"), r_ptr->d_char))
				{
					/* Special note at death */
					note_dies =      LS(__T(" is destroyed."), /* Translation TBC */
						spaceme(langbuf,__T("が破壊された。")));
				}
				/* Handle unseen monster */
				if (!visible)
				{
					/* Invisible monster */
					message_format(MSG_SHOOT_HIT, 0, LS(__T("The %s finds a mark."), /* Translation TBC */
							spaceme(langbuf,            __T("%s が何かに当たった。"))), o_name); 
				}
				else /* Handle visible monster */
				{
					_TCHAR m_name[80];

					/* Get "the monster" or "it" */
					monster_desc(m_name, _countof(m_name), m_ptr, 0);

					/* Message */ /* The arrow hits the monster */
					message_format(MSG_SHOOT_HIT, 0, 
							LS(__T("The %s %s %s."), /* Translation TBC */ /* 矢がモンスターに当たった */
							spaceme(langbuf,__T("%sが%sに%s。"))), /* TODO "%sが%3$sに%2$s。" */
							o_name, hit_verb, m_name);

					/* Hack -- Track this monster race */
					if (m_ptr->ml) monster_race_track(m_ptr->r_idx);

					/* Hack -- Track this monster */
					if (m_ptr->ml) health_track(cave_m_idx[y][x]);
				}
				/* Apply damage: multiplier, slays, criticals, bonuses */
				tdam = damroll(o_ptr->dd, o_ptr->ds);
				tdam += o_ptr->to_d + j_ptr->to_d;
				tdam *= p_ptr->state.ammo_mult;
				tdam *= MAX(ammo_mult, shoot_mult);
				tdam = critical_shot(o_ptr->weight, o_ptr->to_h, tdam);

				/* No negative damage */
				if (tdam < 0) tdam = 0;

				/* Complex message */
				if (p_ptr->wizard)
				{
					msg_format(LS(          __T("You do %d (out of %d) damage."), /* Translation TBC */
						spaceme(langbuf,__T("%dから%dダメージを与えた。"))), /* TODO "%2$dから%1$dダメージを与えた。" */
						tdam, m_ptr->hp);
				}
				/* Hit the monster, check for death */
				if (mon_take_hit(cave_m_idx[y][x], tdam, &fear, note_dies))
				{
					/* Dead monster */
				}
				else /* No death */
				{
					/* Message */
					message_pain(cave_m_idx[y][x], tdam);

					/* Take note */
					if (fear && m_ptr->ml)
					{
						_TCHAR m_name[80];

						/* Get the monster name (or "it") */
						monster_desc(m_name, _countof(m_name), m_ptr, 0);

						/* Message */
						message_format(MSG_FLEE, m_ptr->r_idx,
								LS(             __T("%^s flees in terror!"),
								spaceme(langbuf,__T("%^sが怖くなって逃げ出した。"))), m_name); /* Translation TBC */
					}
				}
			}
			/* Stop looking */
			break;
		}
	}
	/* Get local object */
	i_ptr = &object_type_body;

	/* Obtain a local object */
	object_copy(i_ptr, o_ptr);

	/* Single object */
	i_ptr->number = 1;

	/* Reduce and describe inventory */
	if (item >= 0)
	{
		inven_item_increase(item, -1);
		inven_item_describe(item);
		inven_item_optimize(item);
	}
	else /* Reduce and describe floor item */
	{
		floor_item_increase(0 - item, -1);
		floor_item_optimize(0 - item);
	}
	/* Chance of breakage (during attacks) */
	j = (hit_body ? breakage_chance(i_ptr) : 0);

	/* Drop (or break) near that location */
	drop_near(i_ptr, j, y, x);
}

void textui_cmd_fire(void)
{ 
	object_type *j_ptr, *o_ptr; 
	int item; 
	int dir; 
	const _TCHAR *q;
	const _TCHAR *s; 
	_TCHAR langbuf[200];

	/* Get the "bow" (if any) */ 
	j_ptr = &inventory[INVEN_BOW]; 

	/* Require a usable launcher */ 
	if (!j_ptr->tval || !p_ptr->state.ammo_tval) 
	{ 
		msg_print(LS(__T("You have nothing to fire with."), /* Translation TBC */
			spaceme(langbuf, __T("遠距離攻撃武器がない。"))));
		return; 
	}
	/* Require proper missile */ 
	item_tester_tval = p_ptr->state.ammo_tval; 

	/* Get an item */ 
	q = LS(__T("Fire which item? "),
		spaceme(langbuf, __T("どの武器で射撃するか。")));  /* Translation TBC */
	s = LS(__T("You have nothing to fire."),
		spaceme(langbuf, __T("矢などがない。")));  /* Translation TBC */
	if (!get_item(&item, q, s, (USE_INVEN | USE_FLOOR))) 
		return; 

	/* Get the object */ 
	o_ptr = object_from_item_idx(item); 

	/* Get a direction (or cancel) */ 
	if (!get_aim_dir(&dir)) 
		return; 

	cmd_insert(CMD_FIRE, item, dir); 
}

/*
 * Throw an object from the pack or floor.
 *
 * Note: "unseen" monsters are very hard to hit.
 *
 * Should throwing a weapon do full damage?  Should it allow the magic
 * to hit bonus of the weapon to have an effect?  Should it ever cause
 * the item to be destroyed?  Should it do any damage at all?
 */
void do_cmd_throw(cmd_code code, cmd_arg args[])
{
	int dir, item;
	int i, j, y, x;
	s16b ty, tx;
	int chance, tdam, tdis;
	int weight;
	_TCHAR langbuf[200];

	object_type *o_ptr;

	object_type *i_ptr;
	object_type object_type_body;

	bool hit_body = FALSE;

	byte missile_attr;
	char missile_char;

	_TCHAR o_name[80];

	int path_n;
	u16b path_g[256];

	int msec = op_ptr->delay_factor * op_ptr->delay_factor;

	/* Get item to throw and direction in which to throw it. */ 
	item = args[0].item; 
	dir = args[1].direction; 

	/* Get the object */
	o_ptr = object_from_item_idx(item);

	/* Get local object */
	i_ptr = &object_type_body;

	/* Obtain a local object */
	object_copy(i_ptr, o_ptr);

	/* Distribute the charges of rods/wands/staves between the stacks */
	distribute_charges(o_ptr, i_ptr, 1);

	/* Single object */
	i_ptr->number = 1;

	/* Reduce and describe inventory */
	if (item >= 0)
	{
		inven_item_increase(item, -1);
		inven_item_describe(item);
		inven_item_optimize(item);
	}
	else /* Reduce and describe floor item */
	{
		floor_item_increase(0 - item, -1);
		floor_item_optimize(0 - item);
	}
	/* Description */
	object_desc(o_name, _countof(o_name), i_ptr, FALSE, ODESC_FULL);

	/* Find the color and symbol for the object for throwing */
	missile_attr = object_attr(i_ptr);
	missile_char = object_char(i_ptr);

	/* Enforce a minimum "weight" of one pound */
	weight = ((i_ptr->weight > 10) ? i_ptr->weight : 10);

	/* Hack -- Distance -- Reward strength, penalize weight */
	tdis = (adj_str_blow[p_ptr->state.stat_ind[A_STR]] + 20) * 10 / weight;

	/* Max distance of 10 */
	if (tdis > 10) tdis = 10;

	/* Hack -- Base damage from thrown object */
	tdam = damroll(i_ptr->dd, i_ptr->ds);
	if (!tdam) tdam = 1;
	tdam += i_ptr->to_d;

	/* Chance of hitting */
	chance = (p_ptr->state.skills[SKILL_TO_HIT_THROW] + (p_ptr->state.to_h * BTH_PLUS_ADJ));

	/* Take a turn */
	p_ptr->energy_use = 100;

	/* Start at the player */
	y = p_ptr->py;
	x = p_ptr->px;

	/* Predict the "target" location */
	ty = p_ptr->py + 99 * ddy[dir];
	tx = p_ptr->px + 99 * ddx[dir];

	/* Check for "target request" */
	if ((dir == 5) && target_okay())
	{
		target_get(&tx, &ty);
	}
	/* Calculate the path */
	path_n = project_path(path_g, tdis, p_ptr->py, p_ptr->px, ty, tx, 0);

	/* Hack -- Handle stuff */
	handle_stuff();

	/* Project along the path */
	for (i = 0; i < path_n; ++i)
	{
		int ny = GRID_Y(path_g[i]);
		int nx = GRID_X(path_g[i]);

		/* Hack -- Stop before hitting walls */
		if (!cave_floor_bold(ny, nx)) break;

		/* Advance */
		x = nx;
		y = ny;

		/* Only do visuals if the player can "see" the missile */
		if (player_can_see_bold(y, x))
		{
			/* Visual effects */
			print_rel(missile_char, missile_attr, y, x);
			move_cursor_relative(y, x);

			Term_fresh();
			if (p_ptr->redraw) redraw_stuff();

			Term_xtra(TERM_XTRA_DELAY, msec);
			lite_spot(y, x);

			Term_fresh();
			if (p_ptr->redraw) redraw_stuff();
		}
		else /* Delay anyway for consistency */
		{
			/* Pause anyway, for consistancy */
			Term_xtra(TERM_XTRA_DELAY, msec);
		}
		/* Handle monster */
		if (cave_m_idx[y][x] > 0)
		{
			monster_type *m_ptr = &mon_list[cave_m_idx[y][x]];
			monster_race *r_ptr = &r_info[m_ptr->r_idx];

			int chance2 = chance - distance(p_ptr->py, p_ptr->px, y, x);

			int visible = m_ptr->ml;

			/* Note the collision */
			hit_body = TRUE;

			/* Did we hit it (penalize range) */
			if (test_hit(chance2, r_ptr->ac, m_ptr->ml))
			{
				const _TCHAR *hit_verb = LS(__T("hits"),
						spaceme(langbuf,    __T("当たった。")));
				bool fear = FALSE;

				/* Assume a default death */
				const _TCHAR *note_dies = LS(__T(" dies."), /* Translation TBC */
					         spaceme(langbuf,__T("が死んだ"))); 

				/* Some monsters get "destroyed" */
				if ((r_ptr->flags[2] & (RF2_DEMON)) ||
				    (r_ptr->flags[2] & (RF2_UNDEAD)) ||
				    (r_ptr->flags[1] & (RF1_STUPID)) ||
				    (_tcschr(__T("Evg"), r_ptr->d_char)))
				{
					/* Special note at death */
					note_dies =      LS(__T(" is destroyed."), /* Translation TBC */
						spaceme(langbuf,__T("が破壊された。")));
				}
				/* Apply special damage  - brought forward to fill in hit_verb XXX XXX XXX */
				tdam *= get_brand_mult(i_ptr, m_ptr,
						&hit_verb, TRUE, FALSE);

				/* Handle unseen monster */
				if (!visible)
				{
					/* Invisible monster */
					msg_format(LS(          __T("The %s finds a mark."), /* Translation TBC */
							spaceme(langbuf,__T("%s が何かに当たった。"))), o_name); 
				}
				else /* Handle visible monster */
				{
					_TCHAR m_name[80];

					/* Get "the monster" or "it" */
					monster_desc(m_name, _countof(m_name), m_ptr, 0);

					/* Message */ /* The arrow hits the monster */
					message_format(MSG_SHOOT_HIT, 0, /* 矢がモンスターに当たった */
							LS(__T("The %s %s %s."), /* Translation TBC */
							spaceme(langbuf,__T("%sが%sに%s。"))), /* TODO "%sが%3$sに%2$s。" */
							o_name, hit_verb, m_name);

					/* Hack -- Track this monster race */
					if (m_ptr->ml) monster_race_track(m_ptr->r_idx);

					/* Hack -- Track this monster */
					if (m_ptr->ml) health_track(cave_m_idx[y][x]);
				}
				/* Apply special damage XXX XXX XXX */
				tdam = critical_shot(i_ptr->weight, i_ptr->to_h, tdam);

				/* No negative damage */
				if (tdam < 0) tdam = 0;

				/* Complex message */
				if (p_ptr->wizard)
				{
					msg_format(LS(          __T("You do %d (out of %d) damage."), /* Translation TBC */
							spaceme(langbuf,__T("%dから%dダメージを与えた。"))), /* TODO "%2$dから%1$dダメージを与えた。" */
							tdam, m_ptr->hp);
				}
				/* Hit the monster, check for death */
				if (mon_take_hit(cave_m_idx[y][x], tdam, &fear, note_dies))
				{
					/* Dead monster */
				}
				else /* No death */
				{
					/* Message */
					message_pain(cave_m_idx[y][x], tdam);

					/* Take note */
					if (fear && m_ptr->ml)
					{
						_TCHAR m_name[80];

						/* Get the monster name (or "it") */
						monster_desc(m_name, _countof(m_name), m_ptr, 0);

						/* Message */
						message_format(MSG_FLEE, m_ptr->r_idx,
								LS(         __T("%^s flees in terror!"),
							spaceme(langbuf,__T("%^sが怖くなって逃げ出した。"))), m_name); /* Translation TBC */
					}
				}
			}
			/* Stop looking */
			break;
		}
	}
	/* Chance of breakage (during attacks) */
	j = (hit_body ? breakage_chance(i_ptr) : 0);

	/* Drop (or break) near that location */
	drop_near(i_ptr, j, y, x);
}

void textui_cmd_throw(void) 
{ 
	int item, dir; 
	const _TCHAR *q;
	const _TCHAR * s; 
	_TCHAR langbuf[200];

	/* Get an item */ 
	q = LS(__T("Throw which item? "),
		spaceme(langbuf, __T("どのアイテムを投げるか。")));  /* Translation TBC */
	s = LS(__T("You have nothing to throw."),
		spaceme(langbuf, __T("投げるアイテムがない。")));  /* Translation TBC */
 	if (!get_item(&item, q, s, (USE_INVEN | USE_FLOOR))) 
		return; 

	/* Get a direction (or cancel) */ 
	if (!get_aim_dir(&dir)) 
		return; 

	cmd_insert(CMD_THROW, item, dir); 
}
