//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		wx_api_support.h
 * @brief		WINAPI Ή wb_
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_wx_api_support_H_
#define _IRIS_wx_api_support_H_

#ifndef _IRIS_WX_NOT_SUPPORT_WIN32API_WARN	// WIN32API x̗}

//======================================================================
// include
#include <windows.h>
#ifndef _WIN32_WCE
#include <io.h>
#endif

//======================================================================
// define

#ifdef _IRIS_DEBUG
#  define API_WARNING(func, msg)	OutputDebugStringA("API WARNING : " #func " " msg "\r\n")
#else
#  define API_WARNING(func, msg)	__noop
#endif

#define API_NOOP

#define API_REPLACE_DEF (name, ret, msg)		(API_WARNING(name, msg), ret)
#define API_REPLACE_PROC(name, args, msg)		(API_WARNING(name, msg), ::##name##args)

// T|[gĂȂ or 폜\API֐u
#ifdef DefineHandleTable
#  undef DefineHandleTable
#endif
#define DefineHandleTable(w)            API_REPLACE_DEF (DefineHandleTable, ((w), TRUE)		\
	, "݂͎gĂ܂B]ATRUE ɓWJ܂BȊǑʂ͂܂B")

#ifdef GetFreeSpace
#  undef GetFreeSpace
#endif
#define GetFreeSpace(w)					API_REPLACE_DEF (GetFreeSpace, (0x100000L)			\
	, "̊֐͎gȂȂ܂BWin32 AvP[Vł́AGlobalMemoryStatus ֐gĂB")

#define GlobalCompact(dwMinFree)		API_REPLACE_PROC(GlobalCompact, (dwMinFree)			\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͈Ӗ܂B")

#define GlobalFix(hMem)					API_REPLACE_PROC(GlobalFix, (hMem)					\
	, "݂͎gĂ܂BWin32 x[X̃AvP[Vł́AVirtualLock ֐ VirtualUnlock ֐gĂB")

#ifdef GlobalLRUNewest
#  undef GlobalLRUNewest
#endif
#define GlobalLRUNewest(h)				API_REPLACE_DEF (GlobalLRUNewest, (h)				\
	, "݂͎gĂ܂BWin32 x[X̃AvP[V́AVirtualLock ֐ VirtualUnlock ֐gĂB")

#ifdef GlobalLRUOldest
#  undef GlobalLRUOldest
#endif
#define GlobalLRUOldest(h)				API_REPLACE_DEF (GlobalLRUOldest, (h)				\
	, "݂͎gĂ܂BWin32 x[X̃AvP[V́AVirtualLock ֐ VirtualUnlock ֐gĂB")

#define GlobalUnfix(hMem)				API_REPLACE_PROC(GlobalUnfix, (hMem)				\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͈Ӗ܂B")

#define GlobalUnWire(hMem)				API_REPLACE_PROC(GlobalUnWire, (hMem)				\
	, "݂͎gĂ܂BO[oIuWFNgbNKvAvP[V́AGlobalLock ֐ GlobalUnlock ֐gĂB")

#define GlobalWire(hMem)				API_REPLACE_PROC(GlobalWire, (hMem)					\
	, "݂͎gĂ܂BO[oIuWFNgbNKvAvP[V́AGlobalLock ֐ GlobalUnlock ֐gĂB")


#define IsBadHugeReadPtr(lp, ucb)															\
	API_REPLACE_PROC(IsBadHugeReadPtr, (lp, ucb)											\
	, "̊֐͎gȂȂ܂BWin32 AvP[Vł́AIsBadHugeReadPtr ֐́AIsBadReadPtr ֐ƓłB")

#define IsBadHugeWritePtr(lp, ucb)															\
	API_REPLACE_PROC(IsBadHugeWritePtr, (lp, ucb)											\
	, "̊֐͎gȂȂ܂BWin32 AvP[Vł́AIsBadHugeWritePtr ֐́AIsBadWritePtr ֐ƓłB")

#ifdef LimitEmsPages
#  undef LimitEmsPages
#endif
#define LimitEmsPages(dw)				API_REPLACE_DEF (LimitEmsPages, API_NOOP			\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂BWin32 x[X̃AvP[Vł́Å֐͕Kv܂B")

#define LocalCompact(uMinFree)			API_REPLACE_PROC(LocalCompact, (uMinFree)			\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͕Kv܂B")

#define LocalShrink(hMem, cbNewSize)	API_REPLACE_PROC(LocalShrink, (hMem, cbNewSize)		\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͕Kv܂B")


#ifdef LockSegment
#  undef LockSegment
#endif
#define LockSegment(w)					API_REPLACE_DEF (LockSegment, GlobalFix((HANDLE)(w))	\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͕Kv܂B")

#ifdef SetSwapAreaSize
#  undef SetSwapAreaSize
#endif
#define SetSwapAreaSize(w)				API_REPLACE_DEF (SetSwapAreaSize, (w))					\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł́AgĂӖ܂B")


#ifdef UnlockSegment
#  undef UnlockSegment
#endif
#define	UnlockSegment(w)					API_REPLACE_DEF (UnlockSegment, GlobalUnfix((HANDLE)(w))	\
	, "݂͎gĂ܂B16 rbg Windows Ƃ̌݊̂߂ɒ񋟂Ă܂B32 rbgł͈Ӗ܂B")


#define _lclose(hFile)						API_REPLACE_PROC(_lclose, (hFile)							\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́A ֐gĂB")

#define _lcreat(lpPathName, iAttribute)		API_REPLACE_PROC(_lcreat, (lpPathName, iAttribute)							\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́ACreateFile ֐gĂB")

#if	defined(IRIS_MSC)
#define _lseek(_FileHandle, _Offset, _Origin)		API_REPLACE_PROC(_lseek, (_FileHandle, _Offset, _Origin)			\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́ASetFilePointer ֐gĂB")
#endif

#define _lopen(lpPathName, iReadWrite)		API_REPLACE_PROC(_lopen, (lpPathName, iReadWrite)			\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́ACreateFile ֐gĂB")

#define _lread(hFile, lpBuffer, uBytes)		API_REPLACE_PROC(_lread, (hFile, lpBuffer, uBytes)			\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́AReadFile ֐gĂB")

#define _lwrite(hFile, lpBuffer, uBytes)	API_REPLACE_PROC(_lwrite, (hFile, lpBuffer, uBytes)			\
	, "̊֐ 16 rbgo[W Windows Ƃ̌݊̂߂ɎcĂ܂BWin32 AvP[Vł́AWriteFile ֐gĂB")


#endif

#endif
