//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShellPath.cpp
 * @brief		pXNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXShellPath_CPP_

//======================================================================
// include
#include "WXShellPath.h"
#include <shlwapi.h>
#include <tchar.h>

//======================================================================
// link
#pragma	comment( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
// CPathA
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPathA::CPathA(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPathA::CPathA(LPCSTR  lpszPath)
{
	Copy(lpszPath);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPathA::~CPathA(void)
{
}

/**********************************************************************//**
 *
 * operator
 *
*//***********************************************************************/
//! []
CHAR CPathA::operator [] (int nIndex) const
{
	return m_Path[nIndex];
}
//! _tcscpy
CPathA& CPathA::operator = (LPCSTR  lpString)
{
	Copy(lpString);
	return *this;
}
//! _tcscat
CPathA& CPathA::operator += (LPCSTR  lpString)
{
	strcat_s(m_Path, MAX_PATH, lpString);
	return *this;
}

/**********************************************************************//**
 *
 * Rs[
 *
*//***********************************************************************/
void CPathA::Copy(LPCSTR  lpszPath)
{
	strcpy_s(m_Path, MAX_PATH, lpszPath);
}

/**********************************************************************//**
 *
 * obNXbVǉ
 *
 ----------------------------------------------------------------------
 * @return	g
*//***********************************************************************/
CPathA& CPathA::AddBackslash(void)
{
	PathAddBackslashA(m_Path);
	return *this;
}

/**********************************************************************//**
 *
 * gqǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL CPathA::AddExtension(LPCSTR  pszExt)
{
	return PathAddExtensionA(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * t@Cǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL CPathA::AddFileName(LPCSTR  pszFile)
{
	return CombineFile(pszFile);
}

/**********************************************************************//**
 *
 * pX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	pszMore	= 镶
 * @return	
*//***********************************************************************/
BOOL CPathA::Append(LPCSTR  pszMore)
{
	return PathAppendA(m_Path, pszMore);
}

/**********************************************************************//**
 *
 * hCu[gpX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	iDrive	= hCuԍ
 * @return	
*//***********************************************************************/
BOOL CPathA::BuildRoot(int iDrive)
{
	if( PathBuildRootA(m_Path, iDrive) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPathA::Canonicalize(void)
{
	return PathCanonicalizeA(m_Path, m_Path);
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= ̓pX
 * @return	
*//***********************************************************************/
BOOL CPathA::Canonicalize(LPCSTR  pszPath)
{
	return PathCanonicalizeA(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * fBNgpXƃt@Č
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL CPathA::Combine(LPCSTR  pszDir, LPCSTR  pszFile)
{
	if( PathCombineA(m_Path, pszDir, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * fBNgpXƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CPathA::CombineDirectory(LPCSTR  pszDir)
{
	if( PathCombineA(m_Path, pszDir, m_Path) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * t@Cƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL CPathA::CombineFile(LPCSTR  pszFile)
{
	if( PathCombineA(m_Path, m_Path, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * \̈Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC		= tHgێĂfoCXReLXg
 * @param [in]	dx		= \
 * @return	
*//***********************************************************************/
BOOL CPathA::CompactPath(HDC hDC, int dx)
{
	return PathCompactPathA(hDC, m_Path, dx);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL CPathA::CompactPathEx(UINT cchMax, DWORD dwFlags)
{
	return PathCompactPathExA(m_Path, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDst		= o̓obt@
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL CPathA::CompactPathEx(LPSTR  pszDst, UINT cchMax, DWORD dwFlags)
{
	return PathCompactPathExA(pszDst, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Q̃pX狤ʂ̃pXo
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile1	= pXP
 * @param [in]	pszFile2	= pXQ
 * @return	
*//***********************************************************************/
BOOL CPathA::CommonPrefix(LPCSTR  pszFile1, LPCSTR  pszFile2)
{
	return PathCommonPrefixA(pszFile1, pszFile2, m_Path);
}

/**********************************************************************//**
 *
 * pXWJpXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc	= ϊ
 * @return	񂾃TCY
*//***********************************************************************/
DWORD CPathA::ExpandEnvStrings(LPCSTR  lpSrc)
{
	return ExpandEnvironmentStringsA(lpSrc, m_Path, MAX_PATH);
}

/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL CPathA::FileExists(void)
{
	return PathFileExistsA(m_Path);
}

/**********************************************************************//**
 *
 * gq
 *
 ----------------------------------------------------------------------
 * @return	gqւ̃|C^
*//***********************************************************************/
LPSTR  CPathA::FindExtension(void)
{
	return PathFindExtensionA(m_Path);
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @return	t@Cւ̃|C^
*//***********************************************************************/
LPSTR  CPathA::FindFileName(void)
{
	return PathFindFileNameA(m_Path);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPSTR  CPathA::FindNextComponent(void)
{
	return PathFindNextComponentA(m_Path);
}

/**********************************************************************//**
 *
 * Ō̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPSTR  CPathA::FindLastComponent(void)
{
	LPSTR  ret = nullptr, next = nullptr;
	next = FindNextComponent();
	while(next && *next != '\0' )
	{
		ret = next;
		next = FindNextComponent(next);
	}
	return ret;
}

/**********************************************************************//**
 *
 * WpXEPathst@C
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= pXiʂ̊i[obt@j
 * @return	ppszOtherDirs	= ΏۃpXXg
 * @return	
*//***********************************************************************/
BOOL CPathA::FindOnPath(LPSTR  pszPath, LPCSTR * ppszOtherDirs)
{
	if( !PathFindOnPathA(pszPath, ppszOtherDirs) ) return FALSE;
	strcpy_s(m_Path, MAX_PATH, pszPath);
	return TRUE;
}

/**********************************************************************//**
 *
 * TtBbNX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	lppSuffix	= TtBbNXXg
 * @return	nArraySize	= lppSuffix̔z
 * @return	v̐擪|C^BsƂnullptr
*//***********************************************************************/
LPCSTR  CPathA::FindSuffixArray(LPCSTR * lppSuffix, int nArraySize)
{
	return PathFindSuffixArrayA(m_Path, lppSuffix, nArraySize);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
LPSTR  CPathA::GetArgs(void)
{
	return PathGetArgsA(m_Path);
}

/**********************************************************************//**
 *
 * hCuԍ̎擾
 *
 ----------------------------------------------------------------------
 * @return	hCuԍ
*//***********************************************************************/
int CPathA::GetDriveNumber(void)
{
	return PathGetDriveNumberA(m_Path);
}

/**********************************************************************//**
 *
 * ̃Rec^Cvǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszContentType	= Rec^Cv
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsContentType(LPCSTR  pszContentType)
{
	return PathIsContentTypeA(m_Path, pszContentType);
}

/**********************************************************************//**
 *
 * fBNg݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL CPathA::IsDirectory(void)
{
	return PathIsDirectoryA(m_Path);
}

/**********************************************************************//**
 *
 * fBNg󂩂ǂ
 *
 ----------------------------------------------------------------------
 * @retval	true	= 
 * @retval	false	= łȂ
*//***********************************************************************/
BOOL CPathA::IsDirectoryEmpty(void)
{
	return PathIsDirectoryEmptyA(m_Path);
}

/**********************************************************************//**
 *
 * ؂蕶邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	؂蕶܂܂Ă邩ǂ\^Ul
*//***********************************************************************/
BOOL CPathA::IsFileSpec(void)
{
	return PathIsFileSpecA(m_Path);
}

/**********************************************************************//**
 *
 * pXtH[}bgǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CPathA::IsLFNFileSpec(void)
{
	return PathIsLFNFileSpecA(m_Path);
}

/**********************************************************************//**
 *
 * lbg[ÑpXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CPathA::IsNetworkPath(void)
{
	return PathIsNetworkPathA(m_Path);
}

/**********************************************************************//**
 *
 * pXvtBbNXn܂Ă邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPrefix	= vtBbNX
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsPrefix(LPCSTR  pszPrefix)
{
	return PathIsPrefixA(pszPrefix, m_Path);
}

/**********************************************************************//**
 *
 * pX΃pXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsRelative(void)
{
	return PathIsRelativeA(m_Path);
}

/**********************************************************************//**
 *
 * pX[gpXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsRoot(void)
{
	return PathIsRootA(m_Path);
}

/**********************************************************************//**
 *
 * pX̃[gpXǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsSameRoot(LPCSTR  pszPath)
{
	return PathIsSameRootA(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * pXVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsSystemFolder(void)
{
	return PathIsSystemFolderA(m_Path, 0);
}

/**********************************************************************//**
 *
 * pXUNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsUNC(void)
{
	return PathIsUNCA(m_Path);
}

/**********************************************************************//**
 *
 * pXT[o[\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsUNCServer(void)
{
	return PathIsUNCServerA(m_Path);
}

/**********************************************************************//**
 *
 * pXL\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsUNCServerShare(void)
{
	return PathIsUNCServerShareA(m_Path);
}

/**********************************************************************//**
 *
 * pXURL\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::IsURL(void)
{
	return PathIsURLA(m_Path);
}

/**********************************************************************//**
 *
 * 啶̃pXɕϊ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathA::MakePretty(void)
{
	return PathMakePrettyA(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@Cɂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathA::MakeSystemFolder(void)
{
	return PathMakeSystemFolderA(m_Path);
}

/**********************************************************************//**
 *
 * pXɈv邩iChJ[hgp\j
 *
 ----------------------------------------------------------------------
 * @param [in]	pszSpec	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathA::MatchSpec(LPCSTR  pszSpec)
{
	return PathMatchSpecA(m_Path, pszSpec);
}

/**********************************************************************//**
 *
 * 󔒂pX '"' 
 *
*//***********************************************************************/
void CPathA::QuoteSpaces(void)
{
	PathQuoteSpacesA(m_Path);
}

/**********************************************************************//**
 *
 * ̃pXԂ̑΃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFrom		= Qƌ̃pX
 * @param [in]	dwAttrFrom	= Qƌ̃t@C
 * @param [in]	pszTo		= QƐ̃pX
 * @param [in]	dwAttrTo	= QƐ̃t@C
 * @retrun	
*//***********************************************************************/
BOOL CPathA::RelativePathTo(LPCSTR  pszFrom, DWORD dwAttrFrom, LPCSTR  pszTo, DWORD dwAttrTo)
{
	return PathRelativePathToA(m_Path, pszFrom, dwAttrFrom, pszTo, dwAttrTo);
}

/**********************************************************************//**
 *
 * obNXbV폜
 *
 ----------------------------------------------------------------------
 * @retrun	폜 \ ̈ʒu
*//***********************************************************************/
LPSTR  CPathA::RemoveBackslash(void)
{
	return PathRemoveBackslashA(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Ő󔒂폜
 *
*//***********************************************************************/
void CPathA::RemoveBlanks(void)
{
	PathRemoveBlanksA(m_Path);
}

/**********************************************************************//**
 *
 * pXgq폜
 *
*//***********************************************************************/
void CPathA::RemoveExtension(void)
{
	PathRemoveExtensionA(m_Path);
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathA::RemoveFileSpec(void)
{
	return PathRemoveFileSpecA(m_Path);
}

/**********************************************************************//**
 *
 * pX̊gqύX
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq
 * @retrun	
*//***********************************************************************/
BOOL CPathA::RenameExtension(LPCSTR  pszExt)
{
	return PathRenameExtensionA(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszBuf	= ߂tpX
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL CPathA::SearchAndQualify(LPSTR  pszBuf, UINT cchBuf)
{
	return PathSearchAndQualifyA(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= tpX߂pX
 * @retrun	
*//***********************************************************************/
BOOL CPathA::SearchAndQualify(LPCSTR  pszPath)
{
	return PathSearchAndQualifyA(pszPath, m_Path, MAX_PATH);
}

/**********************************************************************//**
 *
 * k߂`̃pXRg[ɕ\
 *
 ----------------------------------------------------------------------
 * @param [in]	hDlg	= _CAOnh
 * @param [in]	id		= _CAOACeID
*//***********************************************************************/
void CPathA::SetDlgItemPath(HWND hDlg, int id)
{
	PathSetDlgItemPathA(hDlg, id, m_Path);
}

/**********************************************************************//**
 *
 * pX狤L폜
 *
 ----------------------------------------------------------------------
 * @retrun	LȊO̐擪|C^
*//***********************************************************************/
LPSTR  CPathA::SkipRoot(void)
{
	return PathSkipRootA(m_Path);
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
*//***********************************************************************/
void CPathA::StripPath(void)
{
	PathStripPathA(m_Path);
}

/**********************************************************************//**
 *
 * pX烋[gpX폜
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathA::StripToRoot(void)
{
	return PathStripToRootA(m_Path);
}

/**********************************************************************//**
 *
 * pXϐgppXɕύX
 *
 ----------------------------------------------------------------------
 * @param [out]	pszBuf	= o̓obt@
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL CPathA::UnExpandEnvStrings(LPSTR  pszBuf, UINT cchBuf)
{
	return PathUnExpandEnvStringsA(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * pXC폜
 *
*//***********************************************************************/
void CPathA::Undecorate(void)
{
	PathUndecorateA(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@CłȂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathA::UnmakeSystemFolder(void)
{
	return PathUnmakeSystemFolderA(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Õ_uNH[e[V폜
 *
*//***********************************************************************/
void CPathA::UnquoteSpaces(void)
{
	PathUnquoteSpacesA(m_Path);
}

/**********************************************************************//**
 *
 * t@CɎgȂ폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= ͕
 * @param [in]	max_len	= t@CƂĎgpő啶
 * @return	
*//***********************************************************************/
BOOL CPathA::FormatFileName(LPCSTR  pszFile, s32 max_len)
{
	if( pszFile == nullptr ) return FALSE;
	LPCSTR  p = pszFile;
	// 擪̃Xy[X͍폜
	while( *p == ' ' || *p == '.' )	{ ++p; }
	if( *p == '\0' ) return FALSE;
	// gpłȂ폜
	s32 len = 0;
	s32 max = max_len <= 0 ? MAX_PATH : max_len;
	do
	{
		static const CHAR	code[] = "\\/:*?\"<>|\r\n";
		static const int	num = sizeof(code)/sizeof(code[0]);
		for( int i=0; i < num; ++i )
		{
			if( *p == code[i] ) goto block_end;	// gpsƈv
		}
		if( len >= max ) 
		{
			m_Path[len-1] = '~';
			break;
		}
		m_Path[len] = *p;
		++len;
block_end:
		;
	} while( *(++p) != '\0' );
	m_Path[len] = '\0';

	return TRUE;
}


/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	^Ul
*//***********************************************************************/
BOOL CPathA::FileExists(LPCSTR  pszPath)
{
	return PathFileExistsA(pszPath);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPSTR  CPathA::FindNextComponent(LPCSTR  pszPath)
{
	return PathFindNextComponentA(pszPath);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
LPSTR  CPathA::GetArgs(LPCSTR  pszPath)
{
	return PathGetArgsA(pszPath);
}

/**********************************************************************//**
 *
 * pX\镶̎ʂ𔻒
 *
 ----------------------------------------------------------------------
 * @param [in]	ch	= ͕
 * @return	̎(GCT_***)
*//***********************************************************************/
UINT CPathA::GetCharType(UCHAR ch)
{
	return PathGetCharTypeA(ch);
}

/**********************************************************************//**
 *
 * ̃t@CVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
BOOL CPathA::IsSystemFolder(DWORD dwAttrb)
{
	return PathIsSystemFolderA(nullptr, dwAttrb);
}

/**********************************************************************//**
 *
 * ACRpXt@CpXƃCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
int CPathA::ParseIconLocation(LPSTR  pszIconFile)
{
	return PathParseIconLocationA(pszIconFile);
}

/**********************************************************************//**
 *
 * R}hC폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= o̓obt@
*//***********************************************************************/
void CPathA::RemoveArgs(LPSTR  pszPath)
{
	PathRemoveArgsA(pszPath);
}

// CPathW
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPathW::CPathW(void)
{
	ZeroMemory(m_Path, sizeof(m_Path));
}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPathW::CPathW(LPCWSTR lpszPath)
{
	Copy(lpszPath);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPathW::~CPathW(void)
{
}

/**********************************************************************//**
 *
 * operator
 *
*//***********************************************************************/
//! []
WCHAR CPathW::operator [] (int nIndex) const
{
	return m_Path[nIndex];
}
//! _tcscpy
CPathW& CPathW::operator = (LPCWSTR lpString)
{
	Copy(lpString);
	return *this;
}
//! _tcscat
CPathW& CPathW::operator += (LPCWSTR lpString)
{
	wcscat_s(m_Path, MAX_PATH, lpString);
	return *this;
}

/**********************************************************************//**
 *
 * Rs[
 *
*//***********************************************************************/
void CPathW::Copy(LPCWSTR lpszPath)
{
	wcscpy_s(m_Path, MAX_PATH, lpszPath);
}

/**********************************************************************//**
 *
 * obNXbVǉ
 *
 ----------------------------------------------------------------------
 * @return	g
*//***********************************************************************/
CPathW& CPathW::AddBackslash(void)
{
	PathAddBackslashW(m_Path);
	return *this;
}

/**********************************************************************//**
 *
 * gqǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL CPathW::AddExtension(LPCWSTR pszExt)
{
	return PathAddExtensionW(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * t@Cǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq̕
 * @return	
*//***********************************************************************/
BOOL CPathW::AddFileName(LPCWSTR pszFile)
{
	return CombineFile(pszFile);
}

/**********************************************************************//**
 *
 * pX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	pszMore	= 镶
 * @return	
*//***********************************************************************/
BOOL CPathW::Append(LPCWSTR pszMore)
{
	return PathAppendW(m_Path, pszMore);
}

/**********************************************************************//**
 *
 * hCu[gpX̎擾
 *
 ----------------------------------------------------------------------
 * @param [in]	iDrive	= hCuԍ
 * @return	
*//***********************************************************************/
BOOL CPathW::BuildRoot(int iDrive)
{
	if( PathBuildRootW(m_Path, iDrive) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CPathW::Canonicalize(void)
{
	return PathCanonicalizeW(m_Path, m_Path);
}

/**********************************************************************//**
 *
 * pX . A .. 폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= ̓pX
 * @return	
*//***********************************************************************/
BOOL CPathW::Canonicalize(LPCWSTR pszPath)
{
	return PathCanonicalizeW(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * fBNgpXƃt@Č
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL CPathW::Combine(LPCWSTR pszDir, LPCWSTR pszFile)
{
	if( PathCombineW(m_Path, pszDir, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * fBNgpXƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDir	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CPathW::CombineDirectory(LPCWSTR pszDir)
{
	if( PathCombineW(m_Path, pszDir, m_Path) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * t@Cƌ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= t@C
 * @return	
*//***********************************************************************/
BOOL CPathW::CombineFile(LPCWSTR pszFile)
{
	if( PathCombineW(m_Path, m_Path, pszFile) == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * \̈Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	hDC		= tHgێĂfoCXReLXg
 * @param [in]	dx		= \
 * @return	
*//***********************************************************************/
BOOL CPathW::CompactPath(HDC hDC, int dx)
{
	return PathCompactPathW(hDC, m_Path, dx);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL CPathW::CompactPathEx(UINT cchMax, DWORD dwFlags)
{
	return PathCompactPathExW(m_Path, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Cӂ̕Ɏ܂pXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszDst		= o̓obt@
 * @param [in]	cchMax		= 
 * @param [in]	dwFlags		= pX̋؂蕶w肷tO
 * @return	
*//***********************************************************************/
BOOL CPathW::CompactPathEx(LPWSTR pszDst, UINT cchMax, DWORD dwFlags)
{
	return PathCompactPathExW(pszDst, m_Path, cchMax, dwFlags);
}

/**********************************************************************//**
 *
 * Q̃pX狤ʂ̃pXo
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile1	= pXP
 * @param [in]	pszFile2	= pXQ
 * @return	
*//***********************************************************************/
BOOL CPathW::CommonPrefix(LPCWSTR pszFile1, LPCWSTR pszFile2)
{
	return PathCommonPrefixW(pszFile1, pszFile2, m_Path);
}

/**********************************************************************//**
 *
 * pXWJpXɕϊ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpSrc	= ϊ
 * @return	񂾃TCY
*//***********************************************************************/
DWORD CPathW::ExpandEnvStrings(LPCWSTR lpSrc)
{
	return ExpandEnvironmentStringsW(lpSrc, m_Path, MAX_PATH);
}

/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL CPathW::FileExists(void)
{
	return PathFileExistsW(m_Path);
}

/**********************************************************************//**
 *
 * gq
 *
 ----------------------------------------------------------------------
 * @return	gqւ̃|C^
*//***********************************************************************/
LPWSTR CPathW::FindExtension(void)
{
	return PathFindExtensionW(m_Path);
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @return	t@Cւ̃|C^
*//***********************************************************************/
LPWSTR CPathW::FindFileName(void)
{
	return PathFindFileNameW(m_Path);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPWSTR CPathW::FindNextComponent(void)
{
	return PathFindNextComponentW(m_Path);
}

/**********************************************************************//**
 *
 * Ō̍\vf
 *
 ----------------------------------------------------------------------
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPWSTR CPathW::FindLastComponent(void)
{
	LPWSTR ret = nullptr, next = nullptr;
	next = FindNextComponent();
	while(next && *next != '\0' )
	{
		ret = next;
		next = FindNextComponent(next);
	}
	return ret;
}

/**********************************************************************//**
 *
 * WpXEPathst@C
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= pXiʂ̊i[obt@j
 * @return	ppszOtherDirs	= ΏۃpXXg
 * @return	
*//***********************************************************************/
BOOL CPathW::FindOnPath(LPWSTR pszPath, LPCWSTR* ppszOtherDirs)
{
	if( !PathFindOnPathW(pszPath, ppszOtherDirs) ) return FALSE;
	wcscpy_s(m_Path, MAX_PATH, pszPath);
	return TRUE;
}

/**********************************************************************//**
 *
 * TtBbNX̌
 *
 ----------------------------------------------------------------------
 * @param [in]	lppSuffix	= TtBbNXXg
 * @return	nArraySize	= lppSuffix̔z
 * @return	v̐擪|C^BsƂnullptr
*//***********************************************************************/
LPCWSTR CPathW::FindSuffixArray(LPCWSTR* lppSuffix, int nArraySize)
{
	return PathFindSuffixArrayW(m_Path, lppSuffix, nArraySize);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
LPWSTR CPathW::GetArgs(void)
{
	return PathGetArgsW(m_Path);
}

/**********************************************************************//**
 *
 * hCuԍ̎擾
 *
 ----------------------------------------------------------------------
 * @return	hCuԍ
*//***********************************************************************/
int CPathW::GetDriveNumber(void)
{
	return PathGetDriveNumberW(m_Path);
}

/**********************************************************************//**
 *
 * ̃Rec^Cvǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszContentType	= Rec^Cv
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsContentType(LPCWSTR pszContentType)
{
	return PathIsContentTypeW(m_Path, pszContentType);
}

/**********************************************************************//**
 *
 * fBNg݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @return	݂ꍇ͐^AȂꍇ͋UԂ
*//***********************************************************************/
BOOL CPathW::IsDirectory(void)
{
	return PathIsDirectoryW(m_Path);
}

/**********************************************************************//**
 *
 * fBNg󂩂ǂ
 *
 ----------------------------------------------------------------------
 * @retval	true	= 
 * @retval	false	= łȂ
*//***********************************************************************/
BOOL CPathW::IsDirectoryEmpty(void)
{
	return PathIsDirectoryEmptyW(m_Path);
}

/**********************************************************************//**
 *
 * ؂蕶邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	؂蕶܂܂Ă邩ǂ\^Ul
*//***********************************************************************/
BOOL CPathW::IsFileSpec(void)
{
	return PathIsFileSpecW(m_Path);
}

/**********************************************************************//**
 *
 * pXtH[}bgǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CPathW::IsLFNFileSpec(void)
{
	return PathIsLFNFileSpecW(m_Path);
}

/**********************************************************************//**
 *
 * lbg[ÑpXǂ
 *
 ----------------------------------------------------------------------
 * @return	^Ul
*//***********************************************************************/
BOOL CPathW::IsNetworkPath(void)
{
	return PathIsNetworkPathW(m_Path);
}

/**********************************************************************//**
 *
 * pXvtBbNXn܂Ă邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPrefix	= vtBbNX
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsPrefix(LPCWSTR pszPrefix)
{
	return PathIsPrefixW(pszPrefix, m_Path);
}

/**********************************************************************//**
 *
 * pX΃pXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsRelative(void)
{
	return PathIsRelativeW(m_Path);
}

/**********************************************************************//**
 *
 * pX[gpXǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsRoot(void)
{
	return PathIsRootW(m_Path);
}

/**********************************************************************//**
 *
 * pX̃[gpXǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsSameRoot(LPCWSTR pszPath)
{
	return PathIsSameRootW(m_Path, pszPath);
}

/**********************************************************************//**
 *
 * pXVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsSystemFolder(void)
{
	return PathIsSystemFolderW(m_Path, 0);
}

/**********************************************************************//**
 *
 * pXUNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsUNC(void)
{
	return PathIsUNCW(m_Path);
}

/**********************************************************************//**
 *
 * pXT[o[\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsUNCServer(void)
{
	return PathIsUNCServerW(m_Path);
}

/**********************************************************************//**
 *
 * pXL\UNC\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsUNCServerShare(void)
{
	return PathIsUNCServerShareW(m_Path);
}

/**********************************************************************//**
 *
 * pXURL\Lł邩ǂ
 *
 ----------------------------------------------------------------------
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::IsURL(void)
{
	return PathIsURLW(m_Path);
}

/**********************************************************************//**
 *
 * 啶̃pXɕϊ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathW::MakePretty(void)
{
	return PathMakePrettyW(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@Cɂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathW::MakeSystemFolder(void)
{
	return PathMakeSystemFolderW(m_Path);
}

/**********************************************************************//**
 *
 * pXɈv邩iChJ[hgp\j
 *
 ----------------------------------------------------------------------
 * @param [in]	pszSpec	= r
 * @retrun	^Ul
*//***********************************************************************/
BOOL CPathW::MatchSpec(LPCWSTR pszSpec)
{
	return PathMatchSpecW(m_Path, pszSpec);
}

/**********************************************************************//**
 *
 * 󔒂pX '"' 
 *
*//***********************************************************************/
void CPathW::QuoteSpaces(void)
{
	PathQuoteSpacesW(m_Path);
}

/**********************************************************************//**
 *
 * ̃pXԂ̑΃pX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFrom		= Qƌ̃pX
 * @param [in]	dwAttrFrom	= Qƌ̃t@C
 * @param [in]	pszTo		= QƐ̃pX
 * @param [in]	dwAttrTo	= QƐ̃t@C
 * @retrun	
*//***********************************************************************/
BOOL CPathW::RelativePathTo(LPCWSTR pszFrom, DWORD dwAttrFrom, LPCWSTR pszTo, DWORD dwAttrTo)
{
	return PathRelativePathToW(m_Path, pszFrom, dwAttrFrom, pszTo, dwAttrTo);
}

/**********************************************************************//**
 *
 * obNXbV폜
 *
 ----------------------------------------------------------------------
 * @retrun	폜 \ ̈ʒu
*//***********************************************************************/
LPWSTR CPathW::RemoveBackslash(void)
{
	return PathRemoveBackslashW(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Ő󔒂폜
 *
*//***********************************************************************/
void CPathW::RemoveBlanks(void)
{
	PathRemoveBlanksW(m_Path);
}

/**********************************************************************//**
 *
 * pXgq폜
 *
*//***********************************************************************/
void CPathW::RemoveExtension(void)
{
	PathRemoveExtensionW(m_Path);
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathW::RemoveFileSpec(void)
{
	return PathRemoveFileSpecW(m_Path);
}

/**********************************************************************//**
 *
 * pX̊gqύX
 *
 ----------------------------------------------------------------------
 * @param [in]	pszExt	= gq
 * @retrun	
*//***********************************************************************/
BOOL CPathW::RenameExtension(LPCWSTR pszExt)
{
	return PathRenameExtensionW(m_Path, pszExt);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [out]	pszBuf	= ߂tpX
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL CPathW::SearchAndQualify(LPWSTR pszBuf, UINT cchBuf)
{
	return PathSearchAndQualifyW(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * tpX߂
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath	= tpX߂pX
 * @retrun	
*//***********************************************************************/
BOOL CPathW::SearchAndQualify(LPCWSTR pszPath)
{
	return PathSearchAndQualifyW(pszPath, m_Path, MAX_PATH);
}

/**********************************************************************//**
 *
 * k߂`̃pXRg[ɕ\
 *
 ----------------------------------------------------------------------
 * @param [in]	hDlg	= _CAOnh
 * @param [in]	id		= _CAOACeID
*//***********************************************************************/
void CPathW::SetDlgItemPath(HWND hDlg, int id)
{
	PathSetDlgItemPathW(hDlg, id, m_Path);
}

/**********************************************************************//**
 *
 * pX狤L폜
 *
 ----------------------------------------------------------------------
 * @retrun	LȊO̐擪|C^
*//***********************************************************************/
LPWSTR CPathW::SkipRoot(void)
{
	return PathSkipRootW(m_Path);
}

/**********************************************************************//**
 *
 * pXt@C폜
 *
*//***********************************************************************/
void CPathW::StripPath(void)
{
	PathStripPathW(m_Path);
}

/**********************************************************************//**
 *
 * pX烋[gpX폜
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathW::StripToRoot(void)
{
	return PathStripToRootW(m_Path);
}

/**********************************************************************//**
 *
 * pXϐgppXɕύX
 *
 ----------------------------------------------------------------------
 * @param [out]	pszBuf	= o̓obt@
 * @param [in]	cchBuf	= pszBuf̃TCY
 * @retrun	
*//***********************************************************************/
BOOL CPathW::UnExpandEnvStrings(LPWSTR pszBuf, UINT cchBuf)
{
	return PathUnExpandEnvStringsW(m_Path, pszBuf, cchBuf);
}

/**********************************************************************//**
 *
 * pXC폜
 *
*//***********************************************************************/
void CPathW::Undecorate(void)
{
	PathUndecorateW(m_Path);
}

/**********************************************************************//**
 *
 * t@CVXet@CłȂ
 *
 ----------------------------------------------------------------------
 * @retrun	
*//***********************************************************************/
BOOL CPathW::UnmakeSystemFolder(void)
{
	return PathUnmakeSystemFolderW(m_Path);
}

/**********************************************************************//**
 *
 * pX̑Õ_uNH[e[V폜
 *
*//***********************************************************************/
void CPathW::UnquoteSpaces(void)
{
	PathUnquoteSpacesW(m_Path);
}

/**********************************************************************//**
 *
 * t@CɎgȂ폜
 *
 ----------------------------------------------------------------------
 * @param [in]	pszFile	= ͕
 * @param [in]	max_len	= t@CƂĎgpő啶
 * @return	
*//***********************************************************************/
BOOL CPathW::FormatFileName(LPCWSTR pszFile, s32 max_len)
{
	if( pszFile == nullptr ) return FALSE;
	LPCWSTR p = pszFile;
	// 擪̃Xy[X͍폜
	while( *p == ' ' || *p == '.' )	{ ++p; }
	if( *p == '\0' ) return FALSE;
	// gpłȂ폜
	s32 len = 0;
	s32 max = max_len <= 0 ? MAX_PATH : max_len;
	do
	{
		static const WCHAR	code[] = IRIS_TEXTW("\\/:*?\"<>|\r\n");
		static const int	num = sizeof(code)/sizeof(code[0]);
		for( int i=0; i < num; ++i )
		{
			if( *p == code[i] ) goto block_end;	// gpsƈv
		}
		if( len >= max ) 
		{
			m_Path[len-1] = '~';
			break;
		}
		m_Path[len] = *p;
		++len;
block_end:
		;
	} while( *(++p) != '\0' );
	m_Path[len] = '\0';

	return TRUE;
}


/**********************************************************************//**
 *
 * t@C݂邩ǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	^Ul
*//***********************************************************************/
BOOL CPathW::FileExists(LPCWSTR pszPath)
{
	return PathFileExistsW(pszPath);
}

/**********************************************************************//**
 *
 * ̍\vf
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	̍\vfւ̃|C^
*//***********************************************************************/
LPWSTR CPathW::FindNextComponent(LPCWSTR pszPath)
{
	return PathFindNextComponentW(pszPath);
}

/**********************************************************************//**
 *
 * ̕񂩂R}hC擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszPath			= ͕
 * @return	擾̐擪|C^
*//***********************************************************************/
LPWSTR CPathW::GetArgs(LPCWSTR pszPath)
{
	return PathGetArgsW(pszPath);
}

/**********************************************************************//**
 *
 * pX\镶̎ʂ𔻒
 *
 ----------------------------------------------------------------------
 * @param [in]	ch	= ͕
 * @return	̎(GCT_***)
*//***********************************************************************/
UINT CPathW::GetCharType(WCHAR ch)
{
	return PathGetCharTypeW(ch);
}

/**********************************************************************//**
 *
 * ̃t@CVXet@Cǂ
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
BOOL CPathW::IsSystemFolder(DWORD dwAttrb)
{
	return PathIsSystemFolderW(nullptr, dwAttrb);
}

/**********************************************************************//**
 *
 * ACRpXt@CpXƃCfbNX擾
 *
 ----------------------------------------------------------------------
 * @param [in]	pszIconFile	= (IN)ACRpX (OUT)ACRt@C
 * @return	ACRCfbNX
*//***********************************************************************/
int CPathW::ParseIconLocation(LPWSTR pszIconFile)
{
	return PathParseIconLocationW(pszIconFile);
}

/**********************************************************************//**
 *
 * R}hC폜
 *
 ----------------------------------------------------------------------
 * @param [io]	pszPath	= o̓obt@
*//***********************************************************************/
void CPathW::RemoveArgs(LPWSTR pszPath)
{
	PathRemoveArgsW(pszPath);
}

}	// end of namespace wx
}	// end of namespace iris
