//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXShell.cpp
 * @brief		Shell֐gt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXShell_CPP_

//======================================================================
// include
#include "WXShell.h"
#include <commctrl.h>
#include <shlwapi.h>
#include <tchar.h>
#include "../wx_inchead.h"

//======================================================================
// link
#pragma comment( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * fBNg̍쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dir	= pX
 * @return	
*//***********************************************************************/
BOOL CreateDirectoryRecursive(LPCTSTR dir)
{
#ifdef UNICODE
	return CreateDirectoryRecursiveW(dir);
#else
	return CreateDirectoryRecursiveA(dir);
#endif
}
/// iris::wx::CreateDirectoryRecursive Q
BOOL CreateDirectoryRecursiveA(LPCSTR  dir)
{
	if( PathFileExistsA(dir) ) return TRUE;

	CHAR temp[MAX_PATH];
	strcpy_s(temp, MAX_PATH, dir);
	LPSTR p = nullptr, next = nullptr;
	next = PathFindNextComponentA(temp);
	while(next && *next != '\0' )
	{
		p = next;
		next = PathFindNextComponentA(next);
	}
	if( p == nullptr ) return FALSE;
	*p = IRIS_TEXTA('\0');
	// e̍쐬݂
	CreateDirectoryRecursiveA(temp);

	return CreateDirectoryA(dir, nullptr);
}
/// iris::wx::CreateDirectoryRecursive Q
BOOL CreateDirectoryRecursiveW(LPCWSTR dir)
{
	if( PathFileExistsW(dir) ) return TRUE;

	WCHAR temp[MAX_PATH];
	wcscpy_s(temp, MAX_PATH, dir);
	LPWSTR p = nullptr, next = nullptr;
	next = PathFindNextComponentW(temp);
	while(next && *next != '\0' )
	{
		p = next;
		next = PathFindNextComponentW(next);
	}
	if( p == nullptr ) return FALSE;
	*p = IRIS_TEXTW('\0');
	// e̍쐬݂
	CreateDirectoryRecursiveW(temp);

	return CreateDirectoryW(dir, nullptr);
}

/**********************************************************************//**
 *
 * t@CACR̎擾
 *
 * @note pX'/'؂肾Ǝs悤łBBB
 ----------------------------------------------------------------------
 * @param [in]	filename		= pX
 * @param [in]	uIconTypeFlag	= SHGFI_***
 * @return	ACRnh
*//***********************************************************************/
HICON GetFileIcon (LPCTSTR filename, UINT uIconTypeFlag)
{
#ifdef UNICODE
	return GetFileIconW(filename, uIconTypeFlag);
#else
	return GetFileIconA(filename, uIconTypeFlag);
#endif
}
/// iris::wx::GetFileIcon Q
HICON GetFileIconA(LPCSTR  filename, UINT uIconTypeFlag)
{
	SHFILEINFOA info;
	HIMAGELIST	hImgList;
	hImgList = (HIMAGELIST)SHGetFileInfoA(filename, FILE_ATTRIBUTE_NORMAL, &info, sizeof(SHFILEINFOA), SHGFI_ICON | uIconTypeFlag);
	if( hImgList == nullptr ) return nullptr;
	return info.hIcon;
}
/// iris::wx::GetFileIcon Q
HICON GetFileIconW(LPCWSTR filename, UINT uIconTypeFlag)
{
	SHFILEINFOW info;
	HIMAGELIST	hImgList;
	hImgList = (HIMAGELIST)SHGetFileInfoW(filename, FILE_ATTRIBUTE_NORMAL, &info, sizeof(SHFILEINFOW), SHGFI_ICON | uIconTypeFlag);
	if( hImgList == nullptr ) return nullptr;
	return info.hIcon;
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
HINSTANCE Execute (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd)
{
#ifdef UNICODE
	return ExecuteW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	return ExecuteA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#endif
}
/// iris::wx::Execute Q
HINSTANCE ExecuteA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}
/// iris::wx::Execute Q
HINSTANCE ExecuteW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd)
{
#if 1
	return ShellExecuteW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd);
#else
	SHELLEXECUTEINFO sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteEx(&sei) == 0 ) return 0;
	CloseHandle(sei.hProcess);
	return sei.hInstApp;
#endif
}

/**********************************************************************//**
 *
 * s
 *
 ----------------------------------------------------------------------
 * @param [in]	hwnd			= eEBhEnh
 * @param [in]	lpOperation		= w蕶
 * @param [in]	lpFile			= pX
 * @param [in]	lpParameters	= 
 * @param [in]	lpDirectory		= ƃfBNg
 * @param [in]	nShowCmd		= \R}h
 * @return	nh
*//***********************************************************************/
HINSTANCE ExecuteEx (HWND hwnd, LPCTSTR lpOperation, LPCTSTR lpFile, LPCTSTR lpParameters
					, LPCTSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFO  lpsei)
{
#ifdef UNICODE
	return ExecuteExW(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd, lpsei);
#else
	return ExecuteExA(hwnd, lpOperation, lpFile, lpParameters, lpDirectory, nShowCmd, lpsei);
#endif
}
/// iris::wx::ExecuteEx Q
HINSTANCE ExecuteExA(HWND hwnd, LPCSTR  lpOperation, LPCSTR  lpFile, LPCSTR  lpParameters
					, LPCSTR  lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOA lpsei)
{
	SHELLEXECUTEINFOA sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteExA(&sei) == 0 ) return 0;
	if( lpsei != nullptr )
	{
		*lpsei = sei;
	}
	else
	{
		CloseHandle(sei.hProcess);
	}
	return sei.hInstApp;
}
/// iris::wx::ExecuteEx Q
HINSTANCE ExecuteExW(HWND hwnd, LPCWSTR lpOperation, LPCWSTR lpFile, LPCWSTR lpParameters
					, LPCWSTR lpDirectory, INT nShowCmd, LPSHELLEXECUTEINFOW lpsei)
{
	SHELLEXECUTEINFOW sei = {0};
	sei.cbSize	= sizeof(sei);
	sei.hwnd	= hwnd;
	sei.lpFile	= lpFile;
	sei.nShow	= nShowCmd;
	sei.fMask	= SEE_MASK_DOENVSUBST;
	sei.lpDirectory		= lpDirectory;
	sei.lpParameters	= lpParameters;
	sei.lpVerb			= lpOperation;
	if( ShellExecuteExW(&sei) == 0 ) return 0;
	if( lpsei != nullptr )
	{
		*lpsei = sei;
	}
	else
	{
		CloseHandle(sei.hProcess);
	}
	return sei.hInstApp;
}

}	// end of namespace wx
}	// end of namespace iris
