//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXNotifyIcon.h
 * @brief		NotifyIconNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXNotifyIcon_H_
#define _IRIS_WXNotifyIcon_H_

//======================================================================
// include
#include "iris_object.h"
#include <shellapi.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! NotifyIconNX
class CNotifyIcon : public IIrisObject
{
protected:
	NOTIFYICONDATA	m_Data;	//!< f[^
public:
	// RXgN^
	CNotifyIcon(void);
	// fXgN^
	~CNotifyIcon(void);

public:
	// ǉ
	BOOL	Add(HWND hWnd, UINT uID, UINT uFlags, UINT uCallbackMsg, HICON hIcon, LPCTSTR lpszTip);
	BOOL	Add(PNOTIFYICONDATA lpnid);
	BOOL	Add(void);
	// ύX
	BOOL	Modify(void);
	// 폜
	BOOL	Delete(void);
	// tH[JX
	BOOL	SetFocus(void);
	// o[W
	BOOL	SetVersion(void);

public:
	// XgA
	BOOL	Restore(UINT uMsg);
	BOOL	Restore(void);
	// Explorer̍ċNbZ[W̎擾
	UINT	GetTaskbarCreatedMessage(void);

public:
	// 
	NOTIFYICONDATA&	GetData(void)		{ return m_Data; }
	operator	NOTIFYICONDATA (void)	{ return GetData(); }
	NOTIFYICONDATA&	operator () (void)	{ return GetData(); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
