//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXNotifyIcon.cpp
 * @brief		NotifyIconNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXNotifyIcon_CPP_

//======================================================================
// include
#include "WXNotifyIcon.h"
#include <tchar.h>

//======================================================================
// link
#pragma comment ( lib, "shlwapi.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CNotifyIcon::CNotifyIcon(void)
{
	m_Data.cbSize = sizeof(m_Data);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CNotifyIcon::~CNotifyIcon(void)
{
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= 
 * @param [in]	uID				= 
 * @param [in]	uFlags			= tO(NIF_***)
 * @param [in]	hIcon			= 
 * @param [in]	uCallbackMsg	= 
 * @param [in]	lpszTip			= 
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Add(HWND hWnd, UINT uID, UINT uFlags, UINT uCallbackMsg, HICON hIcon, LPCTSTR lpszTip)
{
	m_Data.hWnd		= hWnd;
	m_Data.uID		= uID;
	m_Data.uFlags	= uFlags;
	m_Data.uCallbackMessage	= uCallbackMsg;
	m_Data.hIcon	= hIcon;
	if( lpszTip != nullptr )
		_tcscpy_s( m_Data.szTip, sizeof(m_Data.szTip)/sizeof(m_Data.szTip[0]), lpszTip );
	else
		memset( m_Data.szTip, 0, sizeof(m_Data.szTip) );

	return Shell_NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @param [in]	lpnid			= ݒ
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Add(PNOTIFYICONDATA lpnid)
{
	if( lpnid == nullptr ) return FALSE;
	memcpy( &m_Data, lpnid, sizeof(m_Data) );
	m_Data.cbSize = sizeof(m_Data);
	return Shell_NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * ǉ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Add(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return Shell_NotifyIcon(NIM_ADD, &m_Data);
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Delete(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return Shell_NotifyIcon(NIM_DELETE, &m_Data);
}

/**********************************************************************//**
 *
 * ύX
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Modify(void)
{
	m_Data.cbSize = sizeof(m_Data);
	return Shell_NotifyIcon(NIM_MODIFY, &m_Data);
}

/**********************************************************************//**
 *
 * tH[JX
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::SetFocus(void)
{
#if (_WIN32_IE >= 0x0500)
	//m_Data.cbSize = sizeof(m_Data);
	//return Shell_NotifyIcon(NIM_SETFOCUS, &m_Data);
	return FALSE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * o[Wݒ
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::SetVersion(void)
{
#if (_WIN32_IE >= 0x0500)
	//m_Data.cbSize = sizeof(m_Data);
	//return Shell_NotifyIcon(NIM_SETVERSION, &m_Data);
	return FALSE;
#else
	return FALSE;
#endif
}

/**********************************************************************//**
 *
 * XgA
 *
 ----------------------------------------------------------------------
 * @param [in]	uMsg	= bZ[W
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Restore(UINT uMsg)
{
	if( uMsg == GetTaskbarCreatedMessage() )
	{
		return Restore();
	}
	return FALSE;
}

/**********************************************************************//**
 *
 * XgA
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CNotifyIcon::Restore(void)
{
	BOOL ret = Delete();
	ret |= Add();
	return ret;
}

/**********************************************************************//**
 *
 * Explorer̍ċNbZ[W̎擾
 *
 ----------------------------------------------------------------------
 * @return	bZ[W
*//***********************************************************************/
UINT CNotifyIcon::GetTaskbarCreatedMessage(void)
{
	return RegisterWindowMessage( TEXT("TaskbarCreated") );
}

}	// end of namespace wx
}	// end of namespace iris
