//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCommDlg.cpp
 * @brief		t@CEtH_I[v֘A
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXCommDlg_CPP_

//======================================================================
// include
#include "iris_inchead.h"
#include "WXCommDlg.h"

//======================================================================
// function
#if (_WIN32_IE < 0x0601)
static void SHFree(ITEMIDLIST* pidl)
{
    IMalloc*  pMalloc;
    SHGetMalloc( &pMalloc );
    if( pMalloc != nullptr )
    {
        pMalloc->Free( pidl );
        pMalloc->Release();
    }
}
#endif

namespace iris {
namespace wx
{

//======================================================================
// declare
static int CALLBACK BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData);

//======================================================================
// function

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[ (*)"(*.txt)\0*.txt\0(*.*)\0*.*"
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileOpenDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, DWORD dwSize, DWORD Flags)
{
   OPENFILENAME OFN;
   return FileOpenDlg(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, DWORD dwSize, DWORD Flags)
{
   OPENFILENAMEA OFN;
   return FileOpenDlgA(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, DWORD dwSize, DWORD Flags)
{
   OPENFILENAMEW OFN;
   return FileOpenDlgW(hWnd, Filter, FileName, dwSize, Flags, &OFN);
}

/**********************************************************************//**
 *
 * ut@CJv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @param [in]	ofn			= 
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileOpenDlg(HWND hWnd, LPCTSTR Filter, LPTSTR FileName, DWORD dwSize, DWORD Flags, OPENFILENAME* ofn)
{
#ifdef UNICODE
	return FileOpenDlgW(hWnd, Filter, FileName, dwSize, Flags, ofn);
#else
	return FileOpenDlgA(hWnd, Filter, FileName, dwSize, Flags, ofn);
#endif
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, DWORD dwSize, DWORD Flags, OPENFILENAMEA* ofn)
{
	ZeroMemory(ofn, sizeof(OPENFILENAMEA));
	ofn->lStructSize	= sizeof(OPENFILENAMEA); 
	ofn->hwndOwner		= hWnd;
	ofn->lpstrFilter	= Filter;
	ofn->lpstrFile		= FileName;	 
	ofn->nMaxFile		= dwSize;
	ofn->Flags			= Flags;	
	ofn->lpstrTitle		= IRIS_TEXTA("t@CIĂ");
	return (GetOpenFileNameA(ofn));
}
/// iris::wx::FileOpenDlg Q
BOOL FileOpenDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, DWORD dwSize, DWORD Flags, OPENFILENAMEW* ofn)
{
	ZeroMemory(ofn, sizeof(OPENFILENAMEW));
	ofn->lStructSize	= sizeof(OPENFILENAMEW); 
	ofn->hwndOwner		= hWnd;
	ofn->lpstrFilter	= Filter;
	ofn->lpstrFile		= FileName;	 
	ofn->nMaxFile		= dwSize;
	ofn->Flags			= Flags;	
	ofn->lpstrTitle		= IRIS_TEXTW("t@CIĂ");
	return (GetOpenFileNameW(ofn));
}

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileSaveDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, LPCTSTR defext, DWORD dwSize, DWORD Flags)
{
   OPENFILENAME OFN;
   return FileSaveDlg (hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}
/// iris::wx::FileSaveDlg Q
BOOL FileSaveDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, LPCSTR  defext, DWORD dwSize, DWORD Flags)
{
   OPENFILENAMEA OFN;
   return FileSaveDlgA(hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}
/// iris::wx::FileSaveDlg Q
BOOL FileSaveDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, LPCWSTR defext, DWORD dwSize, DWORD Flags)
{
   OPENFILENAMEW OFN;
   return FileSaveDlgW(hWnd, Filter, FileName, defext, dwSize, Flags, &OFN);
}

/**********************************************************************//**
 *
 * ut@Cۑv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [in]	Filter		= tB^[
 * @param [out]	FileName	= t@C̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @param [in]	ofn			= 
 * @return	t@CI@true@ 
*//***********************************************************************/
BOOL FileSaveDlg (HWND hWnd, LPCTSTR Filter, LPTSTR FileName, LPCTSTR defext, DWORD dwSize, DWORD Flags, OPENFILENAME* ofn)
{
#ifdef UNICODE
	return FileSaveDlgW(hWnd, Filter, FileName, defext, dwSize, Flags, ofn);
#else
	return FileSaveDlgA(hWnd, Filter, FileName, defext, dwSize, Flags, ofn);
#endif
}
BOOL FileSaveDlgA(HWND hWnd, LPCSTR  Filter, LPSTR  FileName, LPCSTR  defext, DWORD dwSize, DWORD Flags, OPENFILENAMEA* ofn)
{
   ZeroMemory(ofn,sizeof(OPENFILENAMEA));
   ofn->lStructSize	= sizeof(OPENFILENAMEA); 
   ofn->hwndOwner	= hWnd;
   ofn->lpstrFilter	= Filter;
   ofn->lpstrFile	= FileName;
   ofn->nMaxFile	= dwSize;
   ofn->Flags		= Flags;
   ofn->lpstrDefExt	= defext;
   ofn->lpstrTitle	= IRIS_TEXTA("Otĕۑ");
   return (GetSaveFileNameA(ofn));
}
BOOL FileSaveDlgW(HWND hWnd, LPCWSTR Filter, LPWSTR FileName, LPCWSTR defext, DWORD dwSize, DWORD Flags, OPENFILENAMEW* ofn)
{
   ZeroMemory(ofn,sizeof(OPENFILENAMEW));
   ofn->lStructSize	= sizeof(OPENFILENAMEW); 
   ofn->hwndOwner	= hWnd;
   ofn->lpstrFilter	= Filter;
   ofn->lpstrFile	= FileName;
   ofn->nMaxFile	= dwSize;
   ofn->Flags		= Flags;
   ofn->lpstrDefExt	= defext;
   ofn->lpstrTitle	= IRIS_TEXTW("Otĕۑ");
   return (GetSaveFileNameW(ofn));
}

/**********************************************************************//**
 *
 * utH_Jv_CAO\
 *
 -----------------------------------------------------------------------
 * @param [in]	hwnd		= eEChẼnh
 * @param [out]	FolderName	= tH_̃tpX(߂l)
 * @param [in]	Flags		= _CAÕtO
 * @return	tH_I@true@ 
*//***********************************************************************/
BOOL FolderOpenDlg (HWND hWnd, LPTSTR FolderName, DWORD Flags)
{
#ifdef UNICODE
	return FolderOpenDlgW(hWnd, FolderName, Flags);
#else
	return FolderOpenDlgA(hWnd, FolderName, Flags);
#endif
}
/// iris::wx::FolderOpenDlg Q
BOOL FolderOpenDlgA(HWND hWnd, LPSTR  FolderName, DWORD Flags)
{
	BROWSEINFOA	bi;
	ITEMIDLIST	*idl;
	LPMALLOC	g_pMalloc;

	// IMallocC^tF[X̎擾
	SHGetMalloc(&g_pMalloc);

	bi.hwndOwner		= hWnd;
	bi.pidlRoot			= nullptr;			 // Jn_(nullptrȂdesktop)
	bi.pszDisplayName	= FolderName;
	bi.lpszTitle		= IRIS_TEXTA("tH_IĂ");
	bi.ulFlags			= Flags;
	bi.lpfn				= &BrowseCallbackProc;
	bi.lParam			= (LPARAM)FolderName;
	bi.iImage			= 0;
	// tH_̎Qƃ_CAO\
	idl=SHBrowseForFolderA(&bi);
	if(idl != nullptr)
	{
		// VXet@CpXɕϊ
		SHGetPathFromIDListA(idl,FolderName);
		// PIDL
		SHFree(idl);
		return 1;
	}
	return 0;
}
/// iris::wx::FolderOpenDlg Q
BOOL FolderOpenDlgW(HWND hWnd, LPWSTR FolderName, DWORD Flags)
{
	BROWSEINFOW	bi;
	ITEMIDLIST	*idl;
	LPMALLOC	g_pMalloc;

	// IMallocC^tF[X̎擾
	SHGetMalloc(&g_pMalloc);

	bi.hwndOwner		= hWnd;
	bi.pidlRoot			= nullptr;			 // Jn_(nullptrȂdesktop)
	bi.pszDisplayName	= FolderName;
	bi.lpszTitle		= IRIS_TEXTW("tH_IĂ");
	bi.ulFlags			= Flags;
	bi.lpfn				= &BrowseCallbackProc;
	bi.lParam			= (LPARAM)FolderName;
	bi.iImage			= 0;
	// tH_̎Qƃ_CAO\
	idl=SHBrowseForFolderW(&bi);
	if(idl != nullptr)
	{
		// VXet@CpXɕϊ
		SHGetPathFromIDListW(idl,FolderName);
		// PIDL
		SHFree(idl);
		return 1;
	}
	return 0;
}

/**********************************************************************//**
 *
 *						OpenChooseColorDlg
 *
 -----------------------------------------------------------------------
 * @param [in]	hOwner		= eEChẼnh
 * @param [out]	pResult		= IF(߂l)
 * @param [in]	pCustColors	= JX^J[z
 * @param [in]	Flags		= ݒtO
 * @return	FI@true@ 
*//***********************************************************************/
BOOL OpenChooseColorDlg(HWND hOwner, COLORREF* pResult, COLORREF* pCustColors, DWORD Flags)
{
	CHOOSECOLOR cc;
	memset(&cc, 0, sizeof(CHOOSECOLOR));
	cc.lStructSize = sizeof(CHOOSECOLOR);
	cc.hwndOwner = hOwner;
	cc.rgbResult = *pResult;
	cc.lpCustColors = pCustColors;
	cc.Flags = Flags;
	if( pCustColors == nullptr )
	{
		COLORREF def[16];
		cc.lpCustColors = def;
		if( !ChooseColor(&cc) ) return FALSE;
	}
	else
	{
		if( !ChooseColor(&cc) ) return FALSE;
	}
	*pResult = cc.rgbResult;
	return TRUE;
}

/**********************************************************************//**
 *
 *						OpenChooseFontDlg
 *
 -----------------------------------------------------------------------
 * @param [in]	hOwner		= eEChẼnh
 * @param [out]	lpLogFont	= tHg(߂l)
 * @param [out]	pColor		= tHgJ[(߂l)
 * @param [in]	SizeMin		= ŏtHgTCY
 * @param [in]	SizeMax		= őtHgTCY
 * @param [in]	Flags		= ݒtO
 * @return	tHgI@true@ 
*//***********************************************************************/
BOOL OpenChooseFontDlg(HWND hOwner, LOGFONT* lpLogFont, COLORREF* pColor, int SizeMin, int SizeMax, DWORD Flags)
{
	CHOOSEFONT cf;
	memset(&cf, 0, sizeof(cf));
	COLORREF ColorTemp=0x00000000;
	if( pColor == nullptr ) pColor = &ColorTemp;

	cf.lStructSize = sizeof(CHOOSEFONT);
	cf.hwndOwner = hOwner;
	cf.lpLogFont = lpLogFont;
	cf.nSizeMin = SizeMin;
	cf.nSizeMax = SizeMax;
	cf.Flags = Flags;
	cf.rgbColors = *pColor;
	if(ChooseFont(&cf))
	{
		*pColor = cf.rgbColors;
		return 1;
	}
	return 0;
}

int CALLBACK BrowseCallbackProc(HWND hWnd, UINT uMsg, LPARAM lParam, LPARAM lpData)
{
	IRIS_UNUSED_VARIABLE(lParam);
    if(uMsg == BFFM_INITIALIZED)
	{
        SendMessage(hWnd, BFFM_SETSELECTION, (WPARAM)TRUE, lpData);
    }
    return 0;
}

}	// end of namespace wx
}	// end of namespace iris
