//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStaringTable.cpp
 * @brief		StringTablet@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXStringTable_CPP_

//======================================================================
// include
#include "WXStringTable.h"

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// define
// ŏ
#ifndef STRING_TABLE_LENGTH_MIN
#define STRING_TABLE_LENGTH_MIN		64
#endif
// ő啶
// Ȃ̏ꍇ͒`Ȃ
//#define STRING_TABLE_LENGTH_MAX		1024

// 擾x
// (STRING_TABLE_LENGTH_MINSTRING_TABLE_ACCURACYZẴobt@𐶐B)
#ifndef STRING_TABLE_ACCURACY
#define STRING_TABLE_ACCURACY		64	
#endif

//======================================================================
// class

//----------------------------------------------------------------------
// CStringTableA
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStringTableA::CStringTableA(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStringTableA::~CStringTableA(void)
{
	for( iterator it = m_StringArray.begin(); it != m_StringArray.end(); )
	{
		LPSTR p = *it;
		it = m_StringArray.erase(it);
		delete [] p;
	}
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
LPSTR CStringTableA::Get(int nID, LPSTR pDefString)
{
	return Get(GetModuleHandle(nullptr), nID, pDefString);
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	nID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
LPSTR CStringTableA::Get(HINSTANCE hInst, int nID, LPSTR pDefString)
{
	LPSTR pString = nullptr;

#ifdef STRING_TABLE_LENGTH_MAX
	CHAR tmp[STRING_TABLE_LENGTH_MAX+1];
	int len = LoadStringA(hInst, id, tmp, STRING_TABLE_LENGTH_MAX+1);
	if( len == 0 )
	{
		// s
		// \[X݂Ȃ
		return pDefString;
	}
	pString = new CHAR [len+1];
	LoadStringA(hInst, id, pString, len+1);
#else
	int dwLen = STRING_TABLE_LENGTH_MIN;
	while(1)
	{
		pString = new CHAR [dwLen+1];
		if( pString == nullptr ) 
		{
			// obt@mۂɎs
			return pDefString;
		}
		int len = LoadStringA(hInst, nID, pString, dwLen+1);
		if( len == 0 )
		{
			// s
			// \[X݂Ȃ
			return pDefString;
		}
		if( len < dwLen ) 
		{
#if 1
			delete [] pString;
			pString = new CHAR [len+1];
			LoadStringA(hInst, nID, pString, len+1);
#endif
			break;	// I
		}
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen >= STRING_TABLE_LENGTH_MAX ) break;	// ő啶
#endif

		// mۂobt@StringTableł
		dwLen += STRING_TABLE_ACCURACY;
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen > STRING_TABLE_LENGTH_MAX ) dwLen = STRING_TABLE_LENGTH_MAX;
#endif
		delete [] pString;
	}
#endif
	m_StringArray.push_back(pString);
	return pString;
}

//----------------------------------------------------------------------
// CStringTableW

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStringTableW::CStringTableW(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStringTableW::~CStringTableW(void)
{
	for( iterator it = m_StringArray.begin(); it != m_StringArray.end(); )
	{
		LPWSTR p = *it;
		it = m_StringArray.erase(it);
		delete [] p;
	}
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	nID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
LPWSTR CStringTableW::Get(int nID, LPWSTR pDefString)
{
	return Get(GetModuleHandle(nullptr), nID, pDefString);
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hInst		= CX^Xnh
 * @param [in]	nID			= \[XID
 * @param [in]	pDefString	= 擾sƂ̕
 * @return	擾
*//***********************************************************************/
LPWSTR CStringTableW::Get(HINSTANCE hInst, int nID, LPWSTR pDefString)
{
	LPWSTR pString = nullptr;

#ifdef STRING_TABLE_LENGTH_MAX
	WCHAR tmp[STRING_TABLE_LENGTH_MAX+1];
	int len = LoadStringW(hInst, id, tmp, STRING_TABLE_LENGTH_MAX+1);
	if( len == 0 )
	{
		// s
		// \[X݂Ȃ
		return pDefString;
	}
	pString = new WCHAR [len+1];
	LoadString(hInst, id, pString, len+1);
#else
	int dwLen = STRING_TABLE_LENGTH_MIN;
	while(1)
	{
		pString = new WCHAR [dwLen+1];
		if( pString == nullptr ) 
		{
			// obt@mۂɎs
			return pDefString;
		}
		int len = LoadStringW(hInst, nID, pString, dwLen+1);
		if( len == 0 )
		{
			// s
			// \[X݂Ȃ
			return pDefString;
		}
		if( len < dwLen ) 
		{
#if 1
			delete [] pString;
			pString = new WCHAR [len+1];
			LoadStringW(hInst, nID, pString, len+1);
#endif
			break;	// I
		}
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen >= STRING_TABLE_LENGTH_MAX ) break;	// ő啶
#endif

		// mۂobt@StringTableł
		dwLen += STRING_TABLE_ACCURACY;
#ifdef STRING_TABLE_LENGTH_MAX
		if( dwLen > STRING_TABLE_LENGTH_MAX ) dwLen = STRING_TABLE_LENGTH_MAX;
#endif
		delete [] pString;
	}
#endif
	m_StringArray.push_back(pString);
	return pString;
}

}	// end of namespace wx
}	// end of namespace iris
