//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXProfile.cpp
 * @brief		ProfileNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXProfile_CPP_

//======================================================================
// include
#include "WXProfile.h"
#include <tchar.h>

#include "../debug/WXDebugLeakCheckMacro.h"

namespace iris {
namespace wx
{

//======================================================================
// function

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileIntA(LPCSTR  lpAppName, LPCSTR  lpKeyName, UINT nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "%d", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileIntA Q
BOOL WritePrivateProfileIntW(LPCWSTR lpAppName, LPCWSTR lpKeyName, UINT nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"%d", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@Cɐl(HEX)
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "0x%x", nValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileHexA Q
BOOL WritePrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"0x%x", nValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C琮l(HEX)擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= ftHgl
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
DWORD GetPrivateProfileHexA(LPCSTR  lpAppName, LPCSTR  lpKeyName, DWORD nDefault, LPCSTR  lpFileName)
{
	DWORD ret=0;
	CHAR val[128], def[128];
	wsprintfA(def, "%x", nDefault);
	DWORD size = GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	LPSTR p = val;
	if( *p == '0' && *(p+1) == 'x' ) p+=2;
	LPSTR e = val+size;
	for( int i=0; e >= p; --e)
	{
		if( *e >= '0' && *e <= '9' )		ret += ((*e) - '0'      ) << i;
		else if( *e >= 'a' && *e <= 'f' )	ret += ((*e) - 'a' + 0xa) << i;
		else if( *e >= 'A' && *e <= 'F' )	ret += ((*e) - 'a' + 0xa) << i;
		else continue;
		i+=4;
	}
	return ret;
}
/// iris::wx::GetPrivateProfileHexA Q
DWORD GetPrivateProfileHexW(LPCWSTR lpAppName, LPCWSTR lpKeyName, DWORD nDefault, LPCWSTR lpFileName)
{
	UINT ret=0;
	WCHAR val[128], def[128];
	wsprintfW(def, L"%x", nDefault);
	DWORD size = GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	LPWSTR p = val;
	if( *p == L'0' && *(p+1) == L'x' ) p+=2;
	LPWSTR e = val+size;
	for( int i=0; e >= p; --e)
	{
		if( *e >= L'0' && *e <= L'9' )		ret += ((*e) - L'0'      ) << i;
		else if( *e >= L'a' && *e <= L'f' )	ret += ((*e) - L'a' + 0xa) << i;
		else if( *e >= L'A' && *e <= L'F' )	ret += ((*e) - L'a' + 0xa) << i;
		else continue;
		i+=4;
	}
	return ret;
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fValue, LPCSTR  lpFileName)
{
	CHAR val[128];
	wsprintfA(val, "%f", fValue);
	return WritePrivateProfileStringA(lpAppName, lpKeyName, val, lpFileName);
}
/// iris::wx::WritePrivateProfileFloatA Q
BOOL WritePrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fValue, LPCWSTR lpFileName)
{
	WCHAR val[128];
	wsprintfW(val, L"%f", fValue);
	return WritePrivateProfileStringW(lpAppName, lpKeyName, val, lpFileName);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @param [in]	lpFileName	= t@C
 * @return	l
*//***********************************************************************/
float	GetPrivateProfileFloatA(LPCSTR  lpAppName, LPCSTR  lpKeyName, float fDefault, LPCSTR  lpFileName)
{
	CHAR val[128], def[128];
	wsprintfA(def, "%f", fDefault);
	GetPrivateProfileStringA(lpAppName, lpKeyName, def, val, 128, lpFileName);
	float ret = (float)atof(val);
	return ret;
}
/// iris::wx::GetPrivateProfileFloatA Q
float	GetPrivateProfileFloatW(LPCWSTR lpAppName, LPCWSTR lpKeyName, float fDefault, LPCWSTR lpFileName)
{
	WCHAR val[128], def[128];
	wsprintfW(def, L"%f", fDefault);
	GetPrivateProfileStringW(lpAppName, lpKeyName, def, val, 128, lpFileName);
	// TODO:wcharł͂ǂ́H
	//float ret = (float)atof(val);
	return fDefault;
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= EBhEnh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL WritePrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}
/// iris::wx::WritePrivateProfileWindowPlacementA Q
BOOL WritePrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( GetWindowPlacement(hWnd, &wndpl) == 0 ) return 0;
	return WritePrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(wndpl), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCSTR  lpFileName)
{
	return GetPrivateProfileStructA(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl, LPCWSTR lpFileName)
{
	return GetPrivateProfileStructW(lpAppName, lpKeyName, lpwdpl, sizeof(WINDOWPLACEMENT), lpFileName);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @param [in]	lpFileName	= t@C
 * @return	
*//***********************************************************************/
BOOL GetPrivateProfileWindowPlacementA(LPCSTR  lpAppName, LPCSTR  lpKeyName, HWND hWnd, LPCSTR  lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructA(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}
/// iris::wx::GetPrivateProfileWindowPlacementA Q
BOOL GetPrivateProfileWindowPlacementW(LPCWSTR lpAppName, LPCWSTR lpKeyName, HWND hWnd, LPCWSTR lpFileName)
{
	WINDOWPLACEMENT wndpl;
	if( !GetPrivateProfileStructW(lpAppName, lpKeyName, &wndpl, sizeof(WINDOWPLACEMENT), lpFileName) )
		return FALSE;
	SetWindowPlacement(hWnd, &wndpl);
	return TRUE;
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CPrivateProfile::CPrivateProfile(void)
{
	m_Path[0] = IRIS_TEXT('\0');
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CPrivateProfile::~CPrivateProfile(void)
{
	Close();
}

/**********************************************************************//**
 *
 * J
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
void CPrivateProfile::Open(LPCTSTR path)
{
	_tcscpy_s(m_Path, MAX_PATH, path);
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CPrivateProfile::Close(void)
{
	ZeroMemory(m_Path,sizeof(m_Path));
	ClearProfileList();
}

/**********************************************************************//**
 *
 * ݂ZNV擾
 *
 -----------------------------------------------------------------------
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetSectionNames(LPTSTR lpReturn, DWORD nSize)
{
	return GetPrivateProfileSectionNames(lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * ZNVɑ݂L[擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [out]	lpReturn	= o̓obt@(L['\0'؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetSection(LPCTSTR lpAppName, LPTSTR lpReturn, DWORD nSize)
{
	return GetPrivateProfileSection(lpAppName, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C當擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpDefault	= sƂɕԂ
 * @param [out]	lpReturn	= o̓obt@(L['='؂ŏo͂)
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetString(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpDefault, LPTSTR lpReturn, DWORD nSize)
{
	return GetPrivateProfileString(lpAppName, lpKeyName, lpDefault, lpReturn, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@C琮l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
UINT CPrivateProfile::GetInt(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nDefault)
{
	return GetPrivateProfileInt(lpAppName, lpKeyName, nDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C珬l擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fDefault	= sƂɕԂl
 * @return	l
*//***********************************************************************/
float CPrivateProfile::GetFloat(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fDefault)
{
	return GetPrivateProfileFloat(lpAppName, lpKeyName, fDefault, m_Path);
}

/**********************************************************************//**
 *
 * t@C\̂擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [out]	lpStruct	= o̓obt@
 * @param [in]	nSize		= o̓obt@TCY
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetStruct(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize)
{
	return GetPrivateProfileStruct(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpwdpl		= o̓obt@(WINDOWPLACEMENT)
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPWINDOWPLACEMENT lpwdpl)
{
	return GetPrivateProfileWindowPlacement(lpAppName, lpKeyName, lpwdpl, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= o͐nh
 * @return	
*//***********************************************************************/
DWORD CPrivateProfile::GetWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd)
{
	return GetPrivateProfileWindowPlacement(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * t@CɃL[
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpString	= L[
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteSection(LPCTSTR lpAppName, LPCTSTR lpString)
{
	return WritePrivateProfileSection(lpAppName,lpString,m_Path);
}

/**********************************************************************//**
 *
 * t@Cɐl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	nValue		= L[l
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteInt(LPCTSTR lpAppName, LPCTSTR lpKeyName, UINT nValue)
{
	return WritePrivateProfileInt(lpAppName,lpKeyName,nValue,m_Path);
}

/**********************************************************************//**
 *
 * t@Cɏl
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	fValue		= L[l
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteFloat(LPCTSTR lpAppName, LPCTSTR lpKeyName, float fValue)
{
	return WritePrivateProfileFloat(lpAppName, lpKeyName, fValue, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɕ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpString	= 
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteString(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPCTSTR lpString)
{
	return WritePrivateProfileString(lpAppName, lpKeyName, lpString, m_Path);
}

/**********************************************************************//**
 *
 * t@Cɍ\̂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	lpStruct	= \̃|C^
 * @param [in]	nSize		= \̃TCY
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteStruct(LPCTSTR lpAppName, LPCTSTR lpKeyName, LPVOID lpStruct, DWORD nSize)
{
	return WritePrivateProfileStruct(lpAppName, lpKeyName, lpStruct, nSize, m_Path);
}

/**********************************************************************//**
 *
 * t@CWINDOWPLACEMENT
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @param [in]	hWnd		= WINDOWPLACEMENT̎擾EBhEnh
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::WriteWindowPlacement(LPCTSTR lpAppName, LPCTSTR lpKeyName, HWND hWnd)
{
	return WritePrivateProfileWindowPlacement(lpAppName, lpKeyName, hWnd, m_Path);
}

/**********************************************************************//**
 *
 * ZNṼXg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CPrivateProfile::MakeAppList(void)
{
	if( !IsOpen() ) return false;
	if( !m_Profile.empty() ) return true;
	LPTSTR buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new TCHAR [size];
		if( buf == nullptr ) return false;
		DWORD ret = GetPrivateProfileSectionNames(buf, size, m_Path);
		if( ret == 0 ) 
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	LPTSTR tmp = buf;
	LPTSTR p = _tcschr(tmp, TEXT('\0'));
	while(p)
	{
		*p = TEXT('\0');
		std_tstring str = tmp;
		SectionData data;
		m_Profile.push_back(ProfilePair(str, data));
		tmp = p+1;
		p = _tcschr(tmp, TEXT('\0'));
		if( tmp == p ) break;
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * L[̃Xg
 *  ŃZNṼXg܂
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
bool CPrivateProfile::MakeKeyList(LPCTSTR lpAppName)
{
	if( !MakeAppList() ) return false;
	SectionData* pData = FindSectionData(lpAppName);
	if( pData == nullptr ) return false;
	return MakeKeyList(lpAppName, m_Path, *pData);
}

/**********************************************************************//**
 *
 * L[̃Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpFileName	= t@C
 * @param [out]	rData		= o
 * @return	
*//***********************************************************************/
bool CPrivateProfile::MakeKeyList(LPCTSTR lpAppName, LPCTSTR lpFileName, SectionData& rData)
{
	if( lpAppName == nullptr ) return false;
	if( lpFileName == nullptr ) return false;
	LPTSTR buf=nullptr;
	DWORD size=1024;
	while(1)
	{
		buf = new TCHAR [size];
		if( buf == nullptr ) return false;
		DWORD ret = GetPrivateProfileSection(lpAppName, buf, size, lpFileName);
		if( ret == 0 ) 
		{
			IRIS_SAFE_DELETE_ARRAY(buf);
			return false;
		}
		if( ret < size-2 ) break;
		size += 256;
		IRIS_SAFE_DELETE_ARRAY(buf);
	}
	LPTSTR tmp = buf;
	LPTSTR p = _tcschr(tmp,TEXT('='));
	while(p)
	{
		*p = TEXT('\0');
		// L[
		std_tstring str = tmp;
		tmp = p+1;
		p = _tcschr(tmp, TEXT('\0'));

		// L[l
		KeyData val = tmp;
		rData.push_back(SectionPair(str, val));
		tmp = p+1;
		if( tmp == TEXT('\0') ) break;
		p = _tcschr(tmp, TEXT('='));
	}
	IRIS_SAFE_DELETE_ARRAY(buf);
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[̃Xg
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CPrivateProfile::MakeProfileList(void)
{
	if( !MakeAppList() ) return false;
	for( ProfileData::iterator it=m_Profile.begin(), end = m_Profile.end(); it != end; ++it)
	{
		MakeKeyList(it->first.c_str());
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNVEL[Xg̃NA
 *
*//***********************************************************************/
void CPrivateProfile::ClearProfileList(void)
{
	m_Profile.clear();
}

/**********************************************************************//**
 *
 * Xg
 *
 -----------------------------------------------------------------------
 * @param [in]	path	= pX
*//***********************************************************************/
bool CPrivateProfile::WriteList(bool bClear)
{
	if( !IsOpen() ) return false;
	if( bClear ) DeleteFile(m_Path);

	for( ProfileData::iterator it = m_Profile.begin(), end = m_Profile.end(); it != end; ++it )
	{
		for( SectionData::iterator sub_it = it->second.begin(), sub_end = it->second.end(); sub_it != sub_end; ++sub_it )
		{
			WritePrivateProfileString(it->first.c_str(), sub_it->first.c_str(), sub_it->second.c_str(), m_Path);
		}
	}
	return true;
}

/**********************************************************************//**
 *
 * ZNV̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nIndex	= CfbNX
 * @return	ZNV
*//***********************************************************************/
CPrivateProfile::std_tstring* CPrivateProfile::GetAppName(int nIndex)
{
	if( nIndex < 0 || nIndex >= (int)m_Profile.size() ) return nullptr;
	return &m_Profile[nIndex].first;
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CPrivateProfile::std_tstring* CPrivateProfile::GetKeyName(int nAppIndex, int nIndex)
{
	std_tstring* p = GetAppName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyName(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CPrivateProfile::std_tstring* CPrivateProfile::GetKeyName(LPCTSTR lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].first);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	nAppIndex	= ZNVCfbNX
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CPrivateProfile::KeyData* CPrivateProfile::GetKeyData(int nAppIndex, int nIndex)
{
	std_tstring* p = GetAppName(nAppIndex);
	if( p == nullptr ) return nullptr;
	return GetKeyData(p->c_str(), nIndex);
}

/**********************************************************************//**
 *
 * L[l̎擾
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	nIndex		= L[CfbNX
 * @return	L[
*//***********************************************************************/
CPrivateProfile::KeyData* CPrivateProfile::GetKeyData(LPCTSTR lpAppName, int nIndex)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return nullptr;
	if( nIndex < 0 || nIndex >= (int)p->size() ) return nullptr;
	return &((*p)[nIndex].second);
}

/**********************************************************************//**
 *
 * ZNV폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::DeleteSection(LPCTSTR lpAppName)
{
	ProfileData::iterator it = m_Profile.find(std_tstring(lpAppName));
	if( it == m_Profile.end() ) return FALSE;
	m_Profile.erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * L[폜
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @param [in]	lpKeyName	= L[
 * @return	
*//***********************************************************************/
BOOL CPrivateProfile::DeleteKey(LPCTSTR lpAppName, LPCTSTR lpKeyName)
{
	SectionData* p = FindSectionData(lpAppName);
	if( p == nullptr ) return FALSE;
	SectionData::iterator it = p->find(std_tstring(lpKeyName));
	if( it == p->end() ) return FALSE;
	p->erase(it);
	return TRUE;
}

/**********************************************************************//**
 *
 * L[Xǧ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpAppName	= ZNV
 * @return	ZNVf[^
*//***********************************************************************/
CPrivateProfile::SectionData* CPrivateProfile::FindSectionData(LPCTSTR lpAppName)
{
	ProfileData::iterator it = m_Profile.find(std_tstring(lpAppName));
	if( it == m_Profile.end() ) return nullptr;
	return &it->second;
}

}	// end of namespace wx
}	// end of namespace iris
