//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXWindows.cpp
 * @brief		Windows֐t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXWindows_CPP_

//======================================================================
// include
#include "WXWindows.h"
#include <stdio.h>
#include <tchar.h>
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * Windows̏I
 *
 -----------------------------------------------------------------------
 * @param [in]	uFlags		= IIvV(EWX_***)
 * @param [in]	dwReason	= 
 * @return 
*//***********************************************************************/
BOOL ExitWindowsEx(UINT uFlags, DWORD dwReason)
{
    HANDLE hToken;
    TOKEN_PRIVILEGES tkp;
	// ̃vZX Token 擾܂
	if( !OpenProcessToken(GetCurrentProcess(), TOKEN_ADJUST_PRIVILEGES | TOKEN_QUERY, &hToken))
	{
		puts("failed OpenProcessToken.");
		return FALSE;
	}

	// Vbg_Ep LUID 擾܂
	if( !LookupPrivilegeValue(nullptr, SE_SHUTDOWN_NAME, &tkp.Privileges[0].Luid) )
	{
		puts("failed LookupPrivilegeValue.");
		return FALSE;
	}

	tkp.PrivilegeCount = 1;      // one privilege to set
	tkp.Privileges[0].Attributes = SE_PRIVILEGE_ENABLED;

	// ̃vZXp Vbg_E擾܂
	if( AdjustTokenPrivileges(hToken, FALSE, &tkp, 0, (PTOKEN_PRIVILEGES)nullptr, 0) )
	{
		puts("failed AdjustTokenPrivileges."); 
		return FALSE;
	}

	if( !ExitWindowsEx(uFlags, dwReason) )
	{
		puts("failed ExitWindowsEx."); 
		return FALSE;
	}
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include <stdio.h>
#include "iris.h"

//======================================================================
// test
IRIS_UNITTEST(CWXWindowsUnitTest, WXWindowsUnitTest)
{
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
