//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXThread.h
 * @brief		Xbht@C
 *
 * @author		t.sirayanagi
 * @version		1.1
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXThread_H_
#define _IRIS_WXThread_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * XbhnhNX
*/
class CThread : public CHandle
{
public:
	typedef	DWORD	return_type;
protected:
	DWORD	m_dwThreadId;	//!< Xbhԍ

public:
	// RXgN^
	CThread(void);
	// fXgN^
	virtual ~CThread(void);

public:
	// ̃nhJ
	bool	Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId);
	// Xbh쐬
	bool	Create(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr);
	// 쐬Ăs
	bool	CreateStart(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr);
	// Xbh̊Jn
	void	Start(void);
	// XbhI
	void	Stop(void);
	// Xbh̏I҂
	DWORD	Wait(void);
	// sǂ擾
	bool	IsActive(void) const;

	// Xbhҋ@Ԃɂ
	void	Suspend(void);
	// ҋ@Ԃ̃XbhJn
	void	Resume(void);

	// XbhI
	BOOL	Terminate(void);

public:
	// Xbh̗D揇ʂύX
	BOOL	SetPriority(int Priority);
	// Xbh̗D揇ʂ擾
	int		GetPriority(void);
	// vCIeBu[Xg̏Ԃ擾
	BOOL	GetPriorityBoost(LPBOOL pDisablePriorityBoost);

	// XbhɃbZ[W𑗐M
	BOOL	PostMessageA(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);
	BOOL	PostMessageW(UINT uMsg, WPARAM wParam = 0, LPARAM lParam = 0);

protected:
	// Xbhnh̍쐬
	virtual HANDLE	_CreateThread(PROC pfnEntry, LPVOID lpArgs);
};

/**
 * XbhGg[NX
 */
template<class _THREAD, typename _RET=_THREAD::return_type>
class CThreadEntry : public _THREAD
{
	typedef _THREAD	_thread_type;
	typedef _RET	_return_type;
private:
	// Xbh̎s
	static _return_type WINAPI Entry(void *pInstance)
	{
		if( pInstance != nullptr )
		{
			try
			{
				reinterpret_cast<CThreadEntry*>(pInstance)->Run();
			}
			catch( ... )
			{
			}
		}
		return 0;
	}

public:
	// RXgN^
	CThreadEntry(void)	{}
	// fXgN^
	virtual ~CThreadEntry(void)	{}

protected:
	/// Xbh̎s
	virtual void Run(void) {}

public:
	/// Xbh쐬
	bool	Create(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs=nullptr)
	{
		return _thread_type::Create(pStart, lpArgs);
	}
	/// Xbh쐬
	bool	Create(void)
	{
		return this->Create(Entry, this);
	}
	/// 쐬Ăs
	bool	CreateStart(void)
	{
		if( !this->Create(Entry, this) ) return false;
		Start();
		return true;
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
