//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXThread.cpp
 * @brief		Xbht@C
 *
 * @author		t.sirayanagi
 * @version		1.1
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================

//======================================================================
// include
#include "WXThread.h"
#include "iris_debug.h"

namespace iris {
namespace wx 
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 * 
*//***********************************************************************/
CThread::CThread(void)
: m_dwThreadId(0)
{
}

/**********************************************************************//**
 *
 * fXgN^
 * 
*//***********************************************************************/
CThread::~CThread(void)
{
	Stop();
}

/**********************************************************************//**
 *
 * XbhJ
 * 
 -----------------------------------------------------------------------
 * @param [in]	dwDesiredAccess	= ANZX(THREAD_*** or SYNCHRONIZE)
 * @param [in]	bInheritHandle	= VvZXɌp邩ǂ
 * @param [in]	dwThreadId		= XbhID
 * @return	
*//***********************************************************************/
bool CThread::Open(DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwThreadId)
{
	HANDLE hThread = ::OpenThread(dwDesiredAccess, bInheritHandle, dwThreadId);
	if( hThread == nullptr )	return false;
	if( !Attach(hThread) )
	{
		CloseHandle(hThread);
		return false;
	}
	m_dwThreadId = dwThreadId;
	return true;
}

/**********************************************************************//**
 *
 * Xbh쐬
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CThread::Create(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs)
{
	Close();
	const int priority = ::GetThreadPriority( ::GetCurrentThread() );
	const bool bOverride = ( priority != THREAD_PRIORITY_NORMAL );
	HANDLE hThread = _CreateThread((PROC)pStart, lpArgs);
	if( hThread == nullptr )	return false;
	if( !Attach(hThread) )
	{
		CloseHandle(hThread);
		return false;
	}
	if( bOverride != false )
	{
		::SetThreadPriority(hThread, priority);
	}
	return true;
}

/**********************************************************************//**
 *
 * Xbh쐬Ăs
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CThread::CreateStart(LPTHREAD_START_ROUTINE pStart, LPVOID lpArgs)
{
	if( !Create(pStart, lpArgs) ) return false;
	Start();
	return true;
}

/**********************************************************************//**
 *
 * XbhJn
 * 
*//***********************************************************************/
void CThread::Start(void)
{
	Resume();
}

/**********************************************************************//**
 *
 * XbhI
 * 
*//***********************************************************************/
void CThread::Stop(void)
{
	Close();
}

/**********************************************************************//**
 *
 * Xbh̏I҂
 * 
 -----------------------------------------------------------------------
 * @return	IR[h
*//***********************************************************************/
DWORD CThread::Wait(void)
{
	DWORD dwExitCode = 0;
	if( IsActive() != false )
	{
		HANDLE hThread = Detach();
		::WaitForSingleObject(hThread, INFINITE);
		::GetExitCodeThread(hThread, &dwExitCode);
		::CloseHandle(hThread);
		m_dwThreadId = 0;
	}
	return dwExitCode;
}

/**********************************************************************//**
 *
 * sǂ擾
 * 
 -----------------------------------------------------------------------
 * @retval	true :s
 * @retval	false:sĂȂ
*//***********************************************************************/
bool CThread::IsActive(void) const
{
	DWORD dwExitCode;
	if( m_hObject == nullptr ) return false;
	if( !::GetExitCodeThread(m_hObject, &dwExitCode) ) return false;
	return dwExitCode == STILL_ACTIVE;
}

/**********************************************************************//**
 *
 * Xbhҋ@Ԃɂ
 * 
*//***********************************************************************/
void CThread::Suspend(void)
{
	::SuspendThread(m_hObject);
}

/**********************************************************************//**
 *
 * ҋ@Ԃ̃XbhJn
 * 
*//***********************************************************************/
void CThread::Resume(void)
{
	::ResumeThread(m_hObject);
}

/**********************************************************************//**
 *
 * XbhI
 * 
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CThread::Terminate(void)
{
	DWORD dwExitCode = 0;
	::GetExitCodeThread(m_hObject, &dwExitCode);
	return ::TerminateThread(m_hObject, dwExitCode);
}

/**********************************************************************//**
 *
 * Xbh̗D揇ʂύX
 * 
 -----------------------------------------------------------------------
 * @param	Priority	= D揇
 * @return	
*//***********************************************************************/
BOOL CThread::SetPriority(int Priority)
{
	return ::SetThreadPriority(m_hObject, Priority);
}

/**********************************************************************//**
 *
 * Xbh̗D揇ʂ擾
 * 
 -----------------------------------------------------------------------
 * @return	D揇
*//***********************************************************************/
int CThread::GetPriority(void)
{
	return ::GetThreadPriority(m_hObject);
}

/**********************************************************************//**
 *
 * vCIeBu[Xg̏Ԃ擾
 * 
 -----------------------------------------------------------------------
 * @param [out]	pDisablePriorityBoost	= o
 * @return	
*//***********************************************************************/
BOOL CThread::GetPriorityBoost(LPBOOL pDisablePriorityBoost)
{
	return ::GetThreadPriorityBoost(m_hObject, pDisablePriorityBoost);
}

/**********************************************************************//**
 *
 * XbhɃbZ[W̑M
 * 
 -----------------------------------------------------------------------
 * @param	uMsg	= s郁bZ[W
 * @param	wParam	= s郁bZ[W@
 * @param	lParam	= s郁bZ[WA
 * @return	
*//***********************************************************************/
BOOL CThread::PostMessageA(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return ::PostThreadMessageA(m_dwThreadId, uMsg, wParam, lParam);
}
/// CThread::PostMessageA Q
BOOL CThread::PostMessageW(UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return ::PostThreadMessageW(m_dwThreadId, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * Xbh쐬
 * 
 -----------------------------------------------------------------------
 * @param [in]	pfnEntry	= Gg֐|C^
 * @param [in]	lpArgs		= Xbhɓn
 * @return nh
*//***********************************************************************/
HANDLE CThread::_CreateThread(PROC pfnEntry, LPVOID lpArgs)
{
	return ::CreateThread( nullptr, 0, (LPTHREAD_START_ROUTINE)pfnEntry, lpArgs, CREATE_SUSPENDED , &m_dwThreadId );
}


}	// end of namespace wx
}	// end of namespace iris
