//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOSVersion.h
 * @brief		OS Version t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXOSVersion_H_
#define _IRIS_WXOSVersion_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// function
// WindowsOSo[W̕o
BOOL	GetWindowsOSVersionString(LPTSTR lpString, DWORD dwLength);

//======================================================================
// class
/// o[WNX
class COSVersionInfo : public IIrisObject
{
	OSVERSIONINFOEX	m_Osviex;	//!< o[W\
public:
	// RXgN^
	COSVersionInfo(void);
public:
	bool				GetString(LPTSTR lpString, DWORD dwLength);
	bool				IsValid(void)				{ return m_Osviex.dwOSVersionInfoSize != 0; }
	bool				IsEx(void)					{ return m_Osviex.dwOSVersionInfoSize == sizeof(OSVERSIONINFOEX); }

public:
	OSVERSIONINFOEX&	GetOSVersionInfoEx(void)	{ return m_Osviex; }
	operator OSVERSIONINFOEX&	(void)				{ return m_Osviex; }
	OSVERSIONINFOEX*	operator -> (void)			{ return &m_Osviex; }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
