//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXOSVersion.cpp
 * @brief		OS Version t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXOSVersion_CPP_

//======================================================================
// include
#include "WXOSVersion.h"
#include <stdio.h>
#include <tchar.h>
#include "iris_debug.h"

namespace iris {
namespace wx
{

//======================================================================
// decalre
static BOOL _GetWindowsOSVersionString(OSVERSIONINFOEX& osvi, LPTSTR lpString, DWORD dwLength);

//======================================================================
// function
/**********************************************************************//**
 *
 * WindowsOSo[W̕o
 *
 -----------------------------------------------------------------------
 * @param [in]	lpString	= o̓obt@
 * @param [in]	dwLength	= o̓obt@TCY
 * @return 
*//***********************************************************************/
BOOL GetWindowsOSVersionString(LPTSTR lpString, DWORD dwLength)
{
	COSVersionInfo osvi;
	if( !osvi.IsValid() ) return FALSE;
	return _GetWindowsOSVersionString(osvi, lpString, dwLength);
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
COSVersionInfo::COSVersionInfo(void)
{
	m_Osviex.dwOSVersionInfoSize = sizeof(OSVERSIONINFOEX);
	BOOL bOSVersionInfoEx = GetVersionEx(reinterpret_cast<LPOSVERSIONINFO>(&m_Osviex));
	if( !bOSVersionInfoEx )
	{
		// Windows NT 4.0 SP5 ȑO Windows 9x
		m_Osviex.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
		if( !GetVersionEx(reinterpret_cast<LPOSVERSIONINFO>(&m_Osviex)) )
		{
			m_Osviex.dwOSVersionInfoSize = 0;
		}
	}
}

/**********************************************************************//**
 *
 * WindowsOSo[W̕o
 *
 -----------------------------------------------------------------------
 * @param [in]	lpString	= o̓obt@
 * @param [in]	dwLength	= o̓obt@TCY
 * @return 
*//***********************************************************************/
bool COSVersionInfo::GetString(LPTSTR lpString, DWORD dwLength)
{
	return _GetWindowsOSVersionString(m_Osviex, lpString, dwLength) != 0;
}


//======================================================================
// static function
/**********************************************************************//**
 *
 * WindowsOSo[W̕o
 *
 -----------------------------------------------------------------------
 * @param [in]	lpString	= o̓obt@
 * @param [in]	dwLength	= o̓obt@TCY
 * @return 
*//***********************************************************************/
BOOL _GetWindowsOSVersionString(OSVERSIONINFOEX& osvi, LPTSTR lpString, DWORD dwLength)
{
	BOOL bOSVersionInfoEx = osvi.dwOSVersionInfoSize == sizeof(OSVERSIONINFOEX);
	SYSTEM_INFO si;
	typedef void (WINAPI *PFN_GETNATIVESYSTEMINFO)(LPSYSTEM_INFO);
	PFN_GETNATIVESYSTEMINFO pfnGetNativeSystemInfo = reinterpret_cast<PFN_GETNATIVESYSTEMINFO>(GetProcAddress(
		GetModuleHandle(IRIS_TEXT("kernel32.dll")), "GetNativeSystemInfo"));
	if( pfnGetNativeSystemInfo != nullptr ) (*pfnGetNativeSystemInfo)(&si);
	else									GetSystemInfo(&si);
	
	_tcscpy_s(lpString, dwLength, IRIS_TEXT(""));

	if( osvi.dwPlatformId == VER_PLATFORM_WIN32_NT && osvi.dwMajorVersion >= 3 )	// NT n
	{
		// Vista / 2008 / 7 / 2008 R2
		if( osvi.dwMajorVersion == 6 )
		{
			TCHAR MajVerStr[16] = IRIS_TEXT("");
			if( osvi.wProductType == VER_NT_WORKSTATION )	// Vista / 7
			{
				if( osvi.dwMinorVersion == 0 )		_tcscat_s(lpString, dwLength, IRIS_TEXT("Windows Vista "));
				else if( osvi.dwMinorVersion == 1 )	_tcscat_s(lpString, dwLength, IRIS_TEXT("Windows 7 "));
				else								_tcscat_s(lpString, dwLength, IRIS_TEXT("Windows NT 6.x(unknown) "));
			}
			else	// Server 2008 / R2
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Windows Server "));
				if( osvi.dwMinorVersion == 0 )		_tcscpy_s(MajVerStr, 16, IRIS_TEXT("2008"));
				else if( osvi.dwMinorVersion == 1 )	_tcscpy_s(MajVerStr, 16, IRIS_TEXT("2008 R2"));
				else								_tcscpy_s(MajVerStr, 16, IRIS_TEXT("6.x(unknown)"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" "));
			}
			// Vista ȍ~łGetProductInfogp\
			typedef BOOL (WINAPI *PFN_GETPRODUCTINFO)(DWORD, DWORD, DWORD, DWORD, PDWORD);
			PFN_GETPRODUCTINFO pfnGetProductInfo = reinterpret_cast<PFN_GETPRODUCTINFO>(GetProcAddress(
				GetModuleHandle(IRIS_TEXT("kernel32.dll")), "GetProductInfo"));
			IRIS_ASSERT( pfnGetProductInfo != nullptr );
			DWORD dwType = 0;
			(*pfnGetProductInfo)(osvi.dwMajorVersion, osvi.dwMinorVersion, 0, 0, &dwType);
			switch( dwType )
			{
			// Windows Vista / 7
			case PRODUCT_ULTIMATE:
			case PRODUCT_ULTIMATE_N:
			case PRODUCT_ULTIMATE_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Ultimate Edition"));		break;
			case PRODUCT_HOME_PREMIUM:
			case PRODUCT_HOME_PREMIUM_N:
			case PRODUCT_HOME_PREMIUM_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Home Premium Edition"));	break;
			case PRODUCT_HOME_BASIC:
			case PRODUCT_HOME_BASIC_N:
			case PRODUCT_HOME_BASIC_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Home Basic Edition"));		break;
			case PRODUCT_ENTERPRISE:
			case PRODUCT_ENTERPRISE_N:
			case PRODUCT_ENTERPRISE_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Enterprise Edition"));		break;
			case PRODUCT_BUSINESS:
			case PRODUCT_BUSINESS_N:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Business Edition"));		break;
			case PRODUCT_STARTER:
			case PRODUCT_STARTER_N:
			case PRODUCT_STARTER_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Starter Edition"));		break;
			case PRODUCT_PROFESSIONAL:
			case PRODUCT_PROFESSIONAL_N:
			case PRODUCT_PROFESSIONAL_E:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Professional Edition"));	break;

			// Winodws Server 2008 / R2
			case PRODUCT_STANDARD_SERVER:
			case PRODUCT_STANDARD_SERVER_V:
			case PRODUCT_STANDARD_SERVER_CORE:
			case PRODUCT_STANDARD_SERVER_CORE_V:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Standard Edition"));		break;
			case PRODUCT_DATACENTER_SERVER:
			case PRODUCT_DATACENTER_SERVER_V:
			case PRODUCT_DATACENTER_SERVER_CORE:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Datacenter Edition"));		break;
			case PRODUCT_ENTERPRISE_SERVER:
			case PRODUCT_ENTERPRISE_SERVER_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Enterprise Edition"));		break;
			case PRODUCT_ENTERPRISE_SERVER_IA64:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Enterprise Edition for Itanium-based Systems "));	break;

			case PRODUCT_WEB_SERVER:
			case PRODUCT_WEB_SERVER_CORE:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Web Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				break;
			case PRODUCT_CLUSTER_SERVER:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows HPC Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				break;
			case PRODUCT_HOME_SERVER:
			case PRODUCT_HOME_SERVER_PREMIUM:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Home Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				if( dwType == PRODUCT_HOME_SERVER_PREMIUM )
					_tcscat_s(lpString, dwLength, IRIS_TEXT(" Premium Edition"));
				break;
			case PRODUCT_SMALLBUSINESS_SERVER:
			case PRODUCT_SMALLBUSINESS_SERVER_PREMIUM:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Small Business Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				if( dwType == PRODUCT_SMALLBUSINESS_SERVER_PREMIUM )
					_tcscat_s(lpString, dwLength, IRIS_TEXT(" Premium Edition"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_MANAGEMENT:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Small Business Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Management Server"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_SECURITY:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Small Business Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Security Server"));
				break;
			case PRODUCT_MEDIUMBUSINESS_SERVER_MESSAGING:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Small Business Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Messaging Server"));
				break;

			case PRODUCT_SERVER_FOUNDATION:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Foundation"));						break;
			case PRODUCT_SERVER_FOR_SMALLBUSINESS:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("for Small Business Edition"));		break;
			case PRODUCT_SERVER_FOR_SMALLBUSINESS_V:
				_tcscat_s(lpString, dwLength, IRIS_TEXT("for Windows Essential Server Solutions"));		break;
			case PRODUCT_HYPERV:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Hyper-V Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				break;

			case PRODUCT_STORAGE_EXPRESS_SERVER:
			case PRODUCT_STORAGE_EXPRESS_SERVER_CORE:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Storage Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Express Edition"));
				break;
			case PRODUCT_STORAGE_STANDARD_SERVER:
			case PRODUCT_STORAGE_STANDARD_SERVER_CORE:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Storage Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Standard Edition"));
				break;
			case PRODUCT_STORAGE_WORKGROUP_SERVER:
			case PRODUCT_STORAGE_WORKGROUP_SERVER_CORE:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Storage Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Workgroup Edition"));
				break;
			case PRODUCT_STORAGE_ENTERPRISE_SERVER:
			case PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE:
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Storage Server"));
				_tcscat_s(lpString, dwLength, MajVerStr);
				_tcscpy_s(lpString, dwLength, IRIS_TEXT(" Enterprise Edition"));
				break;
			default:
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" Unknown Edition"));	break;
			}

			// without Hyper-V
			switch( dwType )
			{
			case PRODUCT_STANDARD_SERVER_V:
			case PRODUCT_STANDARD_SERVER_CORE_V:
			case PRODUCT_DATACENTER_SERVER_V:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
			case PRODUCT_ENTERPRISE_SERVER_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
			case PRODUCT_SERVER_FOR_SMALLBUSINESS_V:
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" without Hyper-V"));	break;
				break;
			}

			// core installation
			switch( dwType )
			{
			case PRODUCT_STANDARD_SERVER_CORE:
			case PRODUCT_STANDARD_SERVER_CORE_V:
			case PRODUCT_DATACENTER_SERVER_CORE:
			case PRODUCT_DATACENTER_SERVER_CORE_V:
			case PRODUCT_ENTERPRISE_SERVER_CORE:
			case PRODUCT_ENTERPRISE_SERVER_CORE_V:
			case PRODUCT_WEB_SERVER_CORE:
			case PRODUCT_STORAGE_EXPRESS_SERVER_CORE:
			case PRODUCT_STORAGE_STANDARD_SERVER_CORE:
			case PRODUCT_STORAGE_WORKGROUP_SERVER_CORE:
			case PRODUCT_STORAGE_ENTERPRISE_SERVER_CORE:
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" (core installation)"));	break;
				break;
			}

			// x86 or x64
			if( si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64 )
				_tcscat_s(lpString, dwLength, IRIS_TEXT(", 64-bit"));
			else if( si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_INTEL )
				_tcscat_s(lpString, dwLength, IRIS_TEXT(", 32-bit"));
		}	// // Vista / 2008 / 7 / 2008 R2

		// Windows Server 2003 / XP x64
		if( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 2 )
		{
			if( osvi.wProductType == VER_NT_WORKSTATION )
			{
				// Windows XP Professional x64 Edition
				_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows XP Professional"));
				if( si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64 )
					_tcscat_s(lpString, dwLength, IRIS_TEXT(" x64 Edition"));
			}
			else
			{
				// Windows Server 2003
				if( osvi.wSuiteMask & VER_SUITE_COMPUTE_SERVER )
				{
					_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Compute Cluster Server 2003"));
				}
				else if( osvi.wSuiteMask & VER_SUITE_WH_SERVER )
				{
					_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Home Server"));
				}
				else
				{
					if( osvi.wSuiteMask & (VER_SUITE_SMALLBUSINESS | VER_SUITE_SMALLBUSINESS_RESTRICTED) )
					{
						_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Small Business Server 2003"));
					}
					else if( osvi.wSuiteMask & VER_SUITE_STORAGE_SERVER )
					{
						_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Storage Server 2003"));
					}
					else
					{
						_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows Server 2003"));
					}

					if( GetSystemMetrics(SM_SERVERR2) )	_tcscat_s(lpString, dwLength, IRIS_TEXT(" R2"));
					_tcscat_s(lpString, dwLength, IRIS_TEXT(", "));
					if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT("Datacenter"));
					}
					else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE ) 
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT("Enterprise"));
					}
					else if( osvi.wSuiteMask & VER_SUITE_BLADE )
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT("Web"));
					}
					else
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT("Standard"));
					}

					// x64
					if( si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_AMD64 ) _tcscat_s(lpString, dwLength, IRIS_TEXT(" x64"));
					_tcscat_s(lpString, dwLength, IRIS_TEXT(" Edition"));
					// IA64
					if( si.wProcessorArchitecture == PROCESSOR_ARCHITECTURE_IA64 ) _tcscat_s(lpString, dwLength, IRIS_TEXT(" for Itanium-based Systems"));
				}
			}
		}

		// XP
		if( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 1 )
		{
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows XP "));
			if( GetSystemMetrics(SM_TABLETPC) )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Tablet PC Edition"));
			}
			else if( GetSystemMetrics(SM_MEDIACENTER) )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Tablet PC Edition"));
			}
			else if( GetSystemMetrics(SM_STARTER) )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Starter Edition"));
			}
			else if( osvi.wSuiteMask & VER_SUITE_PERSONAL )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Home Edition"));
			}
			else if( osvi.wSuiteMask & (VER_SUITE_EMBEDDEDNT | VER_SUITE_EMBEDDED_RESTRICTED) )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Embedded"));
			}
			else
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Professional"));
			}
		}

		// 2000
		if( osvi.dwMajorVersion == 5 && osvi.dwMinorVersion == 0 )
		{
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows 2000 "));
			if( osvi.wProductType == VER_NT_WORKSTATION )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Professional"));
			}
			else
			{
				if( osvi.wSuiteMask & VER_SUITE_DATACENTER )
				{
					_tcscat_s(lpString, dwLength, IRIS_TEXT("Datacenter "));
				}
				else if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
				{
					_tcscat_s(lpString, dwLength, IRIS_TEXT("Advanced "));
				}
				_tcscat_s(lpString, dwLength, IRIS_TEXT("Server"));

			}
		}

		// NT 3 / 4
		if( osvi.dwMajorVersion == 4 || osvi.dwMajorVersion == 3 )
		{
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows NT "));
			if( bOSVersionInfoEx )
			{
				if( osvi.wProductType == VER_NT_WORKSTATION )
				{
					if( osvi.dwMajorVersion == 4 )
						_tcscat_s(lpString, dwLength, IRIS_TEXT("4.0 "));
					else
						_tcscat_s(lpString, dwLength, IRIS_TEXT("3.51 "));
					_tcscat_s(lpString, dwLength, IRIS_TEXT("Workstation"));
				}
				else
				{
					_tcscat_s(lpString, dwLength, IRIS_TEXT("Server"));
					if( osvi.wSuiteMask & VER_SUITE_ENTERPRISE )
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT(", Enterprise Edition"));
					}
					else if( osvi.wSuiteMask & VER_SUITE_TERMINAL )
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT(", Terminal Server Edition"));
					}
					else if( osvi.wSuiteMask & (VER_SUITE_EMBEDDEDNT | VER_SUITE_EMBEDDED_RESTRICTED))
					{
						_tcscat_s(lpString, dwLength, IRIS_TEXT(", Embedded Edition"));
					}
					if( osvi.dwMajorVersion == 4 )
						_tcscat_s(lpString, dwLength, IRIS_TEXT("4.0 "));
					else
						_tcscat_s(lpString, dwLength, IRIS_TEXT("3.51 "));
				}
			}
			else
			{
				// TODO : Ή
			}
		}

		if( _tcslen(osvi.szCSDVersion) > 0 )
		{
			_tcscat_s(lpString, dwLength, IRIS_TEXT(" "));
			_tcscat_s(lpString, dwLength, osvi.szCSDVersion);
		}

		// build number
		TCHAR build_number[64];
		wsprintf(build_number, IRIS_TEXT(" (build %d)"), osvi.dwBuildNumber);
		_tcscat_s(lpString, dwLength, build_number);
		return TRUE;

	}
	else if( osvi.dwPlatformId == VER_PLATFORM_WIN32_WINDOWS )
	{
		switch( osvi.dwMinorVersion )
		{
		case 0:
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows 95"));
			if( _tcschr(osvi.szCSDVersion, IRIS_TEXT('A')) != nullptr )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" OSR1"));
			}
			else if( _tcschr(osvi.szCSDVersion, IRIS_TEXT('B')) != nullptr )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" OSR2"));
			}
			else if( _tcschr(osvi.szCSDVersion, IRIS_TEXT('C')) != nullptr )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" OSR2.5"));
			}
			else
			{
				_tcscat_s(lpString, dwLength, osvi.szCSDVersion);
			}
			break;
		case 10:
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows 98"));
			if( _tcschr(osvi.szCSDVersion, IRIS_TEXT('A')) != nullptr )
			{
				_tcscat_s(lpString, dwLength, IRIS_TEXT(" Second Edition"));
			}
			else
			{
				_tcscat_s(lpString, dwLength, osvi.szCSDVersion);
			}
			break;
		case 90:
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows ME"));
			break;
		default:
			_tcscpy_s(lpString, dwLength, IRIS_TEXT("Windows 9x(unknown)"));
			break;
		}
		return TRUE;
	}

	_tcscpy_s(lpString, dwLength, IRIS_TEXT("Unknown Windows"));
	return FALSE;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../debug/unittest/WXDebugUnitTest.h"
#include "iris.h"

//======================================================================
// test
IRIS_UNITTEST(CWXOSVersionUnitTest, WXOSVersionUnitTest)
{
	{
		TCHAR osver[256];
		// GetWindowsOSVersionString
		if( GetWindowsOSVersionString(osver, 256) )
		{
			_tprintf(osver);
			_tprintf(IRIS_TEXT("\n"));
		}
	}
}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
