//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXModule.h
 * @brief		W[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXModule_H_
#define _IRIS_WXModule_H_

//======================================================================
// include
#include "../base/WXHandle.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// W[NX
class CModule : public CHandle
{
public:
	// RXgN^
	CModule(void);
	// fXgN^
	~CModule(void);

#ifdef STRICT
	CModule(HMODULE hModule) : CHandle(reinterpret_cast<HANDLE>(hModule)) {}
				operator	HMODULE (void)		{ return static_cast<HMODULE>(GetHandle()); }
	CModule&	operator	= (HMODULE hObj)	{ Attach(static_cast<HANDLE>(hObj)); return *this; }
#endif

public:
	// ǂݍ
	BOOL	Load (LPCTSTR lpModuleName);
	BOOL	LoadA(LPCSTR  lpModuleName);
	BOOL	LoadW(LPCWSTR lpModuleName);
	// 
	BOOL	Release(void);

	// J
	BOOL	Open (LPCTSTR lpModuleName);
	BOOL	OpenA(LPCSTR  lpModuleName);
	BOOL	OpenW(LPCWSTR lpModuleName);
	// 
	BOOL	Close(void);
public:
	// AhX擾
	PROC	GetProcAddress(LPCSTR lpProcName);
};


}	// end of namespace wx
}	// end of namespace iris

#endif
