//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMWaveOut.h
 * @brief		WaveOutt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXMMWaveOut_H_
#define _IRIS_WXMMWaveOut_H_

//======================================================================
// include
#include "iris_object.h"
#include <mmsystem.h>

namespace iris {
namespace wx
{

//======================================================================
// class
//! waveOutNX
class CMMWaveOut : public INonCopyObject
{
public:
	typedef enum
	{
		MAX_VOLUME	= 0xFFFF,
		MIN_VOLUME	= 0x0000,

	} WAVEOUT_ENUM;
protected:
	//! nh
	HWAVEOUT		m_hWaveOut;
	//! g`f[^wb_
	WAVEHDR			m_WaveHeader;

public:
	// RXgN^
	CMMWaveOut(void);
	// fXgN^
	~CMMWaveOut(void);

public:
	// waveOut
	// Open -> PrepareHeader -> Write -> Reset -> UnprepareHeader -> Colse
	// J
	MMRESULT	Open(LPWAVEFORMATEX pFormat, UINT uDeviceID=WAVE_MAPPER, DWORD_PTR dwCallbak=0, DWORD_PTR dwInstance=0, DWORD dwOpen=CALLBACK_NULL);
	// PrepareHeader
	MMRESULT	PrepareHeader(LPSTR lpData, DWORD dwLength, DWORD dwFlags, DWORD dwLoops, DWORD_PTR dwUser=0);
	// ݁iMj
	MMRESULT	Write(void);
	// ~
	MMRESULT	Reset(void);
	// UnprepareHeader
	MMRESULT	UnprepareHeader(void);
	// 
	MMRESULT	Close(void);

	// ꎞ~
	MMRESULT	Pause(void);
	// ĊJ
	MMRESULT	Restart(void);
	// [v̒f
	MMRESULT	BreakLoop(void);
	// ʎ擾
	DWORD		GetVolume(void);
	// ʐݒ
	MMRESULT	SetVolume(DWORD dwVolume);
	// ʐݒ
	MMRESULT	SetVolume(DWORD dwVolumeL, DWORD dwVolumeR);
	// sb`擾
	DWORD		GetPitch(void);
	// sb`ݒ
	MMRESULT	SetPitch(DWORD dwPitch);
	// Đ[g擾
	DWORD		GetPlaybackRate(void);
	// Đ[gݒ
	MMRESULT	SetPlaybackRate(DWORD dwRate);

	// ID擾
	UINT		GetID(void);

	// Message
	MMRESULT	Message(UINT uMsg, DWORD_PTR dw1, DWORD_PTR dw2);

public:

	// foCX\̎擾
	MMRESULT	GetDevCapsA(LPWAVEOUTCAPSA lpwoc);
	MMRESULT	GetDevCapsW(LPWAVEOUTCAPSW lpwoc);

public:
	// wrap
	MMRESULT	GetPosition(PMMTIME pmmt); 
public:

	// foCX̎擾
	static UINT	GetNumDevs(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif