//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMTimer.h
 * @brief		^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXMMTimer_H_
#define _IRIS_WXMMTimer_H_

//======================================================================
// include
#include "fnd/system/FndTimer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! ԂǗNX
class CMMTimer : public fnd::ITimer
{
protected:
	float	m_fTosec;		//!< ~bbPʂɕϊϐ

public:
	// RXgN^
	CMMTimer(void);
	// fXgN^
	~CMMTimer(void);

protected:
	// ݂̃^C}[JEg擾
	virtual u64		GetNowTime(void);

public:
	// oߎԂ̎擾
	// out : oߎ
	u64		GetElapsedMilliSecond(void);
	// AvP[VԂ̎擾
	// out : NĂ̎
	u64		GetStockMilliSecond(void);

	// oߎԂ̎擾iQƁj
	u64		GetElapsedMilliSecondRef(void);

public:
	// Sync(XVԂASPFɂȂ悤Sync)
	virtual	bool	Sync(bool sleep);
	// Sync̍XVԂ̎擾
	virtual	float	GetSyncElapsedSecond(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif