//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMMPfmTimer.h
 * @brief		^C}[NXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXMMPfmTimer_H_
#define _IRIS_WXMMPfmTimer_H_

//======================================================================
// include
#include "fnd/system/FndTimer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @breif	ԂǗNX
 * @note	QueryPerformanceCounter𗘗p^C}[NX
 *			QueryPerformanceCountergȂꍇ́AtimeGetTimeg
*/
class CMMPfmTimer : public fnd::ITimer
{
protected:
	bool			m_bPfm;			//!< v̎
	u64				m_ToMillisec;	//!< 
	LARGE_INTEGER	m_Freq;			//!< g

public:
	// RXgN^
	CMMPfmTimer(void);
	// fXgN^
	~CMMPfmTimer(void);

protected:
	// ݂̃^C}[JEg擾
	virtual u64		GetNowTime(void);

public:
	// oߎԂ̎擾
	// out : oߎ
	u64		GetElapsedMilliSecond(void);
	// AvP[VԂ̎擾
	// out : NĂ̎
	u64		GetStockMilliSecond(void);
	
public:
	// GetSecond
	u64		GetElapsedMilliSecondRef(void);
	// Sync(XVԂASPFɂȂ悤Sync)
	bool	Sync(bool sleep);
	// Sync̍XVԂ̎擾
	float	GetSyncElapsedSecond(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif