//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXLocalMemory.h
 * @brief		[JnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXLocalMemory_H_
#define _IRIS_WXLocalMemory_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx 
{

//======================================================================
// decalre
class CLocalMemory;

//======================================================================
// typedef
typedef CLocalMemory	CLMem;	//!< [JnhNX

//======================================================================
// class
//! [JnhNX
class CLocalMemory : public INonCopyObject
{
	HLOCAL m_hMem;	//!< nh
public:
	// RXgN^
	CLocalMemory(void);
	// fXgN^
	virtual ~CLocalMemory(void);

	//
	HGLOBAL			GetHandle(void)				{ return m_hMem; }
	operator		HGLOBAL	(void)				{ return GetHandle(); }
	CLocalMemory&	operator = (HGLOBAL hMem)	{ Attach(hMem); return *this; }
public:
	// Attach
	HGLOBAL	Attach(HGLOBAL hMem);
	// Detach
	HGLOBAL	Detach(void);

public:
	// Alloc
	bool	Alloc(UINT uFlags, SIZE_T dwBytes);
	// ReAlloc
	bool	ReAlloc(UINT uFlags, SIZE_T dwBytes);
	// 폜
	void	Discard(void);
	// 
	void	Free(void);
	// Lock
	LPVOID	Lock(void);
	// Unlock
	BOOL	Unlock(void);

public:
	// TCY擾
	SIZE_T	GetSize(void);
	// tO擾
	UINT	GetFlags(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
