//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHeap.cpp
 * @brief		q[vnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXHeap_CPP_

//======================================================================
// include
#include "WXHeap.h"

namespace iris {
namespace wx 
{

//======================================================================
// class
// CHeap
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CHeap::CHeap(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hHeap		= ֘Atnh
*//***********************************************************************/
CHeap::CHeap(HANDLE hHeap)
: CHandle(hHeap)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CHeap::~CHeap(void)
{
	Destroy();
}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	dwOptions		= IvV(0 or HEAP_GENERATE_EXCEPTIONS or HEAP_NO_SERIALIZE)
 * @param [in]	InitialSize		= ŏ̒iKŃq[vɊ蓖Ă镨i[
 * @param [in]	MaximumSize		= q[v̍őTCY(0 ɂƊg\)
 * @return	
*//***********************************************************************/
BOOL CHeap::Create(DWORD dwOptions, SIZE_T InitialSize, SIZE_T MaximumSize)
{
	m_hObject = HeapCreate(dwOptions, InitialSize, MaximumSize);
	if( m_hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * 폜
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHeap::Destroy(void)
{
	if( m_hObject == nullptr ) return TRUE;
	return HeapDestroy(m_hObject);
}

/**********************************************************************//**
 *
 * m
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= 蓖ĕ@tO(HEAP_***)
 * @param [in]	Size		= 蓖ĂTCY
 * @return	蓖ĂAhX
*//***********************************************************************/
LPVOID CHeap::Alloc(DWORD dwFlags, SIZE_T Size)
{
	if( m_hObject == nullptr ) return nullptr;
	return HeapAlloc(m_hObject, dwFlags, Size);
}

/**********************************************************************//**
 *
 * ̍Ċ蓖
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= 蓖ĕ@tO(HEAP_***)
 * @param [in]	lpMem		= Ċ蓖Ă
 * @param [in]	Size		= 蓖ĂTCY
 * @return	蓖ĂAhX
*//***********************************************************************/
LPVOID CHeap::ReAlloc(DWORD dwFlags, LPVOID lpMem, SIZE_T Size)
{
	if( m_hObject == nullptr ) return (LPVOID)(LONG_PTR)STATUS_ACCESS_VIOLATION;
	return HeapReAlloc(m_hObject, dwFlags, lpMem, Size);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= tO(0 or HEAP_NO_SERIALIZE)
 * @param [in]	lpMem		= 郁AhX
 * @return	
*//***********************************************************************/
BOOL CHeap::Free(DWORD dwFlags, LPVOID lpMem)
{
	if( m_hObject == nullptr ) return FALSE;
	return HeapFree(m_hObject, dwFlags, lpMem);
}

/**********************************************************************//**
 *
 * TCY擾
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= tO(0 or HEAP_NO_SERIALIZE)
 * @param [in]	lpMem		= AhX
 * @return	
*//***********************************************************************/
SIZE_T CHeap::GetSize(DWORD dwFlags, LPVOID lpMem)
{
	if( m_hObject == nullptr ) return 0;
	return HeapSize(m_hObject, dwFlags, lpMem);
}

/**********************************************************************//**
 *
 * bN
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHeap::Lock(void)
{
	if( m_hObject == nullptr ) return FALSE;
	return HeapLock(m_hObject);
}

/**********************************************************************//**
 *
 * bN
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CHeap::Unlock(void)
{
	if( m_hObject == nullptr ) return FALSE;
	return HeapUnlock(m_hObject);
}

/**********************************************************************//**
 *
 * Compact
 *
 * @note	אڂ󂫃ubNA
 *			傫ȋ󂫃ubNR~bgĂȂԂɕύX邱ƂɂA
 *			q[vRpNgɂ܂B
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= tO(0 or HEAP_NO_SERIALIZE)
 * @return	mۉ\ȕi[TCY
*//***********************************************************************/
SIZE_T CHeap::Compact(DWORD dwFlags)
{
	if( m_hObject == nullptr ) return 0;
	return HeapCompact(m_hObject, dwFlags);
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwFlags		= tO(0 or HEAP_NO_SERIALIZE)
 * @param [in]	lpMem		= ؂ubÑAhX
 * @return	mۉ\ȕi[TCY
*//***********************************************************************/
BOOL CHeap::Validate(DWORD dwFlags, LPVOID lpMem)
{
	if( m_hObject == nullptr ) return FALSE;
	return HeapValidate(m_hObject, dwFlags, lpMem);
}

//======================================================================
// class
// CProcessHeap
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CProcessHeap::CProcessHeap(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CProcessHeap::~CProcessHeap(void)
{
	Detach();	// DestroyȂ悤ɂ
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CProcessHeap::GetProcessHeap(void)
{
	m_hObject = ::GetProcessHeap();
	if( m_hObject == INVALID_HANDLE_VALUE ) return FALSE;
	return TRUE;
}

}	// end of namespace wx
}	// end of namespace iris
