//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMailSlot.cpp
 * @brief		[XbgNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXMailSlot_CPP_

//======================================================================
// include
#include "WXMailSlot.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//======================================================================
// CMailSlot

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMailSlot::CMailSlot(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hSlot	= ֘Atnh
*//***********************************************************************/
CMailSlot::CMailSlot(HANDLE hSlot)
: CHFile(hSlot)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
//CMailSlot::~CMailSlot(void)
//{
//}

/**********************************************************************//**
 *
 * 쐬
 *
 ----------------------------------------------------------------------
 * @param [in]	lpName			= 
 * @param [in]	dwMaxMsgSize	= ő僁bZ[WTCY
 * @param [in]	dwReadTimeout	= ^CAEg
 * @param [in]	lpsa			= 
 * @return	
*//***********************************************************************/
BOOL CMailSlot::Create (LPCTSTR lpName, DWORD dwMaxMsgSize, DWORD dwReadTimeout, PSECURITY_ATTRIBUTES lpsa)
{
#ifdef UNICODE
	return CreateW(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
#else
	return CreateA(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
#endif
}
/// CMailSlot::Create Q
BOOL CMailSlot::CreateA(LPCSTR  lpName, DWORD dwMaxMsgSize, DWORD dwReadTimeout, PSECURITY_ATTRIBUTES lpsa)
{
	HANDLE hObject = CreateMailslotA(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(hObject) )
	{
		CloseHandle(hObject);
		return FALSE;
	}
	return TRUE;
}
/// CMailSlot::Create Q
BOOL CMailSlot::CreateW(LPCWSTR lpName, DWORD dwMaxMsgSize, DWORD dwReadTimeout, PSECURITY_ATTRIBUTES lpsa)
{
	HANDLE hObject = CreateMailslotW(lpName, dwMaxMsgSize, dwReadTimeout, lpsa);
	if( hObject == INVALID_HANDLE_VALUE ) return FALSE;
	if( !Attach(hObject) )
	{
		CloseHandle(hObject);
		return FALSE;
	}
	return TRUE;
}

/**********************************************************************//**
 *
 * 擾
 *
 ----------------------------------------------------------------------
 * @param [out]	lpMaxMsgSize	= ő僁bZ[WTCY
 * @param [out]	lpNextSize		= ̃bZ[W̃TCY
 * @param [out]	lpMessageCount	= bZ[W̑
 * @param [out]	lpReadTimeout	= ^CAEg
 * @return	
*//***********************************************************************/
BOOL CMailSlot::GetInfo(LPDWORD lpMaxMsgSize, LPDWORD lpNextSize, LPDWORD lpMessageCount, LPDWORD lpReadTimeout)
{
	return GetMailslotInfo(m_hObject, lpMaxMsgSize, lpNextSize, lpMessageCount, lpReadTimeout);
}

/**********************************************************************//**
 *
 * ^CAEgԂ̐ݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	dwReadTimeout	= ^CAEg
 * @return	
*//***********************************************************************/
BOOL CMailSlot::SetInfo(DWORD dwReadTimeout)
{
	return SetMailslotInfo(m_hObject, dwReadTimeout);
}

}	// end of namespace wx
}	// end of namespace iris
