//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXIOThread.h
 * @brief		IO Thread template t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXIOThread_H_
#define _IRIS_WXIOThread_H_

//======================================================================
// include
#include "../os/WXThread.h"
#include "WXOverlapped.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/// IOXbhNX
template<class _TC>
class CIOThread : public CThreadEntry<CThread>
{
	typedef typename _TC	io_type;
	typedef typename _TC&	io_ref;
	COverlapped		m_Overlapped;
private:
	io_type	m_IO;
public:
	// fXgN^
	virtual ~CIOThread(void)
	{
		m_Overlapped.Close();
		CThread::Stop();
		m_IO.Close();
	}
public:
	io_ref	IO(void)	{ return m_IO; }
public:
	// s֐
	virtual void Run(void)
	{
		m_Overlapped.Create(nullptr, TRUE, FALSE, nullptr);
		m_Overlapped.AttachEvent();

		while(1)
		{
			char buf[1024];
			DWORD read=0;
			if( !m_IO.Read((void*)buf, 10, &read, m_Overlapped) )
			{
				if( GetLastError() == ERROR_IO_PENDING )
				{
					m_IO.GetOverlappedResult(m_Overlapped, &read, TRUE);
				}
			}
			if( read )
			{
				OnRead(buf, sizeof(buf), read);
			}
			m_Overlapped.ResetSignal();
		}

		m_Overlapped.Close();
	}

protected:
	/// ǂݍݎ̏
	virtual void	OnRead(char* lpBuffer, DWORD dwSize, DWORD dwRead)
	{
		IRIS_UNUSED_VARIABLE(lpBuffer);
		IRIS_UNUSED_VARIABLE(dwSize);
		IRIS_UNUSED_VARIABLE(dwRead);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
