//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXClipboard.h
 * @brief		Nbv{[hNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXClipboard_H_
#define _IRIS_WXClipboard_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! Nbv{[hNX
class CClipboard : public INonCopyObject
{
private:
	HWND	m_hOwner;		//!< I[i[EBhE
	HWND	m_hViewer;		//!< 
	HWND	m_hPreViewer;	//!< ȑÕnh
	bool	m_isOpen;
public:
	// RXgN^
	CClipboard(void);
	explicit CClipboard(HWND hWndNewOwner);
	// fXgN^
	~CClipboard(void);

public:

	// J
	BOOL	Open(HWND hWndNewOwner);
	// 
	BOOL	Close(void);
	// JĂ邩
	bool	IsOpen(void);

public:
	// f[^ݒ
	HANDLE	SetData(UINT uFormat, HANDLE hMem);
	// f[s^擾
	HANDLE	GetData(UINT uFormat);
	// f[^ɂ
	BOOL	Empty(void);
	// f[^̗L
	BOOL	IsFormatAvailable(UINT uFormat);

public:
	// I[i[EBhEnh擾
	HWND	GetOwner(void);
	// OpenĂEBhEnh擾
	HWND	GetOpenWindow(void);
	// Nbv{[h̃V[PXԍ擾
	DWORD	GetSequenceNumber(void);
	// tH[}bg̎擾
	int		CountFormats(void);
	// tH[}bg̗
	UINT	EnumFormats(UINT uFormat);
	// Xg̒ŏɗpłNbv{[htH[}bg̎擾
	int		GetPriorityFormat(UINT* paPriorityList, int nFormats);
	// Nbv{[h̐VtH[}bg Windows VXeɓo^
	UINT	RegisterFormat (LPCTSTR lpszFormat);
	UINT	RegisterFormatA(LPCSTR  lpszFormat);
	UINT	RegisterFormatW(LPCWSTR lpszFormat);
	// o^ς݃tH[}bg擾
	int		GetFormatName (UINT uFormat, LPTSTR lpszFormatName, int cchMaxCount);
	int		GetFormatNameA(UINT uFormat, LPSTR  lpszFormatName, int cchMaxCount);
	int		GetFormatNameW(UINT uFormat, LPWSTR lpszFormatName, int cchMaxCount);

public:
	// Nbv{[hr[Ã`FCɒǉ
	HWND	SetViewer(HWND hViewer);
	// Nbv{[hr[Ã`FCɂŏ̃EBhE擾
	HWND	GetViewer(void);
	// 
	BOOL	CloseViewer(void);
	// Nbv{[hr[Ã`FCAw肳ꂽEBhE폜
	BOOL	ChangeChain(HWND hRemove, HWND hNewNext);
};

}	// end of namespace wx
}	// end of namespace iris

#endif