//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXUrlCach.cpp
 * @brief		C^[lbgLbVnhNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXUrlCach_CPP_

//======================================================================
// include
#include "WXUrlCach.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CUrlCach::CUrlCach(void)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hCach		= ֘Atnh
*//***********************************************************************/
CUrlCach::CUrlCach(HANDLE hCach)
: CHandle(hCach)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CUrlCach::~CUrlCach(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CUrlCach::Close(void)
{
	return FindCloseUrlCache(m_hObject);
}

/**********************************************************************//**
 *
 * LbV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszUrlSearchPattern	= 
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
BOOL CUrlCach::FindFirst (LPCTSTR lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize)
{
#ifdef UNICODE
	return FindFirstW(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
#else
	return FindFirstA(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
#endif
}
/// CUrlCach::FindFirst Q
BOOL CUrlCach::FindFirstA(LPCSTR  lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	m_hObject = ::FindFirstUrlCacheEntryA(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
	if( m_hObject == nullptr ) return FALSE;
	return TRUE;
}
/// CUrlCach::FindFirst Q
BOOL CUrlCach::FindFirstW(LPCWSTR lpszUrlSearchPattern, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	m_hObject = ::FindFirstUrlCacheEntryW(lpszUrlSearchPattern, lpCacheEntry, lpdwBufferSize);
	if( m_hObject == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [io]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
BOOL CUrlCach::FindNext (LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize)
{
#ifdef UNICODE
	return FindNextW(lpCacheEntry, lpdwBufferSize);
#else
	return FindNextA(lpCacheEntry, lpdwBufferSize);
#endif
}
/// CUrlCach::FindNext Q
BOOL CUrlCach::FindNextA(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryA(m_hObject, lpCacheEntry, lpdwBufferSize);
}
/// CUrlCach::FindNext Q
BOOL CUrlCach::FindNextW(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryW(m_hObject, lpCacheEntry, lpdwBufferSize);
}

/**********************************************************************//**
 *
 * LbV
 *
 ----------------------------------------------------------------------
 * @param [in]	lpszUrlSearchPattern	= 
 * @param [in]	dwFlags					= 
 * @param [in]	dwFilter				= 
 * @param [in]	GroupId					= 
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
BOOL CUrlCach::FindFirstEx (LPCTSTR lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
							, LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize)
{
#ifdef UNICODE
	return FindFirstExW(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize);
#else
	return FindFirstExA(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize);
#endif
}
/// CUrlCach::FindFirstEx Q
BOOL CUrlCach::FindFirstExA(LPCSTR  lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
							, LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	m_hObject = ::FindFirstUrlCacheEntryExA(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize
					, nullptr, nullptr, nullptr);
	if( m_hObject == nullptr ) return FALSE;
	return TRUE;
}
/// CUrlCach::FindFirstEx Q
BOOL CUrlCach::FindFirstExW(LPCWSTR lpszUrlSearchPattern, DWORD dwFlags, DWORD dwFilter, GROUPID GroupId
							, LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	m_hObject = ::FindFirstUrlCacheEntryExW(lpszUrlSearchPattern, dwFlags, dwFilter, GroupId, lpCacheEntry, lpdwBufferSize
					, nullptr, nullptr, nullptr);
	if( m_hObject == nullptr ) return FALSE;
	return TRUE;
}

/**********************************************************************//**
 *
 * t@C
 *
 ----------------------------------------------------------------------
 * @param [in]	lpCacheEntry			= 
 * @param [in]	lpdwBufferSize			= 
 * @return	
*//***********************************************************************/
BOOL CUrlCach::FindNextEx (LPINTERNET_CACHE_ENTRY_INFO  lpCacheEntry, LPDWORD lpdwBufferSize)
{
#ifdef UNICODE
	return FindNextExW(lpCacheEntry, lpdwBufferSize);
#else
	return FindNextExA(lpCacheEntry, lpdwBufferSize);
#endif
}
/// CUrlCach::FindNextEx Q
BOOL CUrlCach::FindNextExA(LPINTERNET_CACHE_ENTRY_INFOA lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryExA(m_hObject, lpCacheEntry, lpdwBufferSize
				, nullptr, nullptr, nullptr);
}
/// CUrlCach::FindNextEx Q
BOOL CUrlCach::FindNextExW(LPINTERNET_CACHE_ENTRY_INFOW lpCacheEntry, LPDWORD lpdwBufferSize)
{
	return ::FindNextUrlCacheEntryExW(m_hObject, lpCacheEntry, lpdwBufferSize
				, nullptr, nullptr, nullptr);
}

}	// end of namespace wx
}	// end of namespace iris
