//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInternetFile.h
 * @brief		C^[lbgt@CNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXInternetFile_H_
#define _IRIS_WXInternetFile_H_

//======================================================================
// include
#include "WXInetBase.h"

namespace iris {
namespace wx
{

//======================================================================
// class
/**
 * @brief	C^[lbgt@CNX
 * @note	LHINTERNET擾֐(InternetOpenUrl, FtpOpenFile, GropherOpenFile, HttpOpenRequest)
*/
class CInternetFile : public CInetBase
{
public:
	// RXgN^
	CInternetFile(void);
	CInternetFile(HINTERNET hFile);
	// fXgN^
	~CInternetFile(void);

public:

	// t@Cobt@TCY̎擾
	BOOL		QueryDataAvailable(LPDWORD lpdwAvailable, DWORD dwFlags, DWORD_PTR dwContext=0); 
	// Ǎ
	BOOL		ReadFile(LPVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwReadSize);
	BOOL		ReadFileEx (LPINTERNET_BUFFERS  lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		ReadFileExA(LPINTERNET_BUFFERSA lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	BOOL		ReadFileExW(LPINTERNET_BUFFERSW lpBuffers, DWORD dwFlags, DWORD_PTR dwContext=0);
	// 
	DWORD		SetFilePointer(LONG lDistanceToMove, LPLONG lpDistanceToMoveHigh, DWORD dwMoveMethod, DWORD_PTR dwContext=0); 
	// 
	BOOL		WriteFile(LPCVOID lpBuffer, DWORD dwBufferSize, LPDWORD lpdwWrittenSize);

	// 
	BOOL		LockRequestFile(HANDLE* lphLockRequestInfo);
	BOOL		UnlockRequestFile(HANDLE hLockRequestInfo);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
