//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXInetBase.cpp
 * @brief		HINTERNETx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXInetBase_CPP_

//======================================================================
// include
#include "WXInetBase.h"

//======================================================================
#pragma comment ( lib, "wininet.lib" )

namespace iris {
namespace wx
{

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CInetBase::CInetBase(void)
: m_hInternet(nullptr)
{
}

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	hIneternet		= ֘Atnh
*//***********************************************************************/
CInetBase::CInetBase(HINTERNET hInternet)
: m_hInternet(nullptr)
{
	Attach(hInternet);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CInetBase::~CInetBase(void)
{
	Close();
}

/**********************************************************************//**
 *
 * nh֘At
 *
 ----------------------------------------------------------------------
 * @param [in]	hIneternet		= Vnh
 * @return	
*//***********************************************************************/
BOOL CInetBase::Attach(HINTERNET hInternet)
{
	if( hInternet == nullptr || m_hInternet != nullptr ) return FALSE;
	m_hInternet = hInternet;
	return TRUE;
}

/**********************************************************************//**
 *
 * nh̊֘At
 *
 * @note	nhȂ̂Œ
 *
 ----------------------------------------------------------------------
 * @return	ȑÕnh
*//***********************************************************************/
HINTERNET CInetBase::Detach(void)
{
	HINTERNET hPre = m_hInternet;
	m_hInternet = nullptr;
	return hPre;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
BOOL CInetBase::Close(void)
{
	if( m_hInternet == nullptr ) return TRUE;
	return InternetCloseHandle(Detach());
}

}	// end of namespace wx
}	// end of namespace iris
