//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXGopher.h
 * @brief		GopherNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXGopher_H_
#define _IRIS_WXGopher_H_

//======================================================================
// include
#include "WXInetBase.h"
#include "fnd/utility/FndBuffer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! GopherLocatorNX
class CGopherLocator : public fnd::CBuffer
{
public:
	// RXgN^
	CGopherLocator(void);
	// fXgN^
	~CGopherLocator(void);

	operator LPCSTR  (void)		{ return (LPCSTR) GetAddr(); } 
	operator LPCWSTR (void)		{ return (LPCWSTR)GetAddr(); } 
public:
	// 쐬
	BOOL		Create (LPCTSTR lpszHost, INTERNET_PORT nServerPort, LPCTSTR lpszDisplayString, LPCTSTR lpszSelectorString, DWORD dwGopherType);
	BOOL		CreateA(LPCSTR  lpszHost, INTERNET_PORT nServerPort, LPCSTR  lpszDisplayString, LPCSTR  lpszSelectorString, DWORD dwGopherType);
	BOOL		CreateW(LPCWSTR lpszHost, INTERNET_PORT nServerPort, LPCWSTR lpszDisplayString, LPCWSTR lpszSelectorString, DWORD dwGopherType);
};

//! GopherNX
class CGopher : public CInetBase
{
public:
	// RXgN^
	CGopher(void);
	CGopher(HINTERNET hConnect);
	// fXgN^
	~CGopher(void);
public:

	// t@C
	HINTERNET	FindFirstFileA(LPCSTR  lpszLocator, LPCSTR  lpszSearchFile, LPGOPHER_FIND_DATAA lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	FindFirstFileW(LPCWSTR lpszLocator, LPCWSTR lpszSearchFile, LPGOPHER_FIND_DATAW lpFindFileData, DWORD dwFlags, DWORD_PTR dwContext=0);

	// t@CJ
	HINTERNET	OpenFile (LPCTSTR lpszLocator, LPCTSTR lpszView, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenFileA(LPCSTR  lpszLocator, LPCSTR  lpszView, DWORD dwFlags, DWORD_PTR dwContext=0);
	HINTERNET	OpenFileW(LPCWSTR lpszLocator, LPCWSTR lpszView, DWORD dwFlags, DWORD_PTR dwContext=0);

	//
	BOOL		GetAttribute (LPCTSTR lpszLocator, LPCTSTR lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwCharactersReturned
					, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext=0);
	BOOL		GetAttributeA(LPCSTR  lpszLocator, LPCSTR  lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwCharactersReturned
					, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext=0);
	BOOL		GetAttributeW(LPCWSTR lpszLocator, LPCWSTR lpszAttributeName, LPBYTE lpBuffer, DWORD dwBufferLength, LPDWORD lpdwCharactersReturned
					, GOPHER_ATTRIBUTE_ENUMERATOR lpfnEnumerator, DWORD_PTR dwContext=0);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
