//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXSplashWindow.h
 * @brief		AvP[Vʒm_CAO
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXSplashWindow_H_
#define _IRIS_WXSplashWindow_H_

//======================================================================
// include
#include "../../app/WXDlgBase.h"
#include "../../os/WXThread.h"
#include <map>

namespace iris {
namespace wx 
{

//======================================================================
// decalre
template<class _TC, typename Functor>
class CSplashWindow;
class ISplashWindow;

//======================================================================
// typedef
//! ISplashWindow|C^
typedef ISplashWindow*	LPSplashWindow;

//======================================================================
// class

//======================================================================
//! AvP[VʒmNXC^[tFCX
class ISplashWindow : public CDlgBase, public CThreadEntry<CThread>
{
public:
	/// Rg[̗LE
	typedef enum
	{
		INITWND_ICON		= 0x00000001,	//!< ACR
		INITWND_PROGRESS	= 0x00000002,	//!< vOXo[
		INITWND_BITMAP		= 0x00000004,	//!< rbg}bv
		INITWND_TEXT1		= 0x00000010,	//!< eLXg1
		INITWND_TEXT2		= 0x00000020,	//!< eLXg2
		INITWND_APPNAME		= 0x00000100,	//!< AvP[V
		INITWND_VERSION		= 0x00000200,	//!< o[W
		INITWND_COPYRIGHT	= 0x00000400,	//!< Copyright
		INITWND_COMPANYNAME	= 0x00000800,	//!< Ж
		INITWND_ALL			= 0xffffffff,

		INITWND_TEXTS		= 0x00000030,	//!< eLXg1,2

		INITWND_VI			= 0x00000f00,	//!< o[W\[XQ
	} INITWND_FLAGS;
private:
	typedef std::map<UINT,CWindow*>		CtrlMap;
	typedef std::pair<UINT,CWindow*>	CtrlPair;

protected:
	// EBhEXg
	CtrlMap	m_Controls;
	// eEBhE
	HWND	m_hParent;

protected:
	// RXgN^
	ISplashWindow(void);
	// fXgN^
	virtual ~ISplashWindow(void);

protected:
	// EBhEvV[W
	virtual LRESULT	WndProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
	// Rg[擾
	CWindow*		GetControl(UINT uFlag);

public:
	// 
	bool	Init(HINSTANCE hInstance, HWND hParent, int width, int height
		, s32 uFlags, UINT uIcon, UINT uBitmap
		, HGDIOBJ hFont=nullptr);
	// s
	INT_PTR	Exec(void);

public:
	// vOXo[ʒu̐ݒ
	void	SetProgressRatio(float ratio);
	// vOXo[ʒủZ
	void	AddProgressRatio(float ratio);
	// eLXgݒ
	BOOL	SetText(UINT uFlag, LPCTSTR lpszText);
	// tHgݒ
	void	SetFont(UINT uFlag, HGDIOBJ hFont, BOOL Redraw);
	// Sleep
	void	Sleep(DWORD dwMilliseconds);
};

//======================================================================
//! AvP[VʒmNX
template<class _TC, typename Functor>
class CSplashWindow : public ISplashWindow
{
public:
	typedef _TC* ptr;
private:
	ptr	m_pFunctor;
public:
	// RXgN^
	CSplashWindow(ptr p) : m_pFunctor(p) {}
	// fXgN^
	virtual ~CSplashWindow(void)			{}
protected:
	// Xbh̎s
	virtual	void	Run(void)
	{
		DWORD dwExitCode = (DWORD)Functor()(m_pFunctor, this);
		EndDialog(dwExitCode);
		ExitThread(dwExitCode); 
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
