//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDesktopProfile.cpp
 * @brief		Desktop.iniNX
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXDesktopProfile_CPP_

//======================================================================
// include
#include "WXDesktopProfile.h"
#include <string>
#include <tchar.h>

namespace iris {
namespace wx
{

//======================================================================
// const static
const static  CHAR s_app_nameA[]		= "{BE098140-A513-11D0-A3A4-00C04FD706EC}";
const static WCHAR s_app_nameW[]		= L"{BE098140-A513-11D0-A3A4-00C04FD706EC}";
const static  CHAR s_sec_attributesA[]	= "Attributes";
const static WCHAR s_sec_attributesW[]	= L"Attributes";
const static  CHAR s_sec_imageA[]		= "IconArea_Image";
const static WCHAR s_sec_imageW[]		= L"IconArea_Image";
const static  CHAR s_sec_colorA[]		= "IconArea_Text";
const static WCHAR s_sec_colorW[]		= L"IconArea_Text";
const static  CHAR s_sec_bkcolorA[]		= "IconArea_TextBackground";
const static WCHAR s_sec_bkcolorW[]		= L"IconArea_TextBackground";

//======================================================================
// define
#ifdef UNICODE
#define	s_app_name			s_app_nameW
#define	s_sec_attributes	s_sec_attributesW
#define	s_sec_image			s_sec_imageW
#define	s_sec_color			s_sec_colorW
#define	s_sec_bkcolor		s_sec_bkcolorW
#else
#define	s_app_name			s_app_nameA
#define	s_sec_attributes	s_sec_attributesA
#define	s_sec_image			s_sec_imageA
#define	s_sec_color			s_sec_colorA
#define	s_sec_bkcolor		s_sec_bkcolorA
#endif


//======================================================================
// function

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL ReadDesktopProfile (LPCTSTR lpszDirectory, LPTSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
#ifdef UNICODE
	return ReadDesktopProfileW(lpszDirectory, lpszImagePath, dwImagePathSize, lpdwTextColor, lpdwTextBkColor);
#else
	return ReadDesktopProfileA(lpszDirectory, lpszImagePath, dwImagePathSize, lpdwTextColor, lpdwTextBkColor);
#endif
}
/// ReadDesktopProfile Q
BOOL ReadDesktopProfileA(LPCSTR  lpszDirectory, LPSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	if( GetFileAttributesA(lpszDirectory) == (DWORD)-1 ) return FALSE;
	if( lpszImagePath != nullptr )
		GetPrivateProfileStringA(s_app_nameA, s_sec_imageA, "", lpszImagePath, dwImagePathSize, path.c_str());
	if( lpdwTextColor != nullptr )
		*lpdwTextColor	= GetPrivateProfileHexA(s_app_nameA, s_sec_colorA	, *lpdwTextColor	, path.c_str());
	if( lpdwTextBkColor != nullptr )
		*lpdwTextBkColor= GetPrivateProfileHexA(s_app_nameA, s_sec_bkcolorA	, *lpdwTextBkColor	, path.c_str());
	return TRUE;
}
/// ReadDesktopProfile Q
BOOL ReadDesktopProfileW(LPCWSTR lpszDirectory, LPWSTR lpszImagePath, DWORD dwImagePathSize
						 , LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	if( GetFileAttributesW(lpszDirectory) == (DWORD)-1 ) return FALSE;
	if( lpszImagePath != nullptr )
		GetPrivateProfileStringW(s_app_nameW, s_sec_imageW, L"", lpszImagePath, dwImagePathSize, path.c_str());
	if( lpdwTextColor != nullptr )
		*lpdwTextColor	= GetPrivateProfileHexW(s_app_nameW, s_sec_colorW	, *lpdwTextColor	, path.c_str());
	if( lpdwTextBkColor != nullptr )
		*lpdwTextBkColor= GetPrivateProfileHexW(s_app_nameW, s_sec_bkcolorW	, *lpdwTextBkColor	, path.c_str());
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL WriteDesktopProfile (LPCTSTR lpszDirectory, LPCTSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
#ifdef UNICODE
	return WriteDesktopProfileW(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
#else
	return WriteDesktopProfileA(lpszDirectory, lpszImagePath, lpdwTextColor, lpdwTextBkColor);
#endif
}
/// WriteDesktopProfile Q
BOOL WriteDesktopProfileA(LPCSTR  lpszDirectory, LPCSTR  lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	LPCSTR p = path.c_str();
	WritePrivateProfileStringA(s_app_nameA, s_sec_imageA, lpszImagePath, p);
	WritePrivateProfileStringA(s_app_nameA, s_sec_attributesA, "1", p);
	CHAR val[128];
	LPSTR pval1 = nullptr;
	LPSTR pval2 = nullptr;
	if( lpdwTextColor != nullptr )
	{
		wsprintfA(val, "0x%0.8x", *lpdwTextColor);
		pval1 = val;
	}
	WritePrivateProfileStringA(s_app_nameA, s_sec_colorA, pval1, p);
	if( lpdwTextBkColor != nullptr )
	{
		wsprintfA(val, "0x%0.8x", *lpdwTextBkColor);
		pval2 = val;
	}
	WritePrivateProfileStringA(s_app_nameA, s_sec_bkcolorA, pval2, p);
	// tH_̑ύX
	SetFileAttributesA(lpszDirectory, GetFileAttributesA(lpszDirectory) | FILE_ATTRIBUTE_SYSTEM );
	SetFileAttributesA(p, FILE_ATTRIBUTE_SYSTEM|FILE_ATTRIBUTE_HIDDEN );
	return TRUE;
}
/// WriteDesktopProfile Q
BOOL WriteDesktopProfileW(LPCWSTR lpszDirectory, LPCWSTR lpszImagePath, LPDWORD lpdwTextColor, LPDWORD lpdwTextBkColor)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	LPCWSTR p = path.c_str();
	WritePrivateProfileStringW(s_app_nameW, s_sec_imageW, lpszImagePath, p);
	WritePrivateProfileStringW(s_app_nameW, s_sec_attributesW, L"1", p);
	WCHAR val[128];
	LPWSTR pval1 = nullptr;
	LPWSTR pval2 = nullptr;
	if( lpdwTextColor != nullptr )
	{
		wsprintfW(val, L"0x%0.8x", *lpdwTextColor);
		pval1 = val;
	}
	WritePrivateProfileStringW(s_app_nameW, s_sec_colorW, pval1, p);
	if( lpdwTextBkColor != nullptr )
	{
		wsprintfW(val, L"0x%0.8x", *lpdwTextBkColor);
		pval2 = val;
	}
	WritePrivateProfileStringW(s_app_nameW, s_sec_bkcolorW, pval2, p);
	// tH_̑ύX
	SetFileAttributesW(lpszDirectory, GetFileAttributesW(lpszDirectory) | FILE_ATTRIBUTE_SYSTEM );
	SetFileAttributesW(p, FILE_ATTRIBUTE_SYSTEM|FILE_ATTRIBUTE_HIDDEN );
	return TRUE;
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL ClearDesktopProfile (LPCTSTR lpszDirectory)
{
#ifdef UNICODE
	return ClearDesktopProfileW(lpszDirectory);
#else
	return ClearDesktopProfileA(lpszDirectory);
#endif
}
/// ClearDesktopProfile Q
BOOL ClearDesktopProfileA(LPCSTR  lpszDirectory)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::string path = lpszDirectory;
	path += "\\Desktop.ini";
	LPCSTR p = path.c_str();
	return WritePrivateProfileStringA(s_app_nameA, nullptr, nullptr, p);
}
/// ClearDesktopProfile Q
BOOL ClearDesktopProfileW(LPCWSTR lpszDirectory)
{
	if( lpszDirectory == nullptr ) return FALSE;
	std::wstring path = lpszDirectory;
	path += L"\\Desktop.ini";
	LPCWSTR p = path.c_str();
	return WritePrivateProfileStringW(s_app_nameW, nullptr, nullptr, p);
}

//======================================================================
// class
/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CDesktopProfile::CDesktopProfile(void)
: m_dwTextColor(0)
, m_dwTextBkColor(0xFFFFFFFF)
{
	ZeroMemory( m_ImagePath, sizeof(m_ImagePath) );
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CDesktopProfile::~CDesktopProfile(void)
{
}

/**********************************************************************//**
 *
 * ǂݍ
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CDesktopProfile::Read(LPCTSTR lpszDirectory)
{
	std::_tstring path = lpszDirectory;
	path += TEXT("\\Desktop.ini");
	Open(path.c_str());
	if( !MakeProfileList() ) return FALSE;
	return ReadDesktopProfile(lpszDirectory, m_ImagePath, MAX_PATH, &m_dwTextColor, &m_dwTextBkColor);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CDesktopProfile::Write(LPCTSTR lpszDirectory)
{
	return WriteDesktopProfile(lpszDirectory, m_ImagePath, &m_dwTextColor, &m_dwTextBkColor);
}

/**********************************************************************//**
 *
 * 
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CDesktopProfile::Write(LPCTSTR lpszDirectory, bool bImage, bool bColor, bool bBkColor)
{
	return WriteDesktopProfile(lpszDirectory, bImage ? m_ImagePath : nullptr
		, bColor ? &m_dwTextColor : nullptr
		, bBkColor ? &m_dwTextBkColor : nullptr );
}

/**********************************************************************//**
 *
 * NA
 *
 -----------------------------------------------------------------------
 * @param [in]	lpszDirectory	= fBNgpX
 * @return	
*//***********************************************************************/
BOOL CDesktopProfile::Clear(LPCTSTR lpszDirectory)
{
	return ClearDesktopProfile(lpszDirectory);
}

void CDesktopProfile::SetImagePath(LPCTSTR lpszPath)
{
	_tcscpy_s(m_ImagePath, MAX_PATH, lpszPath);
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
#include "../../debug/unittest/WXDebugUnitTest.h"
#include "../../shell/WXShell.h"
#include "iris.h"
#include "iris_iostream.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDesktopProfileUnitTest,WXDesktopProfileUnitTest)
{
	TCHAR dir[MAX_PATH];
	GetCurrentDirectory(MAX_PATH, dir);
	CDesktopProfile dp;
	dp.Read(dir);
	dp.SetTextColor(0x000000FF);
	dp.SetTextBkColor(0x00FF0000);
	if( !dp.Write(dir) ) return;

	Execute(nullptr, TEXT("open"), TEXT("explorer"), dir, nullptr, SW_SHOW);

	std::cout << "tH_āAȂɂ͂ĂBݒɖ߂܂B" << std::endl;
	getchar();

	dp.WriteList(true);

	Execute(nullptr, TEXT("open"), TEXT("explorer"), dir, nullptr, SW_SHOW);

}

#endif	// #if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST))
