//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXStackTrace.cpp
 * @brief		X^bNg[XNX t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 *
 * @par			copyright
 * Copyright (C) 2010 t.sirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXStackTrace_CPP_

//======================================================================
// include
#include "WXStackTrace.h"
#include "iris_debug.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// typedef
typedef BOOL (WINAPI *PFN_DuplicateHandle)(HANDLE hSourceProcessHandle, HANDLE hSourceHandle
	  , HANDLE hTargetProcessHandle, LPHANDLE lpTargetHandle, DWORD dwDesiredAccess, BOOL bInheritHandle, DWORD dwOptions);


//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CStackTrace::CStackTrace(void)
: m_hCurrentProcess(nullptr)
, m_hCurrentThread(nullptr)
{
	m_pfnDuplicateHandle = reinterpret_cast<PROC>(::DuplicateHandle);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CStackTrace::~CStackTrace(void)
{
	End();
}

/**********************************************************************//**
 *
 * Jn
 *
 -----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CStackTrace::Begin(void)
{
	IRIS_ASSERT( m_hCurrentProcess == nullptr );
	IRIS_ASSERT( m_hCurrentThread == nullptr );

	HANDLE hProcess = ::GetCurrentProcess();
	HANDLE hThreadTmp = ::GetCurrentThread();
	HANDLE hThread = nullptr;

	if( !reinterpret_cast<PFN_DuplicateHandle>(*m_pfnDuplicateHandle)(hProcess, hThreadTmp, hProcess, &hThread, 0 , FALSE , DUPLICATE_SAME_ACCESS) )
	{
		return false;
	}
	m_hCurrentProcess = hProcess;
	m_hCurrentThread = hThread;
	return true;
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CStackTrace::End(void)
{
	if( m_hCurrentThread != nullptr )
		CloseHandle(m_hCurrentThread);
	m_hCurrentProcess = nullptr;
	m_hCurrentThread = nullptr;
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris
