//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXObjLeakCheck.cpp
 * @brief		IuWFNgnh[N`FbN t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXObjLeakCheck_CPP_

//======================================================================
// include
#include "WXObjLeakCheck.h"

#ifdef _IRIS_DEBUG
#include "fnd/container/FndScopedLock.h"
#include "../../os/WXCriticalSection.h"
#include "../../base/WXError.h"
#include "iris_debug.h"
#include <dbghelp.h>
#include <tchar.h>

//======================================================================
// link
#pragma	comment(lib,"dbghelp.lib")

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// variable
static CObjLeakCheck	s_ObjLeakCheck;

namespace
{

//======================================================================
// struct
typedef struct _tagObjectList
{
	void*	object;
	PROC	close;
	char*	file;
	int		line;
	int		count;
	_tagObjectList*	next;
} ObjectList;

//======================================================================
// define
#define APIHOOK_BEGIN()		int i=0;			\
	HMODULE hModule = GetModuleHandle(nullptr);	\
	if( hModule == nullptr ) return false

#define APIHOOK(dll, OriginName)							\
	if( !m_##OriginName.OpenA(dll, #OriginName, hModule) )	\
		return false;										\
	m_##OriginName.Replace((PROC)Hook_##OriginName)

#define APIHOOK_END()

#define HOOK_FUNC(ret, OriginName, args)			\
	typedef ret (WINAPI *PFN_##OriginName)##args;	\
	CProcHook	m_##OriginName;						\
	static ret	WINAPI Hook_##OriginName##args

#define HOOK_FUNC_NAME(OriginName)	Hook_##OriginName

#define GET_ORIGIN_FUNC(OriginName)	\
	CObjLeakCheckImpl::GetInstance().m_##OriginName.GetOriginProc()

//======================================================================
// class
// NX
class CObjLeakCheckImpl : public IIrisObject
{
	typedef fnd::CScopedLock<CCriticalSection> CCSScopedLock;
protected:
	HANDLE		m_Heap;
	ObjectList*	m_pTop;
	ObjectList*	m_pLast;
	int			m_AllocCount;
	CCriticalSection	m_CS;

protected:
	// tbN֐`
	HOOK_FUNC(HANDLE, OpenEventA	, (DWORD dwDesiredAccess, BOOL bInheritHandle, LPCSTR lpName))
	{
		HANDLE hdle = ((PFN_OpenEventA)GET_ORIGIN_FUNC(OpenEventA))(dwDesiredAccess, bInheritHandle, lpName);
		if( hdle != nullptr && hdle != INVALID_HANDLE_VALUE )
		{
			CObjLeakCheckImpl::GetInstance().Add(hdle, GET_ORIGIN_FUNC(CloseHandle));
		}
		return hdle;
	}

	HOOK_FUNC(BOOL	, CloseHandle	, (HANDLE hObject))
	{
		BOOL ret = ((PFN_CloseHandle)GET_ORIGIN_FUNC(CloseHandle))(hObject);
		if( ret )
		{
			CObjLeakCheckImpl::GetInstance().Remove(hObject, GET_ORIGIN_FUNC(CloseHandle));
		}
		return ret;
	}

public:
	static CObjLeakCheckImpl&	GetInstance(void)	{ static CObjLeakCheckImpl impl; return impl; }
private:
	// RXgN^
	CObjLeakCheckImpl(void)
		: m_pTop(nullptr)
		, m_Heap(nullptr)
		, m_pLast(nullptr)
	{
	}

	// fXgN^
	~CObjLeakCheckImpl(void)
	{
		// V{GW̒~
		::SymCleanup(::GetCurrentProcess());

		Clear();
		if( m_Heap != nullptr )
			HeapDestroy(m_Heap);
	}

public:
	// 
	bool	Initialize(void)
	{
		m_AllocCount = 0;

		// Xgpq[v쐬
		m_Heap = HeapCreate(HEAP_GENERATE_EXCEPTIONS, sizeof(ObjectList)*256, 0);
		if( m_Heap == INVALID_HANDLE_VALUE ) return false;

		DWORD option = ::SymGetOptions();
		option |= SYMOPT_LOAD_LINES;
		option &= ~SYMOPT_UNDNAME;
		::SymSetOptions(option);

		// V{GW̏
		::SymInitialize(::GetCurrentProcess(), NULL , TRUE);

		if( !BeginHook() ) return false;
		return true;
	}

	// I
	void	Terminate(void)
	{
	}

public:
	// Xgɒǉ
	void	Add(void* lpObject, PROC pfnClose)
	{
		CLocalLastError e;
		ObjectList* p = (ObjectList*)(HeapAlloc(m_Heap, 0, sizeof(ObjectList)));
		if( p != nullptr )
		{
			IRIS_WARNING("memory alloc failed.");
			return;
		}

		p->close = pfnClose;
		p->object = lpObject;
		p->count = m_AllocCount++;
		p->next = nullptr;

		CCSScopedLock lock(m_CS);

		if( m_pTop != nullptr )
		{
			IRIS_ASSERT( m_pLast != nullptr );
			m_pLast->next = p;
		}
		else
		{
			IRIS_ASSERT( m_pLast == nullptr );
			m_pTop = p;
		}
		m_pLast = p;
	}
	// Xg폜
	void	Remove(void* lpObject, PROC pfnClose)
	{
		CLocalLastError e;
		CCSScopedLock lock(m_CS);

		ObjectList* pre = nullptr;
		ObjectList* p = m_pTop;
		while(p != nullptr)
		{
			if( p->object == lpObject && p->close == pfnClose )
			{
				break;
			}
			pre = p;
			p = p->next;
		}
		if( p == nullptr )
		{
			return;
		}
		if( pre == nullptr )
		{
			IRIS_ASSERT( m_pTop == p );
			m_pTop = p->next;
			if( m_pLast == p )
			{
				m_pLast = p->next;
				IRIS_ASSERT( m_pLast == nullptr );
			}
		}
		else
		{
			pre->next = p->next;
			if( m_pLast == p )
			{
				m_pLast = pre;
				IRIS_ASSERT( pre->next == nullptr );
			}
		}
		HeapFree(m_Heap, 0, p);
	}


private:
	// XgNA
	void	Clear(void)
	{
		CCSScopedLock lock(m_CS);
		ObjectList* pre = nullptr;
		ObjectList* p = m_pTop;

		while(p != nullptr)
		{
			pre = p;
			HeapFree(m_Heap, 0, pre);
			p = p->next;
		}
	}

	// [NXg̏o
	void	ShowLeakList(void)
	{
		CCSScopedLock lock(m_CS);
		ObjectList* p = m_pTop;
		if( m_pTop != nullptr )
		{
			dbgoutputA("---------- OBJECT Leak!! ----------\r\n");
			while( p != nullptr )
			{
				CHAR buffer[1024];
				wsprintfA(buffer, "%s(%d) : [%d] Object=%p\r\n", p->file, p->line, p->count, p->object);
				dbgoutputA(buffer);
			}
			dbgoutputA("-----------------------------------\r\n");
		}
	}


private:
	// tbNJn
	bool	BeginHook(void)
	{
		APIHOOK_BEGIN();

		APIHOOK("kernel32.dll", OpenEventA);
		//APIHOOK("kernel32.dll", CreateEventA);
		//APIHOOK("kernel32.dll", CreateProcessA);
		//APIHOOK("kernel32.dll", CreateFileA);
		//APIHOOK("kernel32.dll", CreateFileMappingA);
		//APIHOOK("kernel32.dll", OpenFileMappingA);
		//APIHOOK("kernel32.dll", CreateThread);
		//APIHOOK("kernel32.dll", CreateMutexA);
		//APIHOOK("kernel32.dll", OpenMutexA);
		//APIHOOK("kernel32.dll", CreateSemaphoreA);
		//APIHOOK("kernel32.dll", OpenSemaphoreA);
		//APIHOOK("kernel32.dll", CreateNamedPipeA);
		//APIHOOK("kernel32.dll", CreatePipe);
		//APIHOOK("kernel32.dll", FindFirstFileA);
		//APIHOOK("kernel32.dll", FindClose);
		//APIHOOK("kernel32.dll", CreateToolhelp32Snapshot);

		//APIHOOK("kernel32.dll", RegOpenKeyExA);
		//APIHOOK("kernel32.dll", RegOpenKeyA);
		//APIHOOK("kernel32.dll", RegConnectRegistryA);
		//APIHOOK("kernel32.dll", RegCloseKey);
		//APIHOOK("kernel32.dll", RegCreateKeyExA);
		//APIHOOK("kernel32.dll", RegCreateKeyA);

		APIHOOK("kernel32.dll", CloseHandle);

		APIHOOK_END();
		return true;
	}
};

}

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CObjLeakCheck::CObjLeakCheck(void)
{
	CObjLeakCheckImpl::GetInstance().Initialize();
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CObjLeakCheck::~CObjLeakCheck(void)
{
	CObjLeakCheckImpl::GetInstance().Terminate();
}

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
