//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugHelp.cpp
 * @brief		dbghelp t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXDebugHelp_CPP_

//======================================================================
// include
#include "WXDebugHelp.h"
#include "iris_iostream.h"
#include <dbghelp.h>

//======================================================================
// link
#pragma	comment(lib,"dbghelp.lib")

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * 
 * 
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool DumpDllFunctionName(HMODULE hModule)
{
	ULONG	nSize;
	char**	ppszFunctionName;
	WORD*	pwFunctionOrdinal;
	IMAGE_EXPORT_DIRECTORY*	pImageExportDir;
	pImageExportDir = (IMAGE_EXPORT_DIRECTORY*)::ImageDirectoryEntryToData(
		(PVOID)hModule,
		TRUE,
		IMAGE_DIRECTORY_ENTRY_EXPORT,
		&nSize);
	if(pImageExportDir == NULL)
	{
		return false;
	}

	//pImageExportDir̃AhXhModulȇΓIȃAhX
	ppszFunctionName	= (char**)(pImageExportDir->AddressOfNames + (ULONGLONG)hModule);
	pwFunctionOrdinal	= (WORD*)(pImageExportDir->AddressOfNameOrdinals + (ULONGLONG)hModule);

	std::cout.setf( std::ios::hex );
	for(DWORD i = 0; i < pImageExportDir->NumberOfFunctions; i++)
	{
		std::cout.setf( std::ios::dec );
		std::cout << "F" << pImageExportDir->Base + i ;
		std::cout.unsetf( std::ios::dec );
		std::cout << "(0x" << pImageExportDir->Base + i << "j";

		for(DWORD j = 0; j < pImageExportDir->NumberOfNames; j++)
		{
			if(pwFunctionOrdinal[j] != i)		// pwFunctionOrdinal[j]͏ł͂ȂCfbNX
				continue;

			// hModulȇ΃AhXŊ֐i[Ă
			std::cout << "@֐F" << (char*)(ppszFunctionName[j] + (ULONGLONG)hModule) << std::endl;
			break;
		}
	}
	return true;
}

}	// end of namespace wx
}	// end of namespace iris

#if (defined(_IRIS_UNITTEST) || defined(_IRIS_MULTI_UNITTEST) )
#include "unit/UnitCore.h"
#include "../../os/WXModule.h"
#include "iris_iostream.h"
#include "iris.h"

//======================================================================
// test
IRIS_UNITTEST(CWXDebugHelpUnitTest, WXDebugHelpUnitTest)
{
	printf("dll̃pX͂ĂB\n");
	CHAR path[MAX_PATH];
	std::cin >> path;
	
	CModule module;
	if( !module.LoadA(path) ) return;

	DumpDllFunctionName(module);

}

#endif