//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDebugConsole.h
 * @brief		fobOpR\[o͊֐Qt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDebugConsole_H_
#define _IRIS_WXDebugConsole_H_

//======================================================================
// include
#include "../base/WXConsole.h"

namespace iris {
namespace wx {
namespace dbg
{

//======================================================================
// declare
class CDebugConsole;

//======================================================================
// typedef
/// CDebugConsoleCxg֐|C^
typedef bool (*PFN_DebugConsoleInputEvent)(LPCTSTR buf, DWORD dwSize);

//======================================================================
// function

#ifdef _IRIS_DEBUG
	// fobOpR\[NX擾
	CDebugConsole*	GetDebugConsole(void);

	bool	DebugConsoleOpen(bool page_sys, bool std=true);
	void	DebugConsoleClose(void);
	void	outA(LPCSTR  format, ...);
	void	outW(LPCWSTR format, ...);
	void	out (LPCTSTR format, ...);

#else
	// fobOpR\[NX擾
	inline CDebugConsole*	GetDebugConsole(void)	{ return nullptr; }

	inline void DebugConsoleOpen(bool,bool)	{}	// empty
	inline void DebugConsoleClose()			{}	// empty
	inline void outA(...)					{}	// empty
	inline void outW(...)					{}	// empty
	inline void out(...)					{}	// empty
#endif

//======================================================================
// class
//! R\[NXifobOpgj
class CDebugConsole : public CConsole
{
private:
	fnd::CRefCounter			m_Ref;		//!< QƃJE^
	PFN_DebugConsoleInputEvent	m_Event;	//!< Cxg֐|C^
	bool						m_bPageSys;	//!< y[WVXe̗L
public:
	// RXgN^
	CDebugConsole(void);
	// fXgN^
	~CDebugConsole(void);
public:
	// J
	virtual bool	Open(bool page_sys, bool std=true);
	// 
	virtual void	Close(void);
	// wvo
	virtual	void	PutsHelp(void);
public:
	// ͑҂
	void	WaitInput(void);
	// ftHgCxg
	bool	DefaultEvent(LPCTSTR buf, DWORD dwSize);
	// Cxg֐ݒ
	void	SetEventFunc(PFN_DebugConsoleInputEvent func)	{ m_Event = func; }
public:
	// R\[Cxgnh
	static	BOOL WINAPI CtrlEventHandler(DWORD CtrlType);
};

}	// end of namespace dbg
}	// end of namespace wx
}	// end of namespace iris

#endif
