//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEditBox.h
 * @brief		GfBbg{bNXRg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXEditBox_H_
#define _IRIS_WXEditBox_H_

//======================================================================
// include
#include "WXSubClass.h"

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CEditBox;

//======================================================================
// function
// windowsx.hɒ`Ă̂̓Rg
// ҏW삪邩ǂ
//BOOL		Edit_CanUndo(HWND hWnd);
// NCAgWÄʒuɍł߂CfbNX擾
DWORD		Edit_CharFormPos(HWND hWnd, int cx, int cy);
BOOL		Edit_CharFormPos(HWND hWnd, int cx, int cy, int& rCharIndex, int& rLineIndex);
// Rg[̎tONA
//void		Edit_EmptyUndoBuffer(HWND hWnd);
// s̃GfBbg Rg[Ƀ\tgs܂߂邩ǂݒ
//BOOL		Edit_FmtLines(HWND hWnd, BOOL bAddEOL);
// 1ԏ̉s擾(sGfBbg Rg[)
//int		Edit_GetFirstVisibleLine(HWND hWnd);
// ݊蓖ĂĂ郁nh擾(sGfBbg Rg[)
//HLOCAL	Edit_GetHandle(HWND hWnd);
//
LRESULT		Edit_GetIMEStatus(HWND hWnd, WPARAM wParam);
// ݒ\ȃeLXg̍őoCg擾
int			Edit_GetLimitText(HWND hWnd);
// eLXgs擾
//int		Edit_GetLine(HWND hWnd, int nLine, LPTSTR lpch, int cchMax);
// s擾(sGfBbg Rg[)
//int		Edit_GetLineCount(HWND hWnd);
// Ẽ}[W擾(sGfBbg Rg[)
DWORD		Edit_GetMargins(HWND hWnd);
BOOL		Edit_GetMargins(HWND hWnd, int& rLeft, int& rRight);
// ύXԂ̎擾
//BOOL		Edit_GetModify(HWND hWnd);
// pX[h擾
//TCHAR		Edit_GetPasswordChar(HWND hWnd);
// wp̗̈擾
//void		Edit_GetRect(HWND hWnd, LPRECT lprc);
// Iڂ̊JnƏÏʒu̎擾
//DWORD		Edit_GetSel(HWND hWnd);
// XN[o[̈ʒu擾(sGfBbg Rg[)
int			Edit_GetThumb(HWND hWnd);
// [hbv֐̎擾
//EDITWORDBREAKPROC		Edit_GetWordBreakProc(HWND hWnd);
// ݒ\ȃeLXg̍őoCgݒ
//void		Edit_LimitText(HWND hWnd, int cchMax);
// w肳ꂽCfbNXs̍sԍ擾
//int		Edit_LineFromChar(HWND hWnd, int ich);
// s̕CfbNX擾(sGfBbg Rg[)
//int		Edit_LineIndex(HWND hWnd, int nLine);
// s̒擾
//int		Edit_LineLength(HWND hWnd, int nLine);
// Cӂ̕ɃXN[
void		Edit_LineScroll(HWND hWnd, int nVScroll, int nHScroll);
// CfbNX̍Wl擾
DWORD		Edit_PosFromChar(HWND hWnd, int nCharIndex);
BOOL		Edit_PosFromChar(HWND hWnd, int nCharIndex, int& rX, int& rY);
// ݑIĂeLXgu
//void		Edit_ReplaceSel(HWND hWnd, LPCTSTR lpszReplace);
// GfBbgRg[XN[ăLbg\
//BOOL		Edit_ScrollCaret(HWND hWnd);
// s̃GfBbg Rg[Ŏg郍[J ւ̃nhݒ
//void		Edit_SetHandle(HWND hWnd, HLOCAL hLocal);
//
LRESULT		Edit_SetIMEStatus(HWND hWnd, WPARAM wParam, LPARAM lParam);
// ݒ\ȃeLXg̍őoCgݒ
void		Edit_SetLimitText(HWND hWnd, int cchMax);
// Ẽ}[Wݒ
void		Edit_SetMargins(HWND hWnd, int nLeftMargin, int nRightMargin, UINT uFlags=(EC_LEFTMARGIN|EC_RIGHTMARGIN));
// ύXԂ̐ݒ
//void		Edit_SetModify(HWND hWnd, BOOL bModify);
// pX[h̐ݒƉ
//void		Edit_SetPasswordChar(HWND hWnd, TCHAR ch);
// ǂݎpԂݒ
//BOOL		Edit_SetReadOnly(HWND hWnd, BOOL bReadOnly);
// w肳ꂽWgė̈ݒ
//void		Edit_SetRect(HWND hWnd, const LPRECT lprc);
// wp̗̈ݒ(sGfBbg Rg[)
//void		Edit_SetRectNoPaint(HWND hWnd, const LPRECT lprc);
// Iڂ̊JnƏÏʒu̐ݒ
//void		Edit_SetSel(HWND hWnd, int nStart, int nEnd);
// ^u Xgbvݒ
//void		Edit_SetTabStops(HWND hWnd, int nTabs, LPINT lpTabs);
// [hbv֐̐ݒ
//void		Edit_SetWordBreakProc(HWND hWnd, EDITWORDBREAKPROC lpfnWordBreak);
// AhD
//BOOL		Edit_Undo(HWND hWnd);
// ɃXN[
void		Edit_VScroll(HWND hWnd, UINT uScroll);

//======================================================================
// class
//! GfBbg{bNXRg[
class CEditBox : public CSubClass
{
public:
	// RXgN^
	CEditBox(void);
	CEditBox(HWND hWnd);
	// fXgN^
	~CEditBox(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

    // EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

public:
	// g֐
	// Iڂ̊JnƏÏʒu̎擾
	virtual	void		GetSel(LONG& rFirst, LONG& rLast);

public:
	// wrap
	// ҏW삪邩ǂ
	BOOL				CanUndo(void);
	// NCAgWÄʒuɍł߂CfbNX擾
	DWORD				CharFormPos(int cx, int cy);
	BOOL				CharFormPos(int cx, int cy, int& rCharIndex, int& rLineIndex);
	// Rg[̎tONA
	void				EmptyUndoBuffer(void);
	// s̃GfBbg Rg[Ƀ\tgs܂߂邩ǂݒ
	BOOL				FmtLines(BOOL bAddEOL);
	// 1ԏ̉s擾(sGfBbg Rg[)
	int					GetFirstVisibleLine(void);
	// ݊蓖ĂĂ郁nh擾(sGfBbg Rg[)
	HLOCAL				GetHandle(void);
	//
	LRESULT				GetIMEStatus(WPARAM wParam);
	// ݒ\ȃeLXg̍őoCg擾
	int					GetLimitText(void);
	// eLXgs擾
	int					GetLine(int nLine, LPTSTR lpch, int cchMax);
	// s擾(sGfBbg Rg[)
	int					GetLineCount(void);
	// Ẽ}[W擾(sGfBbg Rg[)
	DWORD				GetMargins(void);
	BOOL				GetMargins(int& rLeft, int& rRight);
	// ύXԂ̎擾
	BOOL				GetModify(void);
	// pX[h擾
	TCHAR				GetPasswordChar(void);
	// wp̗̈擾
	void				GetRect(LPRECT lprc);
	// Iڂ̊JnƏÏʒu̎擾
	DWORD				GetSel(void);
	// XN[o[̈ʒu擾(sGfBbg Rg[)
	int					GetThumb(void);
	// [hbv֐̎擾
	EDITWORDBREAKPROC	GetWordBreakProc(void);
	// ݒ\ȃeLXg̍őoCgݒ
	virtual	void		LimitText(int cchMax);
	// w肳ꂽCfbNXs̍sԍ擾
	virtual	int			LineFromChar(int ich);
	// s̕CfbNX擾(sGfBbg Rg[)
	int					LineIndex(int nLine);
	// s̒擾
	int					LineLength(int nLine);
	// Cӂ̕ɃXN[
	void				LineScroll(int nVScroll, int nHScroll);
	// CfbNX̍Wl擾
	DWORD				PosFromChar(int nCharIndex);
	BOOL				PosFromChar(int nCharIndex, int& rX, int& rY);
	// ݑIĂeLXgu
	void				ReplaceSel(LPCTSTR lpszReplace);
	// GfBbgRg[XN[ăLbg\
	BOOL				ScrollCaret(void);
	// s̃GfBbg Rg[Ŏg郍[J ւ̃nhݒ
	void				SetHandle(HLOCAL hLocal);
	//
	LRESULT				SetIMEStatus(WPARAM wParam, LPARAM lParam);
	// ݒ\ȃeLXg̍őoCgݒ
	void				SetLimitText(int cchMax);
	// Ẽ}[Wݒ
	void				SetMargins(int nLeftMargin, int nRightMargin, UINT uFlags=(EC_LEFTMARGIN|EC_RIGHTMARGIN));
	// ύXԂ̐ݒ
	void				SetModify(BOOL bModify);
	// pX[h̐ݒƉ
	void				SetPasswordChar(TCHAR ch);
	// ǂݎpԂݒ
	BOOL				SetReadOnly(BOOL bReadOnly);
	// w肳ꂽWgė̈ݒ
	void				SetRect(const LPRECT lprc);
	// wp̗̈ݒ(sGfBbg Rg[)
	void				SetRectNoPaint(const LPRECT lprc);
	// Iڂ̊JnƏÏʒu̐ݒ
	virtual	void		SetSel(LONG nStart, LONG nEnd);
	// ^u Xgbvݒ
	void				SetTabStops(int nTabs, LPINT lpTabs);
	// [hbv֐̐ݒ
	void				SetWordBreakProc(EDITWORDBREAKPROC lpfnWordBreak);
	// AhD
	BOOL				Undo(void);
	// ɃXN[
	void				VScroll(UINT uScroll);
};

}	// end of namespace wx
}	// end of namespace iris

#endif
