//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComControl.h
 * @brief		CommonControlt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXComControl_H_
#define _IRIS_WXComControl_H_

//======================================================================
// include
#include "iris_object.h"
#include <commctrl.h>

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CComCtrl;

//======================================================================
// function
// Rg[̔zF擾
BOOL		ComControl_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
// CCM_GETDROPTARGET
void		ComControl_GetDropTarget(HWND hWnd, IDropTarget** lpDropTarget);
// CCM_GETUNICODEFORMAT
BOOL		ComConrtol_GetUnicodeFormat(HWND hWnd);
// wiF̕ύX
COLORREF	ComControl_SetBkColor(HWND hWnd, COLORREF color);
// Rg[̔zFݒ
void		ComControl_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme);
// CCM_SETUNICODEFORMAT
BOOL		ComControl_SetUnicodeFormat(HWND hWnd, BOOL bUnicode);
// CCM_SETVERSION
BOOL		ComControl_SetVersion(HWND hWnd, DWORD dwVersion);
// CCM_SETWINDOWTHEME
LRESULT		ComControl_SetWindowTheme(HWND hWnd, WPARAM wParam, LPARAM lParam);

//======================================================================
// class
//! ComControlNX
class CComCtrl : public IIrisObject
{
private:
	static	DWORD	s_dwICC;
public:
	// RXgN^
	CComCtrl(void);
	// fXgN^
	~CComCtrl(void);
public:
	// 
	static	BOOL	Initialize(DWORD dwICC);
	static	void	Initialize(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXComControl_H_

