//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXComControl.cpp
 * @brief		CommonControlt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXComControl_CPP_

//======================================================================
// include
#include "WXComControl.h"

#include "../debug/WXDebug.h"

//======================================================================
// link
#pragma comment ( lib, "comctl32.lib" )

namespace iris {
namespace wx
{

//======================================================================
// function
/**********************************************************************//**
 *
 * Rg[̔zF擾
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	lpClrScheme	= zF
 * @return	
*//***********************************************************************/
BOOL		ComControl_GetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, CCM_GETCOLORSCHEME, 0, (LPARAM)lpClrScheme);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * CCM_GETDROPTARGET
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd			= Ώۂ̃EBhEnh
 * @param [in]	lpDropTarget	= 
*//***********************************************************************/
void		ComControl_GetDropTarget(HWND hWnd, IDropTarget** lpDropTarget)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, CCM_GETDROPTARGET, 0, (LPARAM)lpDropTarget);
#endif
}
/**********************************************************************//**
 *
 * CCM_GETUNICODEFORMAT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @return	
*//***********************************************************************/
BOOL		ComConrtol_GetUnicodeFormat(HWND hWnd)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, CCM_GETUNICODEFORMAT, 0, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * wiF̕ύX
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= Ώۂ̃EBhEnh
 * @param [in]	color	= F
 * @return	ȑO̐F
*//***********************************************************************/
COLORREF	ComControl_SetBkColor(HWND hWnd, COLORREF color)
{
#if (_WIN32_IE >= 0x0400)
	return (COLORREF)SendMessage(hWnd, CCM_SETBKCOLOR, 0, (LPARAM)color);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * Rg[̔zFݒ
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	lpClrScheme	= zF
*//***********************************************************************/
void		ComControl_SetColorScheme(HWND hWnd, LPCOLORSCHEME lpClrScheme)
{
#if (_WIN32_IE >= 0x0400)
	SendMessage(hWnd, CCM_SETCOLORSCHEME, 0, (LPARAM)lpClrScheme);
#endif
}
/**********************************************************************//**
 *
 * CCM_SETUNICODEFORMAT
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bUnicode	= 
 * @return	ȑO̒l
*//***********************************************************************/
BOOL		ComControl_SetUnicodeFormat(HWND hWnd, BOOL bUnicode)
{
#if (_WIN32_IE >= 0x0400)
	return (BOOL)SendMessage(hWnd, CCM_SETUNICODEFORMAT, (WPARAM)bUnicode, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * CCM_SETVERSION
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	dwVersion	= 
 * @return	ȑO̒l
*//***********************************************************************/
BOOL		ComControl_SetVersion(HWND hWnd, DWORD dwVersion)
{
#if (_WIN32_IE >= 0x0500)
	return (BOOL)SendMessage(hWnd, CCM_SETVERSION, (WPARAM)dwVersion, 0);
#else
	return 0;
#endif
}
/**********************************************************************//**
 *
 * CCM_SETWINDOWTHEME
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd		= Ώۂ̃EBhEnh
 * @param [in]	bUnicode	= 
 * @return	ȑO̒l
*//***********************************************************************/
LRESULT		ComControl_SetWindowTheme(HWND hWnd, WPARAM wParam, LPARAM lParam)
{
#if (_WIN32_WINNT >= 0x501)
	return SendMessage(hWnd, CCM_SETWINDOWTHEME, wParam, lParam);
#else
	return 0;
#endif
}

//======================================================================
// variable
DWORD CComCtrl::s_dwICC = 0;

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CComCtrl::CComCtrl(void)
{
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CComCtrl::~CComCtrl(void)
{
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @param [in]	dwICC	= [hRg[NX̃rbg}XN(ICC_***)
 * @return	
*//***********************************************************************/
BOOL CComCtrl::Initialize(DWORD dwICC)
{
	DWORD icc = dwICC | ~s_dwICC; 
	if( icc == 0 ) return 1;

	INITCOMMONCONTROLSEX iccex;
	iccex.dwSize = sizeof(iccex);
	iccex.dwICC	 = icc;
	//iccex.dwICC	 = s_dwICC | dwICC;
	BOOL ret = InitCommonControlsEx(&iccex);
	if( ret ) s_dwICC |= dwICC;
	return ret;
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
void CComCtrl::Initialize(void)
{
	InitCommonControls();
	s_dwICC = 0xFFFFFFFF;
}

}	// end of namespace wx
}	// end of namespace iris
