//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXCheckListBox.h
 * @brief		`FbN{^tXg{bNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXCheckListBox_H_
#define _IRIS_WXCheckListBox_H_

//======================================================================
// include
#include "WXListBox.h"
#include <vector>

//======================================================================
// define
// bZ[W
// `FbNԎ擾
// lParam = int(CfbNX)
#define CLB_GETCHECK	BM_GETCHECK
// `FbNԐݒ
// lParam = int(CfbNX)
#define CLB_SETCHECK	BM_SETCHECK

// Notify
#define CLBN_CLICKED	BN_CLICKED

namespace iris {
namespace wx
{

//======================================================================
// declare
class CCheckData;

//======================================================================
// class
//! `FbN{bNXtXg{bNXNX
class CCheckListBox : public CListBox
{
protected:
	typedef CCheckData	WX_CHECK_DATA;
	typedef CCheckData	*LPWX_CHECK_DATA;
public:
	// Ǘ̃`FbNf[^
	typedef std::vector<LPWX_CHECK_DATA>	vecCheckData;
protected:
	vecCheckData m_Data;
public:
	// RXgN^
	CCheckListBox(void);
	CCheckListBox(HWND hWnd);
	// fXgN^
	~CCheckListBox(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

	// EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
	// evV[W󂯂bZ[WM
	virtual	LRESULT	RecvParentMessage(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);

public:
	// OnwerDraw
	int		OwnerDraw(LPDRAWITEMSTRUCT lpdi); 
	// `FbNԂ̎擾
	BOOL	GetCheck(int nIndex);
	// `FbNԂ̐ݒ
	LRESULT	SetCheck(int nIndex, BOOL Check);
protected:
	// 
	LPWX_CHECK_DATA		FindCheckData(void* pData);
private:
	// f[^̉
	void				ReleaseCheckData(void);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXCheckListBox_H_

