//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXButton.h
 * @brief		{^Rg[t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXButton_H_
#define _IRIS_WXButton_H_

//======================================================================
// include
#include "WXSubClass.h"

namespace iris {
namespace wx
{

//======================================================================
// declare 
class CButton;

//======================================================================
// function
// windowsx.hɒ`Ă̂̓Rg
// BM_CLICK
void	Button_Click(HWND hWnd);
// BM_GETCHECK
//BOOL	Button_GetCheck(HWND hWnd);
// BM_GETIMAGE
LRESULT	Button_GetImage(HWND hWnd, int Image);
// BM_GETSTATE
//int		Button_GetState(HWND hWnd);
// BM_SETCHECK
//void	Button_SetCheck(HWND hWnd, BOOL Check);
// BM_SETIMAGE
LRESULT	Button_SetImage(HWND hWnd, int Image, LPARAM hImage);
// BM_SETSTATE
//LRESULT	Button_SetState(HWND hWnd, int State);
// BM_SETSTYLE
//void	Button_SetStyle(HWND hWnd, DWORD dwStyle, BOOL ReDraw);

//======================================================================
// class
//! {^Rg[
class CButton : public CSubClass
{
public:
	// RXgN^
	CButton(void);
	CButton(HWND hWnd);
	// fXgN^
	~CButton(void);
public:
    // EBhE̍쐬
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND Create(DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );

	// EBhE̍쐬
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, const RECT &rRect
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void* pParam=nullptr );
    virtual HWND CreateEx(DWORD dwExStyle
					, DWORD dwStyle
					, LPCTSTR lpszWindowName
					, int x, int y, int w, int h
					, HWND hWndParent, UINT nID
					, HINSTANCE hInstance
					, void *pParam = nullptr );
protected:
    // EBhEvV[W
	virtual LRESULT WndProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
public:
	// wrap
	// BM_CLICK
	void	Click(void);
	// BM_GETCHECK
	BOOL	GetCheck(void);
	// BM_GETIMAGE
	LRESULT	GetImage(int Image);
	// BM_GETSTATE
	int		GetState(void);
	// BM_SETCHECK
	void	SetCheck(BOOL Check);
	// BM_SETIMAGE
	LRESULT	SetImage(int Image, LPARAM hImage);
	// BM_SETSTATE
	LRESULT	SetState(int State);
	// BM_SETSTYLE
	void	SetStyle(DWORD dwStyle, BOOL ReDraw);
};

}	// end of namespace wx
}	// end of namespace iris

#endif	// _WXButton_H_
