//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXHandle.h
 * @brief		nhx[XNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXHandle_H_
#define _IRIS_WXHandle_H_

//======================================================================
// include
#include "iris_object.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! nhNX
class CHandle : public INonCopyObject
{
protected:
	HANDLE	m_hObject;			//!< nh
public:
	/// RXgN^
	CHandle(void)
		: m_hObject(nullptr)		{}
	/// RXgN^
	CHandle(HANDLE hObject)
		: m_hObject(nullptr)		{ Attach(hObject); }
	
	/// fXgN^
	virtual ~CHandle(void)			{ Close(); }

	HANDLE					GetHandle(void)		{ return m_hObject; }
				operator	HANDLE (void)		{ return GetHandle(); }
	HANDLE		operator	() (void)			{ return GetHandle(); }
	CHandle&	operator	= (HANDLE hdl)		{ Attach(hdl); return *this; }
	
public:
	/// nh֘At
	BOOL	Attach(HANDLE hObject)
	{
		if( hObject == nullptr || m_hObject != nullptr ) return FALSE;
		m_hObject = hObject;
		return TRUE;
	}
	/// nh̊֘At
	HANDLE	Detach(void)
	{
		HANDLE hPre = m_hObject;
		m_hObject = nullptr;
		return hPre;
	}

public:
	/// 
	virtual	BOOL	Close(void)	{ return CloseHandle( Detach() ); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif
