//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXEnumWindows.h
 * @brief		EnumWindows t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXEnumWindows_H_
#define _IRIS_WXEnumWindows_H_

//======================================================================
// include
#include "iris_object.h"
#include <map>

namespace iris {
namespace wx
{

//======================================================================
// class
/// EnumWindows NX
class CEnumWindows : public IIrisObject
{
public:
	typedef int	CONTROLID;
	typedef std::multimap<CONTROLID, HWND>	MAP;
	typedef std::pair<CONTROLID, HWND>		PAIR;

	typedef enum 
	{
		FINE_NONE		= 0x000000000,	//!< Ȃ
		FIND_RECURSION	= 0x000000001,	//!< ċAIɏEBhE
	} FINDFLAG;

protected:
	HWND	m_hParent;	//!< eEBhE
	MAP		m_Map;		//!< EBhEXg
	DWORD	m_dwFlags;	//!< tO

public:
	// RXgN^
	CEnumWindows(void);
	// fXgN^
	~CEnumWindows(void);

public:
	// 
			void	Initialize(HWND hParent, DWORD dwFindFlags);
	// XV
	virtual void	Update(void);

	// LȏԂǂ
			bool	IsValid(void);

public:
	// Rg[ID 猟
	MAP::iterator	Find(CONTROLID ctrlID);
	size_t			Count(CONTROLID ctrlID);
	HWND			GetWindow(CONTROLID ctrlID);

public:
	// LvV猟
	template<typename _FUNC, typename _TN>
	HWND			FindFromCaption(const _FUNC& func, const _TN& rhs)
	{
#ifdef UNICODE
		return FindFromCaptionW(func, rhs);
#else
		return FindFromCaptionA(func, rhs);
#endif
	}
	template<typename _FUNC, typename _TN>
	HWND			FindFromCaptionA(const _FUNC& func, const _TN& rhs)
	{
		CHAR text[512];
		for( MAP::iterator it=m_Map.begin(), end=m_Map.end(); it != end; ++it )
		{
			HWND hWnd = it->second;
			if( ::IsWindow(it->second) )
			{
				::GetWindowTextA(hWnd, text, 512);
				if( func(text, rhs) )	return hWnd;
			}
		}
		return nullptr;
	}
	template<typename _FUNC, typename _TN>
	HWND			FindFromCaptionW(const _FUNC& func, const _TN& rhs)
	{
		WCHAR text[512];
		for( MAP::iterator it=m_Map.begin(), end=m_Map.end(); it != end; ++it )
		{
			HWND hWnd = it->second;
			if( ::IsWindow(it->second) )
			{
				::GetWindowTextW(hWnd, text, 512);
				if( func(text, rhs) )	return hWnd;
			}
		}
		return nullptr;
	}

public:
	// NX猟
	template<typename _FUNC, typename _TN>
	HWND			FindFromClassName(const _FUNC& func, const _TN& rhs)
	{
#ifdef UNICODE
		return FindFromClassNameW(func, rhs);
#else
		return FindFromClassNameA(func, rhs);
#endif
	}
	template<typename _FUNC, typename _TN>
	HWND			FindFromClassNameA(const _FUNC& func, const _TN& rhs)
	{
		CHAR text[512];
		for( MAP::iterator it=m_Map.begin(), end=m_Map.end(); it != end; ++it )
		{
			HWND hWnd = it->second;
			if( ::IsWindow(it->second) )
			{
				::GetClassNameA(hWnd, text, 512);
				if( func(text, rhs) )	return hWnd;
			}
		}
		return nullptr;
	}
	template<typename _FUNC, typename _TN>
	HWND			FindFromClassNameW(const _FUNC& func, const _TN& rhs)
	{
		WCHAR text[512];
		for( MAP::iterator it=m_Map.begin(), end=m_Map.end(); it != end; ++it )
		{
			HWND hWnd = it->second;
			if( ::IsWindow(it->second) )
			{
				::GetClassNameW(hWnd, text, 512);
				if( func(text, rhs) )	return hWnd;
			}
		}
		return nullptr;
	}

public:
	// }bv̎擾
	MAP&	GetMap(void)	{ return m_Map; }

protected:
	// 񋓊֐
	static BOOL CALLBACK _EnumWindowsProc(HWND hWnd, LPARAM lParam);
	static BOOL CALLBACK _EnumChildWindowsProc(HWND hWnd, LPARAM lParam);
};

/// [U[g EnumWindows NX
template<class _TC=CEnumWindows>
class CEnumWindowsEx : public CEnumWindows
{
	typedef _TC	TARGET;
public:
	// XV
	virtual void	Update(void)
	{
		m_Map.clear();
		if( m_hParent == nullptr )
			::EnumWindows(TARGET::_EnumWindowsProc, reinterpret_cast<LPARAM>(this));
		else
			::EnumChildWindows(m_hParent, TARGET::_EnumChildWindowsProc, reinterpret_cast<LPARAM>(this));
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif
