//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMDIApplication.h
 * @brief		MDIAvP[Vx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXMDIApplication_H_
#define _IRIS_WXMDIApplication_H_

//======================================================================
// include
#include "WXApplication.h"
#include "WXMDIDocument.h"
#include "fnd/utility/FndFlag.h"
#include <map>

namespace iris {
namespace wx
{

//======================================================================
// declare
template<class _TC>class CMDIApplication;

//======================================================================
// function
// WNDENUMPROC
extern	BOOL CALLBACK MDICloseAllEnumFunc(HWND hWnd, LPARAM lp);

//======================================================================
// define
// MDĨCxg
#define __IrisMDIEventFuncName( name ) OnMDI##name
// MDĨCxg
#define __IrisMDIEventFunc( name )					\
	virtual LRESULT __IrisMDIEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)
// MDĨCxg`
#define __IrisMDIEventFuncImpl( cls, name )			\
	LRESULT cls::__IrisMDIEventFuncName(name)(HWND hWnd, WPARAM wParam, LPARAM lParam)

//======================================================================
// class
//! MDIAvP[VC^[tFCXNX
class IMDIApplication : public CApplication
{
public:
	typedef CMDIDocument*	ptr;
	// 
	typedef std::map<HWND,ptr>		Map;
	typedef std::pair<HWND,ptr>		Pair;

	typedef enum
	{
		MAF_TRANS_ALL	= 0x00000001,	//!< ׂĂMDIhLgXViw肵ȂꍇAANeBuȃhLĝݍXVj
	} FLAGS;

protected:
	static IMDIApplication* s_pApp;
	TCHAR			m_DocName[256];	//!< hLg
	HWND			m_hMDIClient;	//!< MDIeEBhEnh
	fnd::CFlag		m_Flags;		//!< tO

private:
	Map		m_Doc;

public:

	// RXgN^
	IMDIApplication(LPCTSTR AppName);
	// fXgN^
	virtual ~IMDIApplication();

public:
    /// EBhEvV[W
    static LRESULT CALLBACK DocumentProc( HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam );
protected:
	/// hLgpEBhEvV[W
	LRESULT DocProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	/// ftHgEBhEvV[W
	virtual LRESULT DefWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam);
	/// 
	virtual bool	OnInit(void);
	// I
	virtual void	Term(void);
	/// XV
	virtual void	Transaction(void);
	/// ANZ[^L[̊mF
	virtual int		Accelerator(MSG* msg);

protected:
	/// MDIJ
	HWND CreateMDIWindow(LPCTSTR title, DWORD style, int width, int height, LPARAM lParam=0);

	/// MDIpj[nh̎擾
	virtual HMENU	GetMDIMenuHandle(bool isDoc)		{ return GetMenu(); }
	/// MDIEBhEpj[nh̎擾
	virtual HMENU	GetMDIWindowMenuHandle(HMENU hMenu)	{ return nullptr; }

public:
	/// qEBhE̎擾
	HWND	GetChildWindow(void)				{ return GetWindow(m_hMDIClient, GW_CHILD); }
	/// ANeBuMDIqEBhE̎擾
	HWND	MDIGetActive(void)					{ return reinterpret_cast<HWND>(::SendMessage(m_hMDIClient, WM_MDIGETACTIVE, 0, 0)); }
	/// wMDIqEBhEANeBuɂ
	void	MDIActivate(HWND hChild)			{ ::SendMessage(m_hMDIClient, WM_MDIACTIVATE, (WPARAM)hChild, 0); }
	/// wMDIqEBhE̎܂͑ÕEBhEANeBuɂ
	void	MDINext(HWND hChild, BOOL bPrev)	{ ::SendMessage(m_hMDIClient, WM_MDINEXT, (WPARAM)hChild, (LPARAM)bPrev); }
	/// MDIqEBhE
	void	MDIDestroy(HWND hChild)				{ ::SendMessage(m_hMDIClient, WM_MDIDESTROY, (WPARAM)hChild, 0); }

	/// wMDIqEBhEő剻
	void	MDIMaximize(HWND hChild)			{ ::SendMessage(m_hMDIClient, WM_MDIMAXIMIZE, (WPARAM)hChild, 0); }
	/// wMDIqEBhẼTCYɖ߂
	void	MDIRestore(HWND hChild)				{ ::SendMessage(m_hMDIClient, WM_MDIRESTORE, (WPARAM)hChild, 0); }

	// MDIɃj[ݒ
	void	MDISetMenu(HMENU hMenu, HMENU hWindowMenu);
	/// MDIEBhEj[̍XV
	HMENU	MDIRefreshMenu(void)				{ return (HMENU)::SendMessage(m_hMDIClient, WM_MDIREFRESHMENU, 0, 0); }

	// EBhE
	/// d˂ĕ\
	BOOL	MDICascade(void)		{ return (BOOL)::SendMessage(m_hMDIClient, WM_MDICASCADE, 0, 0); }
	/// ㉺ɕׂĕ\
	BOOL	MDITileH(void)			{ return (BOOL)::SendMessage(m_hMDIClient, WM_MDITILE	, (WPARAM)MDITILE_HORIZONTAL, 0); }
	/// Eɕׂĕ\
	BOOL	MDITileV(void)			{ return (BOOL)::SendMessage(m_hMDIClient, WM_MDITILE	, (WPARAM)MDITILE_VERTICAL, 0); }
	/// ŏEBhE̐
	void	MDIIconarRange(void)	{ ::SendMessage(m_hMDIClient, WM_MDIICONARRANGE, 0, 0); }

	/// MDIqEBhEnhׂĂɑ΂āA֐s
	BOOL	EnumChildWindows(WNDENUMPROC lpEnumFunc, LPARAM lParam)	{ return ::EnumChildWindows(m_hMDIClient, lpEnumFunc, lParam); }

protected:
	// Cxgnh
	__IrisAppEventFunc(Create);
	__IrisAppEventFunc(Size);
	__IrisMDIEventFunc(MDIActivate);

protected:
	// C^[tFCX
	virtual ptr		New(HWND hWnd, LPARAM lParam) = 0;
	virtual void	Delete(ptr p) = 0;
	virtual ptr		Find(HWND hWnd)	{ Map::iterator it = m_Doc.find(hWnd); if( it == m_Doc.end() ) return nullptr; return it->second; }
};

//======================================================================
/**
 * @brief		MDIAvP[VNX
 * @template	T	hLgNX
*/
template<class _TC>
class CMDIApplication : public IMDIApplication
{
public:
	typedef _TC			CUser;
	typedef _TC*		user_ptr;
public:
	CMDIApplication(LPCTSTR AppName) : IMDIApplication(AppName) {}
	virtual ~CMDIApplication(void) {}
public:
	virtual ptr		New(HWND hWnd, LPARAM lParam)	
	{ 
		CUser::DOCPARAMS pm;
		pm.cbSize = sizeof(CUser::DOCPARAMS);
		pm.lParam = lParam;
		ptr p = new CUser(hWnd, &pm);
		return p; 
	}
	virtual void		Delete(ptr p)		{ delete p; }
	virtual user_ptr	Find(HWND hWnd)		{ return static_cast<user_ptr>(IMDIApplication::Find(hWnd)); }
};

}	// end of namespace wx
}	// end of namespace iris

#endif