//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDlgBase.h
 * @brief		_CAO{t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDlgBase_H_
#define _IRIS_WXDlgBase_H_

//======================================================================
// include
#include "WXWindow.h"

namespace iris {
namespace wx
{

//======================================================================
// define
#define DLG_FRAME	7

//======================================================================
// macros
// DlgProc֐
#define __DlgProc( cls )	(DLGPROC)cls##DlgProc

// DlgProcwb_[t@Cɍ쐬
#define __DlgProc_h( cls ) 										\
	INT_PTR CALLBACK cls##DlgProc(HWND hDlg, UINT message		\
								, WPARAM wParam, LPARAM lParam)

// DlgProc\[Xt@Cɍ쐬
#define __DlgProc_cpp( cls )									\
	INT_PTR CALLBACK cls##DlgProc(HWND hDlg, UINT message		\
								, WPARAM wParam, LPARAM lParam)	\
	{															\
		cls& rDlg = cls::GetInstance();							\
		return rDlg.DlgProc( hDlg, message, wParam, lParam );	\
	}	

// _CAÕCxg
#define __IrisDlgEventFuncName( name ) OnDlg##name
// _CAÕCxg
#define __IrisDlgEventFunc( name )					\
	virtual INT_PTR __IrisDlgEventFuncName(name)(HWND hDlg, WPARAM wParam, LPARAM lParam)
// _CAÕCxg֐̈warning̏p
#define __IrisDlgEventUnusedVariable()				\
	IRIS_UNUSED_VARIABLE(hDlg);	IRIS_UNUSED_VARIABLE(wParam); IRIS_UNUSED_VARIABLE(lParam)
// _CAÕCxg`
#define __IrisDlgEventFuncImpl( cls, name )			\
	INT_PTR cls::__IrisDlgEventFuncName(name)(HWND hDlg, WPARAM wParam, LPARAM lParam)


//======================================================================
// class
//! _CAONX
class CDlgBase : virtual public CWindow
{
protected:
	// 
	INT_PTR	m_ExitCode;

public:
	// RXgN^
	CDlgBase(void);
	// fXgN^
	virtual ~CDlgBase(void);

public:
	// ANZ[^L[̊mF
	virtual int  Accelerator(MSG* msg);

public:
	// CreateDialog
	HWND	CreateDialogParamA(HINSTANCE hInst, LPCSTR  lpTemplateName, HWND hParent, DLGPROC lpDlgProc=_DefDlgProc, LPARAM lParam = 0 );
	HWND	CreateDialogParamW(HINSTANCE hInst, LPCWSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc=_DefDlgProc, LPARAM lParam = 0 );
	// DialogBox
	INT_PTR	DialogBoxParamA(HINSTANCE hInst, LPCSTR  lpTemplateName, HWND hParent, DLGPROC lpDlgProc=_DefDlgProc, LPARAM lParam = 0 );
	INT_PTR	DialogBoxParamW(HINSTANCE hInst, LPCWSTR lpTemplateName, HWND hParent, DLGPROC lpDlgProc=_DefDlgProc, LPARAM lParam = 0 );
	// [__CAO
	INT_PTR	ModalDialogBox(void);
	BOOL	EndDialog(INT_PTR nResult)				{ m_ExitCode = nResult; return ::EndDialog(m_hWnd, nResult); }
	BOOL	EndDialog(HWND hDlg, INT_PTR nResult)	{ m_ExitCode = nResult; return ::EndDialog(hDlg, nResult); }
	INT_PTR	GetExitCode(void)						{ return m_ExitCode; }

	//HWND	GetDlgItem(int nID)		{ return ::GetDlgItem(m_hWnd, nID); }

public:
    // EBhEvV[W
	static	INT_PTR CALLBACK	_DefDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam) { return _DefWindowProc(hWnd, uMsg, wParam, lParam); }
	virtual INT_PTR				DlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam);
protected:
	// DLGPROC
	virtual LRESULT				WndProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam) { return DlgProc(hDlg,message,wParam,lParam); }

public:
	// wrap
	HWND	GetDlgItem(int nIDDlgItem)	{ return ::GetDlgItem(m_hWnd, nIDDlgItem); }
protected:

	// Cxgnh
	// trueԂƃftHg̏sȂ
	__IrisDlgEventFunc( Destroy			) { __IrisDlgEventUnusedVariable(); return TRUE; }
	__IrisDlgEventFunc( Move			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Size			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( SetFocus		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( KillFocus		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Enable			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Paint			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Close			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	//__IrisDlgEventFunc( QueryEndSesssion) { return FALSE; }
	//__IrisDlgEventFunc( QueryOpen		) { return FALSE; }
	__IrisDlgEventFunc( QueryDragIcon	) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( WindowPosChanging){ __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( WindowPosChanged) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( DrawItem		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( MeasurItem		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Notify			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( GetMinMaxInfo	) { __IrisDlgEventUnusedVariable(); return FALSE; }
	//__IrisDlgEventFunc( Power			) { return FALSE; }
	__IrisDlgEventFunc( Help			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( NotifyFormat	);
	__IrisDlgEventFunc( GetIcon			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( GetDlgCode		) { __IrisDlgEventUnusedVariable(); return 0; }	// DLGC_*
	__IrisDlgEventFunc( KeyDown			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( KeyUp			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Char			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( DeadChar		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( SysKeyDown		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( SysKeyUp		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	//__IrisDlgEventFunc( SysChar		) { return FALSE; }
	//__IrisDlgEventFunc( SysDeadChar	) { return FALSE; }
	__IrisDlgEventFunc( InitDialog		) { __IrisDlgEventUnusedVariable(); return TRUE; }
	__IrisDlgEventFunc( Command			);
	__IrisDlgEventFunc( SysCommand		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( Timer			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( HScroll			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( VScroll			) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( InitMenu		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( InitMenuPopup	) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( MenuSelect		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( MenuChar		) { __IrisDlgEventUnusedVariable(); return FALSE; }
	__IrisDlgEventFunc( DropFiles		) { __IrisDlgEventUnusedVariable(); return FALSE; }

};

}	// end of namespace wx
}	// end of namespace iris

#endif	// #ifndef _WXDlgBase_H_
