//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDXMDIApplication.h
 * @brief		DirectX MDIAvP[Vx[Xt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDXMDIApplication_H_
#define _IRIS_WXDXMDIApplication_H_

//======================================================================
// include
#include "../../d3dx/gx/DXDevice.h"
#include "WXMDIApplication.h"

namespace iris {
namespace wx
{

//======================================================================
/**
 * @brief		MDIAvP[VNX
 * @template	T	hLgNX
*/
template<class _TC>
class CDXMDIApplication : public CMDIApplication<_TC>
{
	typedef CMDIApplication<_TC> _Base;
protected:
	dx::CDXDevice	m_Device;	//!< foCXNX
public:
	CDXMDIApplication(LPCTSTR AppName) : _Base(AppName), m_Device(nullptr) {}
	virtual ~CDXMDIApplication(void) {}

public:
	virtual ptr		New(HWND hWnd, LPARAM lParam)	
	{ 
		CUser::DXDOCPARAMS pm;
		pm.cbSize = sizeof(CUser::DXDOCPARAMS);
		pm.lParam = lParam;
		pm.pDevice = &m_Device;
		ptr p = new CUser(hWnd,&pm);
		return p; 
	}

	/// 
	//virtual bool	OnInit(void)
	//{
	//	if( !CMDIApplication::OnInit() ) return false;
	//	RECT rc;
	//	::GetClientRect(m_hMDIClient, &rc);
	//	// foCX̍쐬
	//	m_Device.SetHWND(m_hWnd);
	//	if( !m_Device.CreateDevice(rc.right-rc.left, rc.bottom-rc.top, false, false, false, false, false, true) )
	//	{
	//		return false;
	//	}
	//	return true;
	//}
	/// ֐
	//virtual void	Transaction(void)	
	//{
	//	if( m_Device.IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_Device.RestoreDevice();
	//	CMDIApplication::Transaction();
	//}
public:
	// Cxgnh
	/// Create
	__IrisAppEventFunc(Create)
	{
		LRESULT ret = _Base::__IrisAppEventFuncName(Create)(hWnd, wParam, lParam);
		RECT rc;
		::GetClientRect(m_hMDIClient, &rc);
		// foCX̍쐬
		m_Device.SetHWND(hWnd);
		if( !m_Device.CreateDevice(rc.right-rc.left, rc.bottom-rc.top, false, false, false, false, false, true) )
		{
			return -1;
		}
		return ret;
	}
	/// Paint
	__IrisAppEventFunc(Paint)
	{
		if( m_Device.IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_Device.RestoreDevice();
		return _Base::__IrisAppEventFuncName(Paint)(hWnd, wParam, lParam);
	}
	/// SetFocus
	__IrisAppEventFunc(SetFocus)
	{
		m_Device.TestCooperativeLevel();
		if( m_Device.IsState(dx::CDXDevice::DXDS_DEVICE_LOST) ) m_Device.RestoreDevice();
		return _Base::__IrisAppEventFuncName(SetFocus)(hWnd, wParam, lParam);
	}
	/// Size
	__IrisAppEventFunc(Size)
	{
		//UINT width = LOWORD(lParam);
		//UINT height= HIWORD(lParam);
		//m_Device.ReSize(width, height);
		return _Base::__IrisAppEventFuncName(Size)(hWnd, wParam, lParam);
	}
};

}	// end of namespace wx
}	// end of namespace iris

#endif