//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXDXDoc.h
 * @brief		MDIhLgNX(DirectX)t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef _IRIS_WXDXDoc_H_
#define _IRIS_WXDXDoc_H_

//======================================================================
// include
#include "../../d3dx/gx/DXDevice.h"
#include "WXMDIDocument.h"
#include "fnd/system/FndTimer.h"

namespace iris {
namespace wx
{

//======================================================================
// class
//! MDIhLgNX(DirectX)
class CDXDoc : public CMDIDocument
{
public:
	typedef struct DXDOCPARAMS : public DOCPARAMS
	{
		dx::CDXDevice*	pDevice;
	} DXDOCPARAMS, *LPDXDOCPARAMS;
protected:
	dx::CDXDevice*		m_pDevice;		//!< foCXNX
	dx::CDXSwapChain	m_SwapChain;	//!< Xbv`FC
	fnd::ITimer*		m_pTimer;		//!< fpsp

public:
	// RXgN^
	CDXDoc(HWND hWnd, LPDOCPARAMS pDocParam, fnd::ITimer* pTimer);
	// fXgN^
	virtual ~CDXDoc(void);

public:
	// XV
	virtual void	Transaction(void);
	// XV
	virtual void	Update(float time);
	// `
	virtual void	Draw(void);

public:

	// Cxgnh
	__IrisDocEventFunc(Create);
	__IrisDocEventFunc(Paint);
	__IrisDocEventFunc(Destroy);
	__IrisDocEventFunc(Size);
	__IrisDocEventFunc(EraseBkGnd);

	__IrisDocEventFunc(SetFocus);
	__IrisDocEventFunc(KillFocus);
	__IrisDocEventFunc(Enable);
};

}	// end of namespace wx
}	// enf of namespace iris

#endif
