//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXApplication.cpp
 * @brief		AvP[VNXt@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2009-2010 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define _IRIS_WXApplication_CPP_

//======================================================================
// include
#include "WXApplication.h"
#include "../wx_inchead.h"
#include <time.h>
#include <string>
#include <tchar.h>

#include "../debug/WXDebug.h"

namespace iris {
namespace wx
{

//======================================================================
// define
#define APPEVENT_CALL(name)	__IrisAppEventFuncName(name)(hWnd,wParam,lParam)

//======================================================================
// variable

// O[õ_~[EBhEvV[WANZXpϐ
#ifndef _IRIS_WX_DLG_BASE
CApplication* CApplication::s_pApp = nullptr;
#endif

//======================================================================
// class

//**********************************************************************
//
//			EBhENXo^pEBhEvV[W
//
//**********************************************************************
#ifndef _IRIS_WX_DLG_BASE
LRESULT CALLBACK CApplication::AppWindowProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT ret = s_pApp->WndProc(hWnd, uMsg, wParam, lParam);
	s_pApp->GetWndProcSubject().SendParentMessage(hWnd, uMsg, wParam, lParam );
	return ret;
}
#endif

/**********************************************************************//**
 *
 * RXgN^
 *
 ----------------------------------------------------------------------
 * @param [in]	AppName	= AvP[V
*//***********************************************************************/
CApplication::CApplication(LPCTSTR AppName)
: m_hInst(nullptr)
, m_Atom(INVALID_ATOM)
#ifdef _IRIS_WX_CHECKMULTIBOOT
, m_hMutex(nullptr)
#endif
{
#ifndef _IRIS_WX_DLG_BASE
	IRIS_ASSERT( s_pApp == nullptr );
	s_pApp = this;
#endif
	// AvP[V
	_tcscpy_s(m_AppName , sizeof(m_AppName)/sizeof(TCHAR), AppName);
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CApplication::~CApplication()
{
#ifndef _IRIS_WX_DLG_BASE
	s_pApp = nullptr;
#endif

	Term();
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CApplication::Init()
{
	m_hInst = (HINSTANCE)GetModuleHandle(nullptr);
	// dNmF
	if(CheckMultiBoot()) return FALSE;

#ifndef _IRIS_WX_DLG_BASE
	// EBhENX̓o^
#if 0
	if(!RegisterClassEntry((WNDPROC)_DefWindowProc, m_AppName, (HBRUSH)(COLOR_WINDOW + 1)))	// std::map::find̏
#else
	if(!RegisterClassEntry((WNDPROC)AppWindowProc , m_AppName, (HBRUSH)(COLOR_WINDOW + 1)))
#endif
	{
		Error(TEXT("G[߁AAvP[VI܂B\n\n!!----->>\nEBhE̍쐬Ɏs(Ct[)"));
		return FALSE;
	}

	// EBhE̐
	HWND hWnd = OnCreateWindow();
	if( hWnd == nullptr ) return FALSE;
#endif
	return OnInit();
}

/**********************************************************************//**
 *
 * I
 *
*//***********************************************************************/
void CApplication::Term(void)
{
	// I
#ifndef _IRIS_WX_DLG_BASE
	if( m_Atom != 0 )
	{
		if( UnregisterClass(MAKEINTATOM(m_Atom), m_hInst) )
		{
			m_Atom = INVALID_ATOM;
		}
		else
		{
			if( UnregisterClass(m_AppName, m_hInst) )
				m_Atom = INVALID_ATOM;
		}
	}
#endif

#ifdef _IRIS_WX_CHECKMULTIBOOT
	ReleaseMutex(m_hMutex);
	m_hMutex = nullptr;
#endif
}

/**********************************************************************//**
 *
 * 
 *
 ----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
bool CApplication::OnInit(void)
{
	UpdateWindow();
	ShowWindow(SW_SHOW);
	return true;
}

/**********************************************************************//**
 *
 * EBhE̍쐬
 *
 ----------------------------------------------------------------------
 * @return	EBhEnh
*//***********************************************************************/
HWND CApplication::OnCreateWindow(void)
{
	HMENU hMenu	= nullptr;
#ifdef IDR_MENU1
	hMenu = LoadMenu(m_hInst, (LPCTSTR)IDR_MENU1);
#endif
	return CreateWindow(MAKEINTATOM(m_Atom), m_AppName, WS_OVERLAPPEDWINDOW
		, CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, nullptr, hMenu, m_hInst, nullptr);
}

/**********************************************************************//**
 *
 * EBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CApplication::WndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	LRESULT lr = 1;
	switch(uMsg)
	{
#if	!defined(IRIS_WIN32_WCE)
	case WM_NCCREATE:
		Attach(hWnd);
		break;
#endif
	case WM_CREATE:
		lr = APPEVENT_CALL(Create);
		if( lr == -1 ) return lr;
	// 
#ifndef _WIN32_WCE
	case WM_QUERYENDSESSION:
		lr = APPEVENT_CALL(QueryendSession);
		break;
#endif
    case WM_CLOSE:
		lr = APPEVENT_CALL(Close);
		break;
	// I
	case WM_DESTROY:
		APPEVENT_CALL(Destroy);
		PostQuitMessage(0);
		return 0;
	case WM_ACTIVATE:
		lr = APPEVENT_CALL(Activate);
		break;
	case WM_PAINT:
		lr = APPEVENT_CALL(Paint);
		break;

	// Size
	case WM_MOVE:
		lr = APPEVENT_CALL(Move);
		break;
	case WM_SIZE:
		lr = APPEVENT_CALL(Size);
		break;

	// tH[JX
	case WM_SETFOCUS:
		lr = APPEVENT_CALL(SetFocus);
		break;
	case WM_KILLFOCUS:
		lr = APPEVENT_CALL(KillFocus);
		break;
	case WM_ENABLE:
		lr = APPEVENT_CALL(Enable);
		break;

	case WM_ERASEBKGND:
		lr = APPEVENT_CALL(EraseBkGnd);
		break;
	case WM_SHOWWINDOW:
		lr = APPEVENT_CALL(ShowWindow);
		break;

	case WM_SETCURSOR:
		lr = APPEVENT_CALL(SetCursor);
		break;

#if	!defined(IRIS_WIN32_WCE)
	case WM_MOUSEACTIVATE:
		lr = APPEVENT_CALL(MouseActivate);
		break;
	case WM_CHILDACTIVATE:
		lr = APPEVENT_CALL(ChildActivate);
		break;

	case WM_GETMINMAXINFO:
		lr = APPEVENT_CALL(GetMinMaxInfo);
		break;
#endif

	case WM_DRAWITEM:
		lr = APPEVENT_CALL(DrawItem);
		break;
	case WM_MEASUREITEM:
		lr = APPEVENT_CALL(MeasureItem);
		break;

	case WM_NOTIFY:
		lr = APPEVENT_CALL(Notify);
		break;
	case WM_HELP:
		lr = APPEVENT_CALL(Help);
		break;

	// key
	case WM_KEYDOWN:
		lr = APPEVENT_CALL(KeyDown);
		break;
	case WM_KEYUP:
		lr = APPEVENT_CALL(KeyUp);
		break;
	case WM_CHAR:
		lr = APPEVENT_CALL(Char);
		break;
	case WM_DEADCHAR:
		lr = APPEVENT_CALL(DeadChar);
		break;
	case WM_SYSKEYDOWN:
		lr = APPEVENT_CALL(SysKeyDown);
		break;
	case WM_SYSKEYUP:
		lr = APPEVENT_CALL(SysKeyUp);
		break;
	case WM_SYSCHAR:
		lr = APPEVENT_CALL(SysChar);
		break;
	case WM_SYSDEADCHAR:
		lr = APPEVENT_CALL(SysDeadChar);
		break;
	case WM_KEYLAST:
		lr = APPEVENT_CALL(KeyLast);
		break;

	case WM_COMMAND:
		lr = APPEVENT_CALL(Command);
		break;
	case WM_SYSCOMMAND:
		lr = APPEVENT_CALL(SysCommand);
		break;
	case WM_TIMER:
		lr = APPEVENT_CALL(Timer);
		break;
	case WM_HSCROLL:
		lr = APPEVENT_CALL(HScroll);
		break;
	case WM_VSCROLL:
		lr = APPEVENT_CALL(VScroll);
		break;
#if	!defined(IRIS_WIN32_WCE)
	case WM_MENUSELECT:
		lr = APPEVENT_CALL(MenuSelect);
		break;
#endif
	case WM_MENUCHAR:
		lr = APPEVENT_CALL(MenuChar);
		break;
	case WM_ENTERMENULOOP:
		lr = APPEVENT_CALL(EnterMenuLoop);
		break;
	case WM_EXITMENULOOP:
		lr = APPEVENT_CALL(ExitMenuLoop);
		break;

	// mouse
	case WM_MOUSEMOVE:
		lr = APPEVENT_CALL(MouseMove);
		break;
	case WM_LBUTTONDOWN:
		lr = APPEVENT_CALL(LButtonDown);
		break;
	case WM_LBUTTONUP:
		lr = APPEVENT_CALL(LButtonUp);
		break;
	case WM_LBUTTONDBLCLK:
		lr = APPEVENT_CALL(LButtonDblClk);
		break;
	case WM_RBUTTONDOWN:
		lr = APPEVENT_CALL(RButtonDown);
		break;
	case WM_RBUTTONUP:
		lr = APPEVENT_CALL(RButtonUp);
		break;
	case WM_RBUTTONDBLCLK:
		lr = APPEVENT_CALL(RButtonDblClk);
		break;
	case WM_MBUTTONDOWN:
		lr = APPEVENT_CALL(MButtonDown);
		break;
	case WM_MBUTTONUP:
		lr = APPEVENT_CALL(MButtonUp);
		break;
	case WM_MBUTTONDBLCLK:
		lr = APPEVENT_CALL(MButtonDblClk);
		break;

#if	!defined(IRIS_WIN32_WCE)
	case WM_DROPFILES:
		lr = APPEVENT_CALL(DropFiles);
		break;

	case WM_DRAWCLIPBOARD:
		lr = APPEVENT_CALL(DrawClipboard);
		break;
#endif
	}

	if( lr != 0 )
		lr = DefWndProc(hWnd, uMsg, wParam, lParam);
	return lr;
}

/**********************************************************************//**
 *
 * ftHgEBhEvV[W
 *
 ----------------------------------------------------------------------
 * @param [in]	hWnd	= EBhEnh
 * @param [in]	uMsg	= sꂽbZ[W
 * @param [in]	wParam	= sꂽbZ[W@
 * @param [in]	lParam	= sꂽbZ[WA
 * @return	LRESULTl
*//***********************************************************************/
LRESULT CApplication::DefWndProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	return DefWindowProc(hWnd, uMsg, wParam, lParam);
}

/**********************************************************************//**
 *
 * AvP[V̎s
 *
*//***********************************************************************/
void CApplication::RunSync(void)
{
	// C[v
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while(GetMessage(&msg, nullptr, 0, 0)) 
	{
		if(!Accelerator(&msg))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		Transaction();
	}

	Term();
}

/**********************************************************************//**
 *
 * AvP[V̎s
 *
 * @note	PeekMessagegp
 *
*//***********************************************************************/
void CApplication::RunAsync(void)
{
	// C[v
	MSG msg;
	ZeroMemory(&msg, sizeof(msg));
	while(msg.message != WM_QUIT) 
	{
		while( !PeekMessage(&msg, nullptr, 0U, 0U, PM_NOREMOVE) )
		{
			Transaction();
		}
		if(GetMessage(&msg, nullptr, 0, 0))
		{
			if(!Accelerator(&msg))
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
	}

	Term();
}

/**********************************************************************//**
 *
 * ANZ[^L[̊mF
 *
 ----------------------------------------------------------------------
 * @param [in]	msg	= sꂽbZ[W
 * @return	
*//***********************************************************************/
int CApplication::Accelerator(LPMSG msg)
{
	return m_Accel.Translate(m_hWnd, msg);
}

/**********************************************************************//**
 *
 * dN̊mF
 *
 ----------------------------------------------------------------------
 * @return	dN̂ƂTRUE
*//***********************************************************************/
bool CApplication::CheckMultiBoot(void)
{
#ifdef _IRIS_WX_CHECKMULTIBOOT
	// dN̖h~pɃ~[ebNXIuWFNg쐬
	m_hMutex = CreateMutex(nullptr, TRUE, m_AppName);
	if(GetLastError() == ERROR_ALREADY_EXISTS)
	{
		DWORD atom = m_Atom & 0x0000FFFF;
		if((m_hWnd = FindWindow(reinterpret_cast<LPCTSTR>(atom), m_AppName)) != nullptr)
		{
			OpenIcon();
			// őOʂ
			SetForegroundWindow();
		}
		return true;
	}
#endif
	return false;
}

/**********************************************************************//**
 *
 * EBhENX̓o^
 *
 ----------------------------------------------------------------------
 * @param [in]	pWndProc	= EBhEvV[W
 * @param [in]	ClassName	= NX
 * @param [in]	hbrBack		= wiuV
 * @return	
*//***********************************************************************/
bool CApplication::RegisterClassEntry(WNDPROC pWndProc, LPCTSTR ClassName, HBRUSH hbrBack)
{
	// EBhENX̐ݒ
	HICON hIcon = nullptr;
#ifdef IDI_ICON1
	hIcon		= LoadIcon(m_hInst, (LPCTSTR)IDI_ICON1);
#endif
	HCURSOR hCursor = nullptr;
#ifdef IDI_ARRROW1
	hCursor		= LoadCursor(m_hInst, IDC_ARROW1);
#else
	hCursor		= LoadCursor(nullptr, IDC_ARROW);
#endif

	// EBhENX̓o^
	m_Atom = RegisterClassEx(CS_HREDRAW | CS_VREDRAW, m_hInst
		, hIcon, hCursor, hbrBack, ClassName, nullptr, hIcon, pWndProc);
	if( m_Atom == 0 )
	{
		Error(TEXT("RegisterClassEx Failed."));
		return false;
	}
	return true;
}

}	// end of namespace wx
}	// end of namespace iris
