//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		WXMSXML.cpp
 * @brief		WXMSXML t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#define INCG_IRIS_WXMSXML_CPP_

//======================================================================
// include
#include "WXMSXML.h"
#include "../io/WXHFile.h"
#include "iris_debug.h"

#ifdef _IRIS_SUPPORT_MSXML

//======================================================================
// define
#define	DOCK_XMLDOMDOCUMENT TEXT("MSXML2.DOMDocument")

namespace iris {
namespace wx
{

//======================================================================
// class

/**********************************************************************//**
 *
 * RXgN^
 *
*//***********************************************************************/
CMSXml::CMSXml(void)
{
	m_Doc = IDocumentPtr(DOCK_XMLDOMDOCUMENT);
	if( m_Doc != nullptr )
	{
		m_Doc->preserveWhiteSpace = VARIANT_FALSE;
	}
}

/**********************************************************************//**
 *
 * fXgN^
 *
*//***********************************************************************/
CMSXml::~CMSXml(void)
{
}

/**********************************************************************//**
 *
 * VK쐬
 *
 ----------------------------------------------------------------------
 * @return	
*//***********************************************************************/
bool CMSXml::Create(void)
{
	Close();
	m_Doc = IDocumentPtr(DOCK_XMLDOMDOCUMENT);
	if( m_Doc == nullptr ) return false;
	m_Doc->preserveWhiteSpace = VARIANT_FALSE;
	m_Doc->createProcessingInstruction(TEXT("xml"), TEXT("version='1.0'"));
	return true;
}

/**********************************************************************//**
 *
 * 
 *
*//***********************************************************************/
void CMSXml::Close(void)
{
	if( m_Doc != nullptr )
	{
		m_Doc->Release();
	}
}

/**********************************************************************//**
 *
 * 񂩂ǂݍ
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpszXml	= xml 
 * @return	
*//***********************************************************************/
bool CMSXml::LoadFromString(LPCTSTR lpszXml)
{
	_bstr_t bstr(lpszXml);
	m_Doc->loadXML(bstr);
	if( m_Doc->parseError->errorCode != 0 ) return false;
	return true;
}

/**********************************************************************//**
 *
 * t@Cǂݍ
 * 
 ----------------------------------------------------------------------
 * @param [in]	lpszFileName	= t@CpX
 * @return	
*//***********************************************************************/
bool CMSXml::LoadFromFile(LPCTSTR lpszFileName)
{
	CHFile file;
	if( !file.Open(lpszFileName, TEXT("rb")) ) return false;
	DWORD dwSize = file.GetSize();
	LPBYTE buf = new BYTE [dwSize+1];
	ZeroMemory(buf, dwSize+1);
	DWORD dwRead;
	file.Read(buf, dwSize, &dwRead);
	bool ret = LoadFromString(pointer_cast<LPCTSTR>(buf));
	delete [] buf;
	return ret;
}

}	// end of namespace wx
}	// end of namespace iris

#endif
