//======================================================================
//-----------------------------------------------------------------------
/**
 * @file		wx_inline.h
 * @brief		CC֐ t@C
 *
 * @author		t.sirayanagi
 * @version		1.0
 *
 * @par			copyright
 * Copyright (C) 2010-2011 Takazumi Shirayanagi\n
 * The new BSD License is applied to this software.
 * see iris_LICENSE.txt
*/
//-----------------------------------------------------------------------
//======================================================================
#ifndef INCG_IRIS_wx_inline_H_
#define INCG_IRIS_wx_inline_H_

//======================================================================
// include
#pragma warning (push)
#pragma warning (disable:4255)
#include <malloc.h>
#include <stdio.h>
#pragma warning (pop)

#if defined(__cplusplus)
extern "C" {
#endif

//======================================================================
// function
#if	defined(OutputDebugString)
STATICINLINE	void	OutputDebugStringExA(LPCSTR  lpFormat, ...)
{
	va_list va;
	va_start(va, lpFormat);
	{
#if	!defined(IRIS_WIN32_WCE)
		size_t len = _vscprintf(lpFormat, va) + 1;
#else
		size_t len = 1024;
#endif
		LPSTR str = (LPSTR)alloca(len * sizeof(CHAR));
		vsprintf_s(str, len, lpFormat, va);
		OutputDebugStringA(str);
	}
	va_end(va);
}
STATICINLINE	void	OutputDebugStringExW(LPCWSTR lpFormat, ...)
{
	va_list va;
	va_start(va, lpFormat);
	{
#if	!defined(IRIS_WIN32_WCE)
		size_t len = _vscwprintf(lpFormat, va) + 1;
#else
		size_t len = 1024;
#endif
		LPWSTR str = (LPWSTR)alloca(len * sizeof(WCHAR));
		vswprintf_s(str, len, lpFormat, va);
		OutputDebugStringW(str);
	}
	va_end(va);
}
#endif

#if defined(__cplusplus)
}
#endif

#endif
